/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.filters;

import com.google.common.base.Supplier;
import java.util.Date;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.ws.rs.core.UriBuilder;
import org.jclouds.date.TimeStamp;
import org.jclouds.http.HttpException;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpRequestFilter;
import org.jclouds.http.utils.ModifyRequest;

@Singleton
public class AddTimestampQuery
implements HttpRequestFilter {
    private final Supplier<Date> dateProvider;
    private final Provider<UriBuilder> builder;

    @Inject
    public AddTimestampQuery(@TimeStamp Supplier<Date> dateProvider, Provider<UriBuilder> builder) {
        this.builder = builder;
        this.dateProvider = dateProvider;
    }

    public HttpRequest filter(HttpRequest request) throws HttpException {
        return ModifyRequest.addQueryParam((HttpRequest)request, (String)"now", (Object)(((Date)this.dateProvider.get()).getTime() + ""), (UriBuilder)((UriBuilder)this.builder.get()));
    }
}

