/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.http.apachehc;

import com.google.common.base.Throwables;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import javax.inject.Singleton;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.FileEntity;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;
import org.jclouds.JcloudsVersion;
import org.jclouds.http.HttpRequest;
import org.jclouds.io.Payload;
import org.jclouds.io.payloads.BasePayload;
import org.jclouds.io.payloads.ByteArrayPayload;
import org.jclouds.io.payloads.DelegatingPayload;
import org.jclouds.io.payloads.FilePayload;
import org.jclouds.io.payloads.StringPayload;

@Singleton
public class ApacheHCUtils {
    public static final String USER_AGENT = String.format("jclouds/%s httpclient/%s", JcloudsVersion.get(), "4.1.1");

    public static HttpUriRequest convertToApacheRequest(HttpRequest request) {
        Object apacheRequest;
        if (request.getMethod().equals("HEAD")) {
            apacheRequest = new HttpHead(request.getEndpoint());
        } else if (request.getMethod().equals("GET")) {
            apacheRequest = new HttpGet(request.getEndpoint());
        } else if (request.getMethod().equals("DELETE")) {
            apacheRequest = new HttpDelete(request.getEndpoint());
        } else if (request.getMethod().equals("PUT")) {
            apacheRequest = new HttpPut(request.getEndpoint());
            apacheRequest.getParams().setBooleanParameter("http.protocol.expect-continue", true);
        } else if (request.getMethod().equals("POST")) {
            apacheRequest = new HttpPost(request.getEndpoint());
        } else {
            final String method = request.getMethod();
            apacheRequest = request.getPayload() != null ? new HttpEntityEnclosingRequestBase(){

                public String getMethod() {
                    return method;
                }
            } : new HttpRequestBase(){

                public String getMethod() {
                    return method;
                }
            };
            ((HttpRequestBase)HttpRequestBase.class.cast(apacheRequest)).setURI(request.getEndpoint());
        }
        Payload payload = request.getPayload();
        if (apacheRequest instanceof HttpEntityEnclosingRequest) {
            if (payload != null) {
                ApacheHCUtils.addEntityForContent((HttpEntityEnclosingRequest)HttpEntityEnclosingRequest.class.cast(apacheRequest), payload);
            }
        } else {
            apacheRequest.addHeader("Content-Length", "0");
        }
        for (String header : request.getHeaders().keySet()) {
            for (String value : request.getHeaders().get((Object)header)) {
                if (header.equals("Content-Length")) continue;
                apacheRequest.addHeader(header, value);
            }
        }
        apacheRequest.addHeader("User-Agent", USER_AGENT);
        return apacheRequest;
    }

    public static void addEntityForContent(HttpEntityEnclosingRequest apacheRequest, Payload payload) {
        Payload payload2 = payload = payload instanceof DelegatingPayload ? ((DelegatingPayload)DelegatingPayload.class.cast(payload)).getDelegate() : payload;
        if (payload instanceof StringPayload) {
            StringEntity nStringEntity = null;
            try {
                nStringEntity = new StringEntity((String)payload.getRawContent());
            }
            catch (UnsupportedEncodingException e) {
                throw new UnsupportedOperationException("Encoding not supported", e);
            }
            nStringEntity.setContentType(payload.getContentMetadata().getContentType());
            apacheRequest.setEntity((HttpEntity)nStringEntity);
        } else if (payload instanceof FilePayload) {
            apacheRequest.setEntity((HttpEntity)new FileEntity((File)payload.getRawContent(), payload.getContentMetadata().getContentType()));
        } else if (payload instanceof ByteArrayPayload) {
            ByteArrayEntity Entity = new ByteArrayEntity((byte[])payload.getRawContent());
            Entity.setContentType(payload.getContentMetadata().getContentType());
            apacheRequest.setEntity((HttpEntity)Entity);
        } else {
            InputStream inputStream = payload.getInput();
            if (payload.getContentMetadata().getContentLength() == null) {
                throw new IllegalArgumentException("you must specify size when content is an InputStream");
            }
            InputStreamEntity Entity = new InputStreamEntity(inputStream, payload.getContentMetadata().getContentLength().longValue());
            Entity.setContentType(payload.getContentMetadata().getContentType());
            apacheRequest.setEntity((HttpEntity)Entity);
        }
        if (payload.getContentMetadata().getContentDisposition() != null) {
            apacheRequest.addHeader("Content-Disposition", payload.getContentMetadata().getContentDisposition());
        }
        if (payload.getContentMetadata().getContentEncoding() != null) {
            apacheRequest.addHeader("Content-Encoding", payload.getContentMetadata().getContentEncoding());
        }
        if (payload.getContentMetadata().getContentLanguage() != null) {
            apacheRequest.addHeader("Content-Language", payload.getContentMetadata().getContentLanguage());
        }
        assert (apacheRequest.getEntity() != null);
    }

    public static class HttpEntityPayload
    extends BasePayload<HttpEntity> {
        HttpEntityPayload(HttpEntity content) {
            super((Object)content);
            this.getContentMetadata().setContentType(content.getContentType().getValue());
            this.getContentMetadata().setContentLength(Long.valueOf(content.getContentLength()));
        }

        public InputStream getInput() {
            try {
                return ((HttpEntity)this.content).getContent();
            }
            catch (IllegalStateException e) {
                Throwables.propagate((Throwable)e);
            }
            catch (IOException e) {
                Throwables.propagate((Throwable)e);
            }
            return null;
        }

        public boolean isRepeatable() {
            return ((HttpEntity)this.content).isRepeatable();
        }

        public void release() {
            try {
                ((HttpEntity)this.content).consumeContent();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void writeTo(OutputStream outstream) throws IOException {
            super.writeTo(outstream);
        }
    }
}

