/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.date.joda;

import java.util.Date;
import java.util.Locale;
import javax.inject.Singleton;
import org.jclouds.date.DateService;
import org.jclouds.date.internal.DateUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

@Singleton
public class JodaDateService
implements DateService {
    private static final DateTimeFormatter rfc822DateFormatter = DateTimeFormat.forPattern((String)"EEE, dd MMM yyyy HH:mm:ss 'GMT'").withLocale(Locale.US).withZone(DateTimeZone.forID((String)"GMT"));
    private static final DateTimeFormatter cDateFormatter = DateTimeFormat.forPattern((String)"EEE MMM dd HH:mm:ss '+0000' yyyy").withLocale(Locale.US).withZone(DateTimeZone.forID((String)"GMT"));
    private static final DateTimeFormatter iso8601SecondsDateFormatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ss'Z'").withLocale(Locale.US).withZone(DateTimeZone.forID((String)"GMT"));
    private static final DateTimeFormatter iso8601DateFormatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").withLocale(Locale.US).withZone(DateTimeZone.forID((String)"GMT"));

    public final Date fromSeconds(long seconds) {
        return new Date(seconds * 1000L);
    }

    public final String cDateFormat(Date dateTime) {
        return cDateFormatter.print((ReadableInstant)new DateTime((Object)dateTime));
    }

    public final String cDateFormat() {
        return this.cDateFormat(new Date());
    }

    public final Date cDateParse(String toParse) {
        return cDateFormatter.parseDateTime(toParse).toDate();
    }

    public final String rfc822DateFormat(Date dateTime) {
        return rfc822DateFormatter.print((ReadableInstant)new DateTime((Object)dateTime));
    }

    public final String rfc822DateFormat() {
        return this.rfc822DateFormat(new Date());
    }

    public final Date rfc822DateParse(String toParse) {
        return rfc822DateFormatter.parseDateTime(toParse).toDate();
    }

    public final String iso8601SecondsDateFormat(Date dateTime) {
        return iso8601SecondsDateFormatter.print((ReadableInstant)new DateTime((Object)dateTime));
    }

    public final String iso8601SecondsDateFormat() {
        return this.iso8601SecondsDateFormat(new Date());
    }

    public final String iso8601DateFormat(Date date) {
        return iso8601DateFormatter.print((ReadableInstant)new DateTime((Object)date));
    }

    public final String iso8601DateFormat() {
        return this.iso8601DateFormat(new Date());
    }

    public final Date iso8601DateParse(String toParse) {
        toParse = DateUtils.trimTZ((String)toParse);
        toParse = DateUtils.trimToMillis((String)toParse);
        return iso8601DateFormatter.parseDateTime(toParse).toDate();
    }

    public final Date iso8601SecondsDateParse(String toParse) {
        toParse = DateUtils.trimTZ((String)toParse);
        return iso8601SecondsDateFormatter.parseDateTime(toParse).toDate();
    }
}

