/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ssh.jsch.config;

import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Scopes;
import javax.inject.Named;
import org.jclouds.domain.Credentials;
import org.jclouds.http.handlers.BackoffLimitedRetryHandler;
import org.jclouds.net.IPSocket;
import org.jclouds.predicates.InetSocketAddressConnect;
import org.jclouds.predicates.SocketOpen;
import org.jclouds.ssh.ConfiguresSshClient;
import org.jclouds.ssh.SshClient;
import org.jclouds.ssh.jsch.JschSshClient;
import org.jclouds.util.CredentialUtils;

@ConfiguresSshClient
public class JschSshClientModule
extends AbstractModule {
    protected void configure() {
        this.bind(SshClient.Factory.class).to(Factory.class).in(Scopes.SINGLETON);
        this.bind(SocketOpen.class).to(InetSocketAddressConnect.class).in(Scopes.SINGLETON);
    }

    private static class Factory
    implements SshClient.Factory {
        @Named(value="jclouds.connection-timeout")
        @Inject(optional=true)
        int timeout = 60000;
        private final BackoffLimitedRetryHandler backoffLimitedRetryHandler;
        private final Injector injector;

        @Inject
        public Factory(BackoffLimitedRetryHandler backoffLimitedRetryHandler, Injector injector) {
            this.backoffLimitedRetryHandler = backoffLimitedRetryHandler;
            this.injector = injector;
        }

        public SshClient create(IPSocket socket, String username, String password) {
            JschSshClient client = new JschSshClient(this.backoffLimitedRetryHandler, socket, this.timeout, username, password, null);
            this.injector.injectMembers((Object)client);
            return client;
        }

        public SshClient create(IPSocket socket, String username, byte[] privateKey) {
            JschSshClient client = new JschSshClient(this.backoffLimitedRetryHandler, socket, this.timeout, username, null, privateKey);
            this.injector.injectMembers((Object)client);
            return client;
        }

        public SshClient create(IPSocket socket, Credentials credentials) {
            return CredentialUtils.isPrivateKeyCredential((Credentials)credentials) ? this.create(socket, credentials.identity, credentials.credential.getBytes()) : this.create(socket, credentials.identity, credentials.credential);
        }
    }
}

