/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ssh.jsch;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import com.google.common.io.Closeables;
import com.google.common.net.HostAndPort;
import com.google.inject.Inject;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import javax.inject.Named;
import org.apache.commons.io.input.ProxyInputStream;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.jclouds.compute.domain.ExecChannel;
import org.jclouds.compute.domain.ExecResponse;
import org.jclouds.crypto.CryptoStreams;
import org.jclouds.crypto.SshKeys;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.http.handlers.BackoffLimitedRetryHandler;
import org.jclouds.io.Payload;
import org.jclouds.io.Payloads;
import org.jclouds.logging.Logger;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.ssh.SshClient;
import org.jclouds.ssh.SshException;
import org.jclouds.ssh.jsch.SessionConnection;
import org.jclouds.util.Strings2;

public class JschSshClient
implements SshClient {
    private final String toString;
    @Inject(optional=true)
    @Named(value="jclouds.ssh.max-retries")
    @VisibleForTesting
    int sshRetries = 5;
    @Inject(optional=true)
    @Named(value="jclouds.ssh.retry-auth")
    @VisibleForTesting
    boolean retryAuth;
    @Inject(optional=true)
    @Named(value="jclouds.ssh.retryable-messages")
    @VisibleForTesting
    String retryableMessages = "failed to send channel request,channel is not opened,invalid data,End of IO Stream Read,Connection reset,connection is closed by foreign host,socket is not established";
    @Inject(optional=true)
    @Named(value="jclouds.ssh.retry-predicate")
    Predicate<Throwable> retryPredicate = Predicates.or((Predicate)Predicates.instanceOf(ConnectException.class), (Predicate)Predicates.instanceOf(IOException.class));
    @Resource
    @Named(value="jclouds.ssh")
    protected Logger logger = Logger.NULL;
    private final BackoffLimitedRetryHandler backoffLimitedRetryHandler;
    final SessionConnection sessionConnection;
    final String user;
    final String host;
    Connection<ChannelSftp> sftpConnection = new Connection<ChannelSftp>(){
        private ChannelSftp sftp;

        @Override
        public void clear() {
            if (this.sftp != null) {
                this.sftp.disconnect();
            }
        }

        @Override
        public ChannelSftp create() throws JSchException {
            JschSshClient.this.checkConnected();
            String channel = "sftp";
            this.sftp = (ChannelSftp)JschSshClient.this.sessionConnection.getSession().openChannel(channel);
            this.sftp.connect();
            return this.sftp;
        }

        public String toString() {
            return "ChannelSftp()";
        }
    };

    public JschSshClient(BackoffLimitedRetryHandler backoffLimitedRetryHandler, HostAndPort socket, LoginCredentials loginCredentials, int timeout) {
        this.user = ((LoginCredentials)Preconditions.checkNotNull((Object)loginCredentials, (Object)"loginCredentials")).getUser();
        this.host = ((HostAndPort)Preconditions.checkNotNull((Object)socket, (Object)"socket")).getHostText();
        Preconditions.checkArgument((socket.getPort() > 0 ? 1 : 0) != 0, (Object)("ssh port must be greater then zero" + socket.getPort()));
        Preconditions.checkArgument((loginCredentials.getPassword() != null || loginCredentials.getPrivateKey() != null ? 1 : 0) != 0, (Object)"you must specify a password or a key");
        this.backoffLimitedRetryHandler = (BackoffLimitedRetryHandler)Preconditions.checkNotNull((Object)backoffLimitedRetryHandler, (Object)"backoffLimitedRetryHandler");
        if (loginCredentials.getPrivateKey() == null) {
            this.toString = String.format("%s:pw[%s]@%s:%d", loginCredentials.getUser(), CryptoStreams.hex((byte[])CryptoStreams.md5((byte[])loginCredentials.getPassword().getBytes())), this.host, socket.getPort());
        } else {
            String fingerPrint = SshKeys.fingerprintPrivateKey((String)loginCredentials.getPrivateKey());
            String sha1 = SshKeys.sha1PrivateKey((String)loginCredentials.getPrivateKey());
            this.toString = String.format("%s:rsa[fingerprint(%s),sha1(%s)]@%s:%d", loginCredentials.getUser(), fingerPrint, sha1, this.host, socket.getPort());
        }
        this.sessionConnection = SessionConnection.builder().hostAndPort(HostAndPort.fromParts((String)this.host, (int)socket.getPort())).loginCredentials(loginCredentials).connectTimeout(timeout).sessionTimeout(timeout).build();
    }

    public void put(String path, String contents) {
        this.put(path, (Payload)Payloads.newStringPayload((String)((String)Preconditions.checkNotNull((Object)contents, (Object)"contents"))));
    }

    private void checkConnected() {
        Preconditions.checkState((this.sessionConnection.getSession() != null && this.sessionConnection.getSession().isConnected() ? 1 : 0) != 0, (Object)String.format("(%s) Session not connected!", this.toString()));
    }

    protected <T, C extends Connection<T>> T acquire(C connection) {
        connection.clear();
        String errorMessage = String.format("(%s) error acquiring %s", this.toString(), connection);
        for (int i = 0; i < this.sshRetries; ++i) {
            try {
                this.logger.debug(">> (%s) acquiring %s", new Object[]{this.toString(), connection});
                T returnVal = connection.create();
                this.logger.debug("<< (%s) acquired %s", new Object[]{this.toString(), returnVal});
                return returnVal;
            }
            catch (Exception from) {
                connection.clear();
                if (i + 1 == this.sshRetries) {
                    throw this.propagate(from, errorMessage);
                }
                if (!this.shouldRetry(from)) continue;
                this.logger.warn((Throwable)from, "<< " + errorMessage + ": " + from.getMessage(), new Object[0]);
                this.backoffForAttempt(i + 1, errorMessage + ": " + from.getMessage());
                continue;
            }
        }
        assert (false) : "should not reach here";
        return null;
    }

    public void connect() {
        this.acquire(this.sessionConnection);
    }

    public Payload get(String path) {
        return (Payload)this.acquire(new GetConnection(path));
    }

    public void put(String path, Payload contents) {
        this.acquire(new PutConnection(path, contents));
    }

    @VisibleForTesting
    boolean shouldRetry(Exception from) {
        Predicate predicate;
        Predicate predicate2 = predicate = this.retryAuth ? Predicates.or(this.retryPredicate, (Predicate)Predicates.instanceOf(AuthorizationException.class)) : this.retryPredicate;
        if (Iterables.any((Iterable)Throwables.getCausalChain((Throwable)from), (Predicate)predicate)) {
            return true;
        }
        if (!this.retryableMessages.equals("")) {
            return Iterables.any((Iterable)Splitter.on((String)",").split((CharSequence)this.retryableMessages), this.causalChainHasMessageContaining(from));
        }
        return false;
    }

    @VisibleForTesting
    Predicate<String> causalChainHasMessageContaining(final Exception from) {
        return new Predicate<String>(){

            public boolean apply(final String input) {
                return Iterables.any((Iterable)Throwables.getCausalChain((Throwable)from), (Predicate)new Predicate<Throwable>(){

                    public boolean apply(Throwable arg0) {
                        return arg0.toString().indexOf(input) != -1 || arg0.getMessage() != null && arg0.getMessage().indexOf(input) != -1;
                    }
                });
            }
        };
    }

    private void backoffForAttempt(int retryAttempt, String message) {
        this.backoffLimitedRetryHandler.imposeBackoffExponentialDelay(200L, 2, retryAttempt, this.sshRetries, message);
    }

    SshException propagate(Exception e, String message) {
        message = message + ": " + e.getMessage();
        if (e.getMessage() != null && e.getMessage().indexOf("Auth fail") != -1) {
            throw new AuthorizationException("(" + this.toString() + ") " + message, (Throwable)e);
        }
        throw e instanceof SshException ? (SshException)SshException.class.cast(e) : new SshException("(" + this.toString() + ") " + message, (Throwable)e);
    }

    public String toString() {
        return this.toString;
    }

    @PreDestroy
    public void disconnect() {
        this.sessionConnection.clear();
    }

    protected Connection<ChannelExec> execConnection(final String command) {
        Preconditions.checkNotNull((Object)command, (Object)"command");
        return new Connection<ChannelExec>(){
            private ChannelExec executor = null;

            @Override
            public void clear() {
                if (this.executor != null) {
                    this.executor.disconnect();
                }
            }

            @Override
            public ChannelExec create() throws Exception {
                JschSshClient.this.checkConnected();
                String channel = "exec";
                this.executor = (ChannelExec)JschSshClient.this.sessionConnection.getSession().openChannel(channel);
                this.executor.setPty(true);
                this.executor.setCommand(command);
                ByteArrayOutputStream error = new ByteArrayOutputStream();
                this.executor.setErrStream((OutputStream)error);
                this.executor.connect();
                return this.executor;
            }

            public String toString() {
                return "ChannelExec()";
            }
        };
    }

    public ExecResponse exec(String command) {
        return (ExecResponse)this.acquire(new ExecConnection(command));
    }

    public String getHostAddress() {
        return this.host;
    }

    public String getUsername() {
        return this.user;
    }

    public ExecChannel execChannel(String command) {
        return (ExecChannel)this.acquire(new ExecChannelConnection(command));
    }

    class ExecChannelConnection
    implements Connection<ExecChannel> {
        private final String command;
        private ChannelExec executor = null;
        private Session sessionConnection;

        ExecChannelConnection(String command) {
            this.command = (String)Preconditions.checkNotNull((Object)command, (Object)"command");
        }

        @Override
        public void clear() {
            if (this.executor != null) {
                this.executor.disconnect();
            }
            if (this.sessionConnection != null) {
                this.sessionConnection.disconnect();
            }
        }

        @Override
        public ExecChannel create() throws Exception {
            this.sessionConnection = (Session)JschSshClient.this.acquire(SessionConnection.builder().fromSessionConnection(JschSshClient.this.sessionConnection).sessionTimeout(0).build());
            String channel = "exec";
            this.executor = (ChannelExec)this.sessionConnection.openChannel(channel);
            this.executor.setCommand(this.command);
            ByteArrayOutputStream error = new ByteArrayOutputStream();
            this.executor.setErrStream((OutputStream)error);
            this.executor.connect();
            return new ExecChannel(this.executor.getOutputStream(), this.executor.getInputStream(), this.executor.getErrStream(), (Supplier)new Supplier<Integer>(){

                public Integer get() {
                    int exitStatus = ExecChannelConnection.this.executor.getExitStatus();
                    return exitStatus != -1 ? Integer.valueOf(exitStatus) : null;
                }
            }, new Closeable(){

                @Override
                public void close() throws IOException {
                    ExecChannelConnection.this.clear();
                }
            });
        }

        public String toString() {
            return "ExecChannel(command=[" + this.command + "])";
        }
    }

    class ExecConnection
    implements Connection<ExecResponse> {
        private final String command;
        private ChannelExec executor;

        ExecConnection(String command) {
            this.command = (String)Preconditions.checkNotNull((Object)command, (Object)"command");
        }

        @Override
        public void clear() {
            if (this.executor != null) {
                this.executor.disconnect();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ExecResponse create() throws Exception {
            try {
                this.executor = (ChannelExec)JschSshClient.this.acquire(JschSshClient.this.execConnection(this.command));
                String outputString = Strings2.toStringAndClose((InputStream)this.executor.getInputStream());
                int errorStatus = this.executor.getExitStatus();
                int i = 0;
                String message = String.format("bad status -1 %s", this.toString());
                while ((errorStatus = this.executor.getExitStatus()) == -1 && i < JschSshClient.this.sshRetries) {
                    JschSshClient.this.logger.warn("<< " + message, new Object[0]);
                    JschSshClient.this.backoffForAttempt(++i, message);
                }
                if (errorStatus == -1) {
                    throw new SshException(message);
                }
                String errorString = "";
                ExecResponse execResponse = new ExecResponse(outputString, errorString, errorStatus);
                return execResponse;
            }
            finally {
                this.clear();
            }
        }

        public String toString() {
            return "ExecResponse(command=[" + this.command + "])";
        }
    }

    class PutConnection
    implements Connection<Void> {
        private final String path;
        private final Payload contents;
        private ChannelSftp sftp;

        PutConnection(String path, Payload contents) {
            this.path = (String)Preconditions.checkNotNull((Object)path, (Object)"path");
            this.contents = (Payload)Preconditions.checkNotNull((Object)contents, (Object)"contents");
        }

        @Override
        public void clear() {
            if (this.sftp != null) {
                this.sftp.disconnect();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void create() throws Exception {
            this.sftp = (ChannelSftp)JschSshClient.this.acquire(JschSshClient.this.sftpConnection);
            InputStream is = (InputStream)Preconditions.checkNotNull((Object)this.contents.getInput(), (String)"inputstream for path %s", (Object[])new Object[]{this.path});
            try {
                this.sftp.put(is, this.path);
            }
            finally {
                Closeables.closeQuietly((Closeable)this.contents);
            }
            return null;
        }

        public String toString() {
            return "Put(path=[" + this.path + "])";
        }
    }

    class GetConnection
    implements Connection<Payload> {
        private final String path;
        private ChannelSftp sftp;

        GetConnection(String path) {
            this.path = (String)Preconditions.checkNotNull((Object)path, (Object)"path");
        }

        @Override
        public void clear() {
            if (this.sftp != null) {
                this.sftp.disconnect();
            }
        }

        @Override
        public Payload create() throws Exception {
            this.sftp = (ChannelSftp)JschSshClient.this.acquire(JschSshClient.this.sftpConnection);
            return Payloads.newInputStreamPayload((InputStream)((Object)new CloseFtpChannelOnCloseInputStream(this.sftp.get(this.path), this.sftp)));
        }

        public String toString() {
            return "Payload(path=[" + this.path + "])";
        }
    }

    public static interface Connection<T> {
        public void clear();

        public T create() throws Exception;
    }

    private final class CloseFtpChannelOnCloseInputStream
    extends ProxyInputStream {
        private final ChannelSftp sftp;

        private CloseFtpChannelOnCloseInputStream(InputStream proxy, ChannelSftp sftp) {
            super(proxy);
            this.sftp = sftp;
        }

        public void close() throws IOException {
            super.close();
            if (this.sftp != null) {
                this.sftp.disconnect();
            }
        }
    }
}

