/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.sshj.config;

import com.google.common.net.HostAndPort;
import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Scopes;
import javax.inject.Named;
import org.jclouds.domain.Credentials;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.http.handlers.BackoffLimitedRetryHandler;
import org.jclouds.ssh.ConfiguresSshClient;
import org.jclouds.ssh.SshClient;
import org.jclouds.sshj.SshjSshClient;

@ConfiguresSshClient
public class SshjSshClientModule
extends AbstractModule {
    protected void configure() {
        this.bind(SshClient.Factory.class).to(Factory.class).in(Scopes.SINGLETON);
    }

    private static class Factory
    implements SshClient.Factory {
        @Named(value="jclouds.connection-timeout")
        @Inject(optional=true)
        int timeout = 60000;
        private final BackoffLimitedRetryHandler backoffLimitedRetryHandler;
        private final Injector injector;

        @Inject
        public Factory(BackoffLimitedRetryHandler backoffLimitedRetryHandler, Injector injector) {
            this.backoffLimitedRetryHandler = backoffLimitedRetryHandler;
            this.injector = injector;
        }

        public SshClient create(HostAndPort socket, LoginCredentials credentials) {
            SshjSshClient client = new SshjSshClient(this.backoffLimitedRetryHandler, socket, credentials, this.timeout);
            this.injector.injectMembers((Object)client);
            return client;
        }

        public SshClient create(HostAndPort socket, Credentials credentials) {
            return this.create(socket, LoginCredentials.fromCredentials((Credentials)credentials));
        }
    }
}

