/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudsigma.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.cloudsigma.domain.DriveInfo;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.ImageBuilder;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.domain.OsFamilyVersion64Bit;
import org.jclouds.domain.Location;

@Singleton
public class PreinstalledDiskToImage
implements Function<DriveInfo, Image> {
    private final Supplier<Location> locationSupplier;
    private final Function<String, OsFamilyVersion64Bit> imageParser;

    @Inject
    public PreinstalledDiskToImage(Supplier<Location> locationSupplier, Function<String, OsFamilyVersion64Bit> imageParser) {
        this.locationSupplier = locationSupplier;
        this.imageParser = imageParser;
    }

    public Image apply(DriveInfo drive) {
        if (drive.getName() == null) {
            return null;
        }
        String description = drive.getDescription() != null ? drive.getDescription() : drive.getName();
        OperatingSystem.Builder builder = OperatingSystem.builder();
        OsFamilyVersion64Bit parsed = (OsFamilyVersion64Bit)this.imageParser.apply((Object)drive.getName());
        builder.name(drive.getName()).description(description).is64Bit(drive.getBits() != null ? drive.getBits() == 64 : parsed.is64Bit).version(parsed.version).family(parsed.family);
        return new ImageBuilder().ids(drive.getUuid()).userMetadata((Map)ImmutableMap.of((Object)"size", (Object)(drive.getSize() / 1024L / 1024L / 1024L + ""))).location((Location)this.locationSupplier.get()).name(drive.getName()).description(description).operatingSystem(builder.build()).version("").build();
    }
}

