/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudsigma.binders;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.cloudsigma.functions.ListOfMapsToListOfKeyValuesDelimitedByBlankLines;
import org.jclouds.cloudsigma.options.CloneDriveOptions;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.MapBinder;
import org.jclouds.rest.internal.GeneratedHttpRequest;

@Singleton
public class BindCloneDriveOptionsToPlainTextString
implements MapBinder {
    private final ListOfMapsToListOfKeyValuesDelimitedByBlankLines listOfMapsToListOfKeyValuesDelimitedByBlankLines;

    @Inject
    public BindCloneDriveOptionsToPlainTextString(ListOfMapsToListOfKeyValuesDelimitedByBlankLines listOfMapsToListOfKeyValuesDelimitedByBlankLines) {
        this.listOfMapsToListOfKeyValuesDelimitedByBlankLines = listOfMapsToListOfKeyValuesDelimitedByBlankLines;
    }

    public <R extends HttpRequest> R bindToRequest(R request, Map<String, Object> postParams) {
        Preconditions.checkArgument((boolean)(Preconditions.checkNotNull(request, (Object)"request") instanceof GeneratedHttpRequest), (Object)"this binder is only valid for GeneratedHttpRequests!");
        GeneratedHttpRequest gRequest = (GeneratedHttpRequest)request;
        Preconditions.checkState((gRequest.getArgs() != null ? 1 : 0) != 0, (Object)"args should be initialized at this point");
        CloneDriveOptions options = BindCloneDriveOptionsToPlainTextString.findOptionsInArgsOrNull(gRequest);
        if (options != null) {
            postParams = ImmutableMap.builder().putAll(postParams).putAll(options.getOptions()).build();
        }
        request.setPayload(this.listOfMapsToListOfKeyValuesDelimitedByBlankLines.apply((Iterable<Map<String, String>>)ImmutableSet.of((Object)Maps.transformValues((Map)postParams, (Function)new Function<Object, String>(){

            public String apply(@Nullable Object input) {
                return input == null ? null : input.toString();
            }
        }))));
        request.getPayload().getContentMetadata().setContentType("text/plain");
        return request;
    }

    static CloneDriveOptions findOptionsInArgsOrNull(GeneratedHttpRequest<?> gRequest) {
        for (Object arg : gRequest.getArgs()) {
            if (arg instanceof CloneDriveOptions) {
                return (CloneDriveOptions)arg;
            }
            if (!(arg instanceof CloneDriveOptions[])) continue;
            CloneDriveOptions[] options = (CloneDriveOptions[])arg;
            return options.length > 0 ? options[0] : null;
        }
        return null;
    }

    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        throw new UnsupportedOperationException();
    }
}

