/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.common.constant.enums;

import java.util.List;

public enum RoleIndexConfigEnum {
    ADMIN("admin1", "dashboard/Analysis2"),
    TEST("test", "dashboard/Analysis"),
    HR("hr", "dashboard/Analysis1");

    String roleCode;
    String componentUrl;

    private RoleIndexConfigEnum(String roleCode, String componentUrl) {
        this.roleCode = roleCode;
        this.componentUrl = componentUrl;
    }

    public static RoleIndexConfigEnum getEnumByCode(String roleCode) {
        for (RoleIndexConfigEnum e : RoleIndexConfigEnum.values()) {
            if (!e.roleCode.equals(roleCode)) continue;
            return e;
        }
        return null;
    }

    public static String getIndexByCode(String roleCode) {
        for (RoleIndexConfigEnum e : RoleIndexConfigEnum.values()) {
            if (!e.roleCode.equals(roleCode)) continue;
            return e.componentUrl;
        }
        return null;
    }

    public static String getIndexByRoles(List<String> roles) {
        for (String role : roles) {
            for (RoleIndexConfigEnum e : RoleIndexConfigEnum.values()) {
                if (!e.roleCode.equals(role)) continue;
                return e.componentUrl;
            }
        }
        return null;
    }

    public String getRoleCode() {
        return this.roleCode;
    }

    public void setRoleCode(String roleCode) {
        this.roleCode = roleCode;
    }

    public String getComponentUrl() {
        return this.componentUrl;
    }

    public void setComponentUrl(String componentUrl) {
        this.componentUrl = componentUrl;
    }
}

