/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.common.exception;

import org.apache.shiro.authz.AuthorizationException;
import org.apache.shiro.authz.UnauthorizedException;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.exception.JeecgBoot401Exception;
import org.jeecg.common.exception.JeecgBootException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.data.redis.connection.PoolException;
import org.springframework.http.HttpStatus;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.multipart.MaxUploadSizeExceededException;
import org.springframework.web.servlet.NoHandlerFoundException;

@RestControllerAdvice
public class JeecgBootExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(JeecgBootExceptionHandler.class);

    @ExceptionHandler(value={JeecgBootException.class})
    public Result<?> handleJeecgBootException(JeecgBootException e) {
        log.error(e.getMessage(), (Throwable)e);
        return Result.error(e.getMessage());
    }

    @ExceptionHandler(value={JeecgBoot401Exception.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    public Result<?> handleJeecgBoot401Exception(JeecgBoot401Exception e) {
        log.error(e.getMessage(), (Throwable)e);
        return new Result(401, e.getMessage());
    }

    @ExceptionHandler(value={NoHandlerFoundException.class})
    public Result<?> handlerNoFoundException(Exception e) {
        log.error(e.getMessage(), (Throwable)e);
        return Result.error(404, "\u8def\u5f84\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u8def\u5f84\u662f\u5426\u6b63\u786e");
    }

    @ExceptionHandler(value={DuplicateKeyException.class})
    public Result<?> handleDuplicateKeyException(DuplicateKeyException e) {
        log.error(e.getMessage(), (Throwable)e);
        return Result.error("\u6570\u636e\u5e93\u4e2d\u5df2\u5b58\u5728\u8be5\u8bb0\u5f55");
    }

    @ExceptionHandler(value={UnauthorizedException.class, AuthorizationException.class})
    public Result<?> handleAuthorizationException(AuthorizationException e) {
        log.error(e.getMessage(), (Throwable)e);
        return Result.noauth("\u6ca1\u6709\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u6388\u6743");
    }

    @ExceptionHandler(value={Exception.class})
    public Result<?> handleException(Exception e) {
        log.error(e.getMessage(), (Throwable)e);
        return Result.error("\u64cd\u4f5c\u5931\u8d25\uff0c" + e.getMessage());
    }

    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    public Result<?> HttpRequestMethodNotSupportedException(HttpRequestMethodNotSupportedException e) {
        StringBuffer sb = new StringBuffer();
        sb.append("\u4e0d\u652f\u6301");
        sb.append(e.getMethod());
        sb.append("\u8bf7\u6c42\u65b9\u6cd5\uff0c");
        sb.append("\u652f\u6301\u4ee5\u4e0b");
        String[] methods = e.getSupportedMethods();
        if (methods != null) {
            for (String str : methods) {
                sb.append(str);
                sb.append("\u3001");
            }
        }
        log.error(sb.toString(), (Throwable)e);
        return Result.error(405, sb.toString());
    }

    @ExceptionHandler(value={MaxUploadSizeExceededException.class})
    public Result<?> handleMaxUploadSizeExceededException(MaxUploadSizeExceededException e) {
        log.error(e.getMessage(), (Throwable)e);
        return Result.error("\u6587\u4ef6\u5927\u5c0f\u8d85\u51fa10MB\u9650\u5236, \u8bf7\u538b\u7f29\u6216\u964d\u4f4e\u6587\u4ef6\u8d28\u91cf! ");
    }

    @ExceptionHandler(value={DataIntegrityViolationException.class})
    public Result<?> handleDataIntegrityViolationException(DataIntegrityViolationException e) {
        log.error(e.getMessage(), (Throwable)e);
        return Result.error("\u5b57\u6bb5\u592a\u957f,\u8d85\u51fa\u6570\u636e\u5e93\u5b57\u6bb5\u7684\u957f\u5ea6");
    }

    @ExceptionHandler(value={PoolException.class})
    public Result<?> handlePoolException(PoolException e) {
        log.error(e.getMessage(), (Throwable)e);
        return Result.error("Redis \u8fde\u63a5\u5f02\u5e38!");
    }
}

