/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.common.util;

import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.jeecg.common.api.CommonAPI;
import org.jeecg.common.exception.JeecgBoot401Exception;
import org.jeecg.common.system.util.JwtUtil;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.common.util.RedisUtil;
import org.jeecg.common.util.oConvertUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenUtils {
    private static final Logger log = LoggerFactory.getLogger(TokenUtils.class);

    public static String getTokenByRequest(HttpServletRequest request) {
        String token = request.getParameter("token");
        if (token == null) {
            token = request.getHeader("X-Access-Token");
        }
        return token;
    }

    public static boolean verifyToken(HttpServletRequest request, CommonAPI commonAPI, RedisUtil redisUtil) {
        log.debug(" -- url --" + request.getRequestURL());
        String token = TokenUtils.getTokenByRequest(request);
        if (StringUtils.isBlank((CharSequence)token)) {
            throw new JeecgBoot401Exception("Token\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        String username = JwtUtil.getUsername(token);
        if (username == null) {
            throw new JeecgBoot401Exception("Token\u975e\u6cd5\u65e0\u6548!");
        }
        LoginUser user = commonAPI.getUserByName(username);
        if (user == null) {
            throw new JeecgBoot401Exception("\u7528\u6237\u4e0d\u5b58\u5728!");
        }
        if (user.getStatus() != 1) {
            throw new JeecgBoot401Exception("\u8d26\u53f7\u5df2\u9501\u5b9a,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458!");
        }
        if (!TokenUtils.jwtTokenRefresh(token, username, user.getPassword(), redisUtil)) {
            throw new JeecgBoot401Exception("Token\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
        }
        return true;
    }

    public static boolean verifyToken(String token, CommonAPI commonAPI, RedisUtil redisUtil) {
        if (StringUtils.isBlank((CharSequence)token)) {
            throw new JeecgBoot401Exception("token\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        String username = JwtUtil.getUsername(token);
        if (username == null) {
            throw new JeecgBoot401Exception("token\u975e\u6cd5\u65e0\u6548!");
        }
        LoginUser user = commonAPI.getUserByName(username);
        if (user == null) {
            throw new JeecgBoot401Exception("\u7528\u6237\u4e0d\u5b58\u5728!");
        }
        if (user.getStatus() != 1) {
            throw new JeecgBoot401Exception("\u8d26\u53f7\u5df2\u88ab\u9501\u5b9a,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458!");
        }
        if (!TokenUtils.jwtTokenRefresh(token, username, user.getPassword(), redisUtil)) {
            throw new JeecgBoot401Exception("Token\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55!");
        }
        return true;
    }

    private static boolean jwtTokenRefresh(String token, String userName, String passWord, RedisUtil redisUtil) {
        String cacheToken = String.valueOf(redisUtil.get("prefix_user_token_" + token));
        if (oConvertUtils.isNotEmpty(cacheToken)) {
            if (!JwtUtil.verify(cacheToken, userName, passWord)) {
                String newAuthorization = JwtUtil.sign(userName, passWord);
                redisUtil.set("prefix_user_token_" + token, (Object)newAuthorization);
                redisUtil.expire("prefix_user_token_" + token, 3600L);
            }
            return true;
        }
        return false;
    }
}

