/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.minidao.sqlparser.impl;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jeecgframework.minidao.pojo.MiniDaoPage;
import org.jeecgframework.minidao.sqlparser.AbstractSqlProcessor;
import org.jeecgframework.minidao.util.MiniDaoUtil;

public class SimpleSqlProcessor
implements AbstractSqlProcessor {
    private static final String SQLSERVER_SQL = "select * from ( select row_number() over(order by tempColumn) tempRowNumber, * from (select top {1} tempColumn = 0, {0}) t ) tt where tempRowNumber > {2}";

    @Override
    public String getSqlServerPageSql(String sql, MiniDaoPage miniDaoPage) {
        int page = miniDaoPage.getPage();
        int rows = miniDaoPage.getRows();
        Object[] sqlParam = new String[3];
        sql = MiniDaoUtil.removeOrderBy(sql);
        int beginIndex = (page - 1) * rows;
        int endIndex = beginIndex + rows;
        sqlParam[2] = Integer.toString(beginIndex);
        sqlParam[1] = Integer.toString(endIndex);
        sqlParam[0] = sql.substring(SimpleSqlProcessor.getAfterSelectInsertPoint(sql));
        sql = MessageFormat.format(SQLSERVER_SQL, sqlParam);
        return sql;
    }

    @Override
    public String getCountSql(String sql) {
        sql = MiniDaoUtil.removeOrderBy(sql);
        return "select count(0) from (" + sql + ") tmp_count";
    }

    @Override
    public String removeOrderBy(String sql) {
        if (sql == null) {
            return null;
        }
        sql = sql.replaceAll("(?i)\\s+ORDER\\s+BY\\s+[\\w\\s,.]+", "");
        return sql;
    }

    @Override
    public List<Map<String, Object>> parseSqlFields(String parsedSql) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        ArrayList<String> fields = new ArrayList<String>();
        Pattern pattern = Pattern.compile("SELECT\\s+(.*?)\\s+FROM", 2);
        Matcher matcher = pattern.matcher(parsedSql);
        if (matcher.find()) {
            String[] fieldArray;
            String selectFields = matcher.group(1);
            for (String field : fieldArray = selectFields.split(",")) {
                fields.add(field.trim());
            }
        }
        return list;
    }

    private static int getAfterSelectInsertPoint(String sql) {
        int selectIndex = sql.toLowerCase().indexOf("select");
        int selectDistinctIndex = sql.toLowerCase().indexOf("select distinct");
        return selectIndex + (selectDistinctIndex == selectIndex ? 15 : 6);
    }
}

