/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.dokka.analysis.markdown.jb;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.ast.CompositeASTNode;
import org.intellij.markdown.ast.LeafASTNode;
import org.intellij.markdown.ast.impl.ListItemCompositeNode;
import org.intellij.markdown.flavours.MarkdownFlavourDescriptor;
import org.intellij.markdown.flavours.gfm.GFMElementTypes;
import org.intellij.markdown.flavours.gfm.GFMFlavourDescriptor;
import org.intellij.markdown.flavours.gfm.GFMTokenTypes;
import org.intellij.markdown.html.HtmlGenerator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dokka.InternalDokkaApi;
import org.jetbrains.dokka.analysis.markdown.jb.Parser;
import org.jetbrains.dokka.analysis.markdown.jb.factories.DocTagsFromIElementFactory;
import org.jetbrains.dokka.links.Callable;
import org.jetbrains.dokka.links.DRI;
import org.jetbrains.dokka.links.PointingToDeclaration;
import org.jetbrains.dokka.model.doc.CustomDocTag;
import org.jetbrains.dokka.model.doc.DocTag;
import org.jetbrains.dokka.model.doc.See;
import org.jetbrains.dokka.model.doc.TagWrapper;
import org.jetbrains.dokka.model.doc.Text;
import org.jetbrains.dokka.model.doc.Throws;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0010\b\u0017\u0018\u0000 S2\u00020\u0001:\u0001SB%\u0012\u0014\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u001c\u0010\u0019\u001a\u00060\u001aj\u0002`\u001b2\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J*\u0010\u001e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u001f0\u000b2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00020\u000f0\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0016\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u000e\u0010#\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000bH\u0002J\u0016\u0010$\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0016\u0010%\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J,\u0010&\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000b2\u0006\u0010'\u001a\u00020\u00112\b\u0010(\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010)\u001a\u0004\u0018\u00010\u0011H\u0002J\u0016\u0010*\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0016\u0010+\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J.\u0010,\u001a\u00020-2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00110\u000b2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u0002002\u0006\u00102\u001a\u000200H\u0002J\u0010\u00103\u001a\u00020\u000f2\u0006\u00104\u001a\u00020\u0004H\u0016J\u0018\u00105\u001a\u0002062\u0006\u00107\u001a\u00020\u00042\u0006\u00108\u001a\u00020\u0004H\u0014J\u0010\u00109\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0004H\u0014J\u0016\u0010:\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0016\u0010;\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0012\u0010<\u001a\u0004\u0018\u00010\u00052\u0006\u0010=\u001a\u00020\u0004H\u0002J\u0016\u0010>\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0016\u0010?\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0016\u0010@\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0016\u0010A\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u001e\u0010B\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010C\u001a\u00020DH\u0002J \u0010E\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010C\u001a\u00020DH\u0002J\"\u0010F\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000b*\b\u0012\u0004\u0012\u00020\u00110\u000b2\b\b\u0002\u0010C\u001a\u00020DH\u0002J \u0010G\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000b*\b\u0012\u0004\u0012\u00020\u00110\u000b2\u0006\u0010H\u001a\u000200H\u0002J\u0018\u0010I\u001a\b\u0012\u0004\u0012\u00020\u00110\u000b*\b\u0012\u0004\u0012\u00020\u00110\u000bH\u0002J\u0018\u0010J\u001a\b\u0012\u0004\u0012\u00020\u00110\u000b*\b\u0012\u0004\u0012\u00020\u00110\u000bH\u0002J\u001a\u0010K\u001a\u00020D*\b\u0012\u0004\u0012\u00020\u00110\u000b2\u0006\u0010/\u001a\u000200H\u0002J\f\u0010K\u001a\u00020D*\u00020\u0011H\u0002J\f\u0010L\u001a\u00020D*\u00020\u0004H\u0002J\u0018\u0010M\u001a\b\u0012\u0004\u0012\u00020\u00110\u000b*\b\u0012\u0004\u0012\u00020\u00110\u000bH\u0002J\u0018\u0010N\u001a\b\u0012\u0004\u0012\u00020\u00110\u000b*\b\u0012\u0004\u0012\u00020\u00110\u000bH\u0002J \u0010O\u001a\b\u0012\u0004\u0012\u00020\u00110\u000b*\b\u0012\u0004\u0012\u00020\u00110\u000b2\u0006\u0010C\u001a\u00020DH\u0002J\f\u0010P\u001a\u00020\u0004*\u00020\u0004H\u0002J\u0018\u0010Q\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000b*\b\u0012\u0004\u0012\u00020\u000f0\u000bH\u0002J\u0018\u0010R\u001a\b\u0012\u0004\u0012\u00020\u00110\u000b*\b\u0012\u0004\u0012\u00020\u00110\u000bH\u0002R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006T"}, d2={"Lorg/jetbrains/dokka/analysis/markdown/jb/MarkdownParser;", "Lorg/jetbrains/dokka/analysis/markdown/jb/Parser;", "externalDri", "Lkotlin/Function1;", "", "Lorg/jetbrains/dokka/links/DRI;", "kdocLocation", "(Lkotlin/jvm/functions/Function1;Ljava/lang/String;)V", "destinationLinksMap", "", "notLeafNodes", "", "Lorg/intellij/markdown/IElementType;", "text", "autoLinksHandler", "Lorg/jetbrains/dokka/model/doc/DocTag;", "node", "Lorg/intellij/markdown/ast/ASTNode;", "blockquotesHandler", "cellHandler", "codeBlocksHandler", "codeFencesHandler", "codeLineHandler", "codeSpansHandler", "defaultHandler", "detailedException", "Ljava/lang/IllegalStateException;", "Lkotlin/IllegalStateException;", "baseMessage", "emphasisHandler", "getAllDestinationLinks", "Lkotlin/Pair;", "headerContentHandler", "headerHandler", "headersHandler", "horizontalRulesHandler", "imagesHandler", "inlineLinksHandler", "linksHandler", "linkText", "link", "linkTitle", "listsHandler", "markdownFileHandler", "mergedLeafNode", "Lorg/intellij/markdown/ast/LeafASTNode;", "nodes", "index", "", "startOffset", "sIndex", "parseStringToDocNode", "extractedString", "parseTagWithBody", "Lorg/jetbrains/dokka/model/doc/TagWrapper;", "tagName", "content", "preparse", "rawHtmlHandler", "referenceLinksHandler", "resolveDRI", "mdLink", "rowHandler", "strikeThroughHandler", "strongHandler", "tableHandler", "textHandler", "keepAllFormatting", "", "visitNode", "evaluateChildren", "evaluateChildrenWithDroppedEnclosingTokens", "count", "filterSpacesAndEOL", "filterTabSeparators", "isNotLeaf", "isRemoteLink", "mergeLeafASTNodes", "removeUselessTokens", "swapImagesThatShouldBeLinks", "transform", "trimSurroundingTokensIfText", "trimWhitespaceToken", "Companion", "analysis-markdown-jb"})
@InternalDokkaApi
@SourceDebugExtension(value={"SMAP\nMarkdownParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarkdownParser.kt\norg/jetbrains/dokka/analysis/markdown/jb/MarkdownParser\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,555:1\n1#2:556\n1360#3:557\n1446#3,5:558\n350#3,7:563\n378#3,7:570\n800#3,11:577\n800#3,11:588\n1360#3:599\n1446#3,5:600\n1360#3:605\n1446#3,2:606\n800#3,11:608\n1448#3,3:619\n766#3:622\n857#3,2:623\n1549#3:625\n1620#3,3:626\n800#3,11:629\n1360#3:640\n1446#3,5:641\n766#3:646\n857#3,2:647\n766#3:649\n857#3,2:650\n766#3:652\n857#3,2:653\n748#3,10:655\n731#3,9:665\n766#3:674\n857#3,2:675\n1549#3:677\n1620#3,3:678\n1360#3:681\n1446#3,5:682\n819#3:687\n847#3,2:688\n819#3:690\n847#3,2:691\n1360#3:693\n1446#3,5:694\n1360#3:699\n1446#3,5:700\n777#3:705\n788#3:706\n1864#3,2:707\n789#3,2:709\n1866#3:711\n791#3:712\n1559#3:713\n1590#3,4:714\n1747#3,3:718\n*E\n*S KotlinDebug\n*F\n+ 1 MarkdownParser.kt\norg/jetbrains/dokka/analysis/markdown/jb/MarkdownParser\n*L\n77#1:557\n77#1,5:558\n109#1,7:563\n113#1,7:570\n139#1,11:577\n145#1,11:588\n145#1:599\n145#1,5:600\n162#1:605\n162#1,2:606\n168#1,11:608\n162#1,3:619\n203#1:622\n203#1,2:623\n204#1:625\n204#1,3:626\n208#1,11:629\n208#1:640\n208#1,5:641\n296#1:646\n296#1,2:647\n303#1:649\n303#1,2:650\n310#1:652\n310#1,2:653\n367#1,10:655\n368#1,9:665\n369#1:674\n369#1,2:675\n370#1:677\n370#1,3:678\n384#1:681\n384#1,5:682\n442#1:687\n442#1,2:688\n445#1:690\n445#1,2:691\n448#1:693\n448#1,5:694\n454#1:699\n454#1,5:700\n467#1:705\n467#1:706\n467#1,2:707\n467#1,2:709\n467#1:711\n467#1:712\n474#1:713\n474#1,4:714\n522#1,3:718\n*E\n"})
public class MarkdownParser
extends Parser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function1<String, DRI> externalDri;
    @Nullable
    private final String kdocLocation;
    private Map<String, String> destinationLinksMap;
    private String text;
    @NotNull
    private final List<IElementType> notLeafNodes;

    public MarkdownParser(@NotNull Function1<? super String, DRI> externalDri, @Nullable String kdocLocation) {
        Intrinsics.checkNotNullParameter(externalDri, (String)"externalDri");
        this.externalDri = externalDri;
        this.kdocLocation = kdocLocation;
        Object[] objectArray = new IElementType[]{MarkdownTokenTypes.HORIZONTAL_RULE, MarkdownTokenTypes.HARD_LINE_BREAK, MarkdownTokenTypes.HTML_TAG, MarkdownTokenTypes.HTML_BLOCK_CONTENT};
        this.notLeafNodes = CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    @NotNull
    public DocTag parseStringToDocNode(@NotNull String extractedString) {
        Intrinsics.checkNotNullParameter((Object)extractedString, (String)"extractedString");
        GFMFlavourDescriptor gfmFlavourDescriptor = new GFMFlavourDescriptor(false, false, false, 7, null);
        ASTNode markdownAstRoot = new org.intellij.markdown.parser.MarkdownParser((MarkdownFlavourDescriptor)gfmFlavourDescriptor).buildMarkdownTreeFromString(extractedString);
        this.destinationLinksMap = MapsKt.toMap((Iterable)this.getAllDestinationLinks(extractedString, markdownAstRoot));
        this.text = extractedString;
        List parsed = MarkdownParser.visitNode$default(this, markdownAstRoot, false, 2, null);
        if (parsed.size() == 1) {
            return (DocTag)CollectionsKt.first((List)parsed);
        }
        return (DocTag)new CustomDocTag(parsed, MapsKt.emptyMap(), "");
    }

    @Override
    @NotNull
    protected String preparse(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return StringsKt.replace$default((String)StringsKt.replace$default((String)text, (String)"\r\n", (String)"\n", (boolean)false, (int)4, null), (String)"\r", (String)"\n", (boolean)false, (int)4, null);
    }

    @Override
    @NotNull
    protected TagWrapper parseTagWithBody(@NotNull String tagName, @NotNull String content) {
        TagWrapper tagWrapper;
        Intrinsics.checkNotNullParameter((Object)tagName, (String)"tagName");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        switch (tagName) {
            case "see": {
                String referencedName = StringsKt.substringBefore$default((String)content, (char)' ', null, (int)2, null);
                DRI dri = (DRI)this.externalDri.invoke((Object)referencedName);
                DocTag docTag = this.parseStringToDocNode(StringsKt.substringAfter$default((String)content, (char)' ', null, (int)2, null));
                Object object = dri;
                if (object == null || (object = Companion.fqDeclarationName((DRI)object)) == null) {
                    object = referencedName;
                }
                tagWrapper = (TagWrapper)new See(docTag, (String)object, dri);
                break;
            }
            case "exception": 
            case "throws": {
                DRI dri = (DRI)this.externalDri.invoke((Object)StringsKt.substringBefore$default((String)content, (char)' ', null, (int)2, null));
                DocTag docTag = this.parseStringToDocNode(StringsKt.substringAfter$default((String)content, (char)' ', null, (int)2, null));
                Object object = dri;
                if (object == null || (object = Companion.fqDeclarationName((DRI)object)) == null) {
                    object = StringsKt.substringBefore$default((String)content, (char)' ', null, (int)2, null);
                }
                tagWrapper = (TagWrapper)new Throws(docTag, (String)object, dri);
                break;
            }
            default: {
                tagWrapper = super.parseTagWithBody(tagName, content);
            }
        }
        return tagWrapper;
    }

    /*
     * WARNING - void declaration
     */
    private final List<DocTag> headersHandler(ASTNode node) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        Object v0;
        Iterable iterable;
        DocTagsFromIElementFactory docTagsFromIElementFactory;
        IElementType iElementType;
        Object object;
        block3: {
            Iterable iterable2 = node.getChildren();
            object = this;
            iElementType = node.getType();
            docTagsFromIElementFactory = DocTagsFromIElementFactory.INSTANCE;
            iterable = iterable2;
            for (Object t : iterable) {
                ASTNode it = (ASTNode)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.ATX_CONTENT)) continue;
                v0 = t;
                break block3;
            }
            v0 = null;
        }
        Object var14_14 = v0;
        ASTNode aSTNode = var14_14;
        if (aSTNode == null) {
            throw this.detailedException("Wrong AST Tree. Header does not contain expected content", node);
        }
        Iterable iterable3 = MarkdownParser.visitNode$default((MarkdownParser)object, aSTNode, false, 2, null);
        boolean $i$f$flatMap = false;
        iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            DocTag it = (DocTag)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getChildren();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        object = (List)destination$iv$iv;
        return DocTagsFromIElementFactory.getInstance$default(docTagsFromIElementFactory, iElementType, (List)object, null, null, null, false, 60, null);
    }

    private final List<DocTag> headerContentHandler(ASTNode node) {
        List<ASTNode> trimmedChildren = this.trimWhitespaceToken(node.getChildren());
        List children = MarkdownParser.evaluateChildren$default(this, trimmedChildren, false, 1, null);
        return DocTagsFromIElementFactory.getInstance$default(DocTagsFromIElementFactory.INSTANCE, MarkdownElementTypes.PARAGRAPH, children, null, null, null, false, 60, null);
    }

    private final List<ASTNode> trimWhitespaceToken(List<? extends ASTNode> $this$trimWhitespaceToken) {
        int n;
        int firstNonWhitespaceIndex;
        block5: {
            block4: {
                int n2;
                List<ASTNode> $this$indexOfFirst$iv = $this$trimWhitespaceToken;
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                Iterator<? extends ASTNode> iterator = $this$indexOfFirst$iv.iterator();
                while (iterator.hasNext()) {
                    ASTNode item$iv;
                    ASTNode it = item$iv = iterator.next();
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.WHITE_SPACE)) {
                        n2 = index$iv;
                        break block4;
                    }
                    ++index$iv;
                }
                n2 = firstNonWhitespaceIndex = -1;
            }
            if (firstNonWhitespaceIndex == -1) {
                return $this$trimWhitespaceToken;
            }
            List<ASTNode> $this$indexOfLast$iv = $this$trimWhitespaceToken;
            boolean $i$f$indexOfLast = false;
            ListIterator<ASTNode> iterator$iv = $this$indexOfLast$iv.listIterator($this$indexOfLast$iv.size());
            while (iterator$iv.hasPrevious()) {
                ASTNode it = iterator$iv.previous();
                boolean bl = false;
                if (!(!Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.WHITE_SPACE))) continue;
                n = iterator$iv.nextIndex();
                break block5;
            }
            n = -1;
        }
        int lastNonWhitespaceIndex = n;
        return $this$trimWhitespaceToken.subList(firstNonWhitespaceIndex, lastNonWhitespaceIndex + 1);
    }

    private final List<DocTag> horizontalRulesHandler() {
        return DocTagsFromIElementFactory.getInstance$default(DocTagsFromIElementFactory.INSTANCE, MarkdownTokenTypes.HORIZONTAL_RULE, null, null, null, null, false, 62, null);
    }

    private final List<DocTag> emphasisHandler(ASTNode node) {
        return DocTagsFromIElementFactory.getInstance$default(DocTagsFromIElementFactory.INSTANCE, node.getType(), this.evaluateChildrenWithDroppedEnclosingTokens(node.getChildren(), 1), null, null, null, false, 60, null);
    }

    private final List<DocTag> strongHandler(ASTNode node) {
        return DocTagsFromIElementFactory.getInstance$default(DocTagsFromIElementFactory.INSTANCE, node.getType(), this.evaluateChildrenWithDroppedEnclosingTokens(node.getChildren(), 2), null, null, null, false, 60, null);
    }

    private final List<DocTag> evaluateChildrenWithDroppedEnclosingTokens(List<? extends ASTNode> $this$evaluateChildrenWithDroppedEnclosingTokens, int count) {
        return MarkdownParser.evaluateChildren$default(this, CollectionsKt.dropLast((List)CollectionsKt.drop((Iterable)$this$evaluateChildrenWithDroppedEnclosingTokens, (int)count), (int)count), false, 1, null);
    }

    /*
     * WARNING - void declaration
     */
    private final List<DocTag> blockquotesHandler(ASTNode node) {
        void $this$filterIsInstanceTo$iv$iv;
        void $this$filterIsInstance$iv;
        Iterable iterable = node.getChildren();
        MarkdownParser markdownParser = this;
        IElementType iElementType = node.getType();
        DocTagsFromIElementFactory docTagsFromIElementFactory = DocTagsFromIElementFactory.INSTANCE;
        boolean $i$f$filterIsInstance = false;
        void var4_7 = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof CompositeASTNode)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list = (List)destination$iv$iv;
        return DocTagsFromIElementFactory.getInstance$default(docTagsFromIElementFactory, iElementType, MarkdownParser.evaluateChildren$default(markdownParser, list, false, 1, null), null, null, null, false, 60, null);
    }

    /*
     * WARNING - void declaration
     */
    private final List<DocTag> listsHandler(ASTNode node) {
        Map map;
        Iterable list$iv$iv;
        Object[] objectArray;
        Object nestedList;
        ListItemCompositeNode it;
        Iterable $this$flatMapTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv = node.getChildren();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof ListItemCompositeNode)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$filterIsInstanceTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List list;
            it = (ListItemCompositeNode)element$iv$iv;
            boolean bl = false;
            Object[] objectArray2 = new IElementType[]{MarkdownElementTypes.ORDERED_LIST, MarkdownElementTypes.UNORDERED_LIST};
            if (CollectionsKt.listOf((Object[])objectArray2).contains(((ASTNode)CollectionsKt.last((List)it.getChildren())).getType())) {
                nestedList = (ASTNode)CollectionsKt.last((List)it.getChildren());
                List list2 = it.getChildren();
                Intrinsics.checkNotNull((Object)list2, (String)"null cannot be cast to non-null type kotlin.collections.MutableList<org.intellij.markdown.ast.ASTNode>");
                TypeIntrinsics.asMutableList((Object)list2).remove(CollectionsKt.getLastIndex((List)it.getChildren()));
                objectArray = new ASTNode[]{it, nestedList};
                list = CollectionsKt.listOf((Object[])objectArray);
            } else {
                list = CollectionsKt.listOf((Object)it);
            }
            list$iv$iv = list;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List children = (List)destination$iv$iv;
        $this$flatMap$iv = children;
        IElementType iElementType = node.getType();
        DocTagsFromIElementFactory docTagsFromIElementFactory = DocTagsFromIElementFactory.INSTANCE;
        $i$f$flatMap = false;
        $this$flatMapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List list;
            it = (ASTNode)element$iv$iv;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownElementTypes.LIST_ITEM)) {
                void $this$filterIsInstanceTo$iv$iv2;
                void $this$filterIsInstance$iv2;
                nestedList = it.getChildren();
                objectArray = this;
                IElementType iElementType2 = it.getType();
                DocTagsFromIElementFactory docTagsFromIElementFactory2 = DocTagsFromIElementFactory.INSTANCE;
                boolean $i$f$filterIsInstance2 = false;
                void var17_22 = $this$filterIsInstance$iv2;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterIsInstanceTo2 = false;
                for (Object element$iv$iv2 : $this$filterIsInstanceTo$iv$iv2) {
                    if (!(element$iv$iv2 instanceof CompositeASTNode)) continue;
                    destination$iv$iv2.add(element$iv$iv2);
                }
                List list3 = (List)destination$iv$iv2;
                list = DocTagsFromIElementFactory.getInstance$default(docTagsFromIElementFactory2, iElementType2, MarkdownParser.evaluateChildren$default((MarkdownParser)objectArray, list3, false, 1, null), null, null, null, false, 60, null);
            } else {
                list = MarkdownParser.visitNode$default(this, (ASTNode)it, false, 2, null);
            }
            list$iv$iv = list;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List list = (List)destination$iv$iv;
        if (Intrinsics.areEqual((Object)node.getType(), (Object)MarkdownElementTypes.ORDERED_LIST)) {
            ASTNode listNumberNode = (ASTNode)CollectionsKt.first((List)((ASTNode)CollectionsKt.first((List)node.getChildren())).getChildren());
            String string = this.text;
            if (string == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"text");
                string = null;
            }
            String string2 = string;
            int n = listNumberNode.getStartOffset();
            int n2 = listNumberNode.getEndOffset();
            String string3 = string2.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            map = MapsKt.mapOf((Pair)TuplesKt.to((Object)"start", (Object)StringsKt.dropLast((String)((Object)StringsKt.trim((CharSequence)string3)).toString(), (int)1)));
        } else {
            map = MapsKt.emptyMap();
        }
        return DocTagsFromIElementFactory.getInstance$default(docTagsFromIElementFactory, iElementType, list, map, null, null, false, 56, null);
    }

    private final DRI resolveDRI(String mdLink) {
        DRI dRI;
        String link = StringsKt.removeSuffix((String)StringsKt.removePrefix((String)mdLink, (CharSequence)"["), (CharSequence)"]");
        boolean bl = false;
        try {
            new URL(link);
            dRI = null;
        }
        catch (MalformedURLException e) {
            dRI = (DRI)this.externalDri.invoke((Object)link);
        }
        return dRI;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Pair<String, String>> getAllDestinationLinks(String text, ASTNode node) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv;
        Collection collection;
        void $this$mapTo$iv$iv;
        ASTNode it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = node.getChildren();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (ASTNode)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownElementTypes.LINK_DEFINITION)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (ASTNode)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String string = text.substring(((ASTNode)it.getChildren().get(0)).getStartOffset(), ((ASTNode)it.getChildren().get(0)).getEndOffset());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String string2 = string.toLowerCase();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            String string3 = text.substring(((ASTNode)it.getChildren().get(2)).getStartOffset(), ((ASTNode)it.getChildren().get(2)).getEndOffset());
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            collection.add(TuplesKt.to((Object)string2, (Object)string3));
        }
        $this$map$iv = node.getChildren();
        collection = (List)destination$iv$iv;
        boolean $i$f$filterIsInstance = false;
        $this$mapTo$iv$iv = $this$filterIsInstance$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof CompositeASTNode)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$filterIsInstanceTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (CompositeASTNode)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = this.getAllDestinationLinks(text, it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv));
    }

    private final List<DocTag> referenceLinksHandler(ASTNode node) {
        String string;
        ASTNode linkText;
        ASTNode aSTNode;
        Object v2;
        ASTNode linkLabel;
        Object object;
        block8: {
            Object v0;
            Object object2;
            Object object3;
            block7: {
                object = node.getChildren();
                object3 = object.iterator();
                while (object3.hasNext()) {
                    object2 = object3.next();
                    ASTNode it = (ASTNode)object2;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownElementTypes.LINK_LABEL)) continue;
                    v0 = object2;
                    break block7;
                }
                v0 = null;
            }
            ASTNode aSTNode2 = v0;
            if (aSTNode2 == null) {
                throw this.detailedException("Wrong AST Tree. Reference link does not contain link label", node);
            }
            linkLabel = aSTNode2;
            object3 = node.getChildren();
            object2 = object3.listIterator(object3.size());
            while (object2.hasPrevious()) {
                Object e = object2.previous();
                ASTNode it = (ASTNode)e;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownElementTypes.LINK_TEXT)) continue;
                v2 = e;
                break block8;
            }
            v2 = null;
        }
        if ((aSTNode = (ASTNode)v2) == null) {
            aSTNode = linkText = linkLabel;
        }
        if ((string = this.text) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"text");
            string = null;
        }
        object = string;
        int n = linkLabel.getStartOffset();
        int n2 = linkLabel.getEndOffset();
        String string2 = ((String)object).substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        String linkKey = string2;
        Map<String, String> map = this.destinationLinksMap;
        if (map == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"destinationLinksMap");
            map = null;
        }
        String string3 = linkKey.toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        String string4 = map.get(string3);
        if (string4 == null) {
            string4 = linkKey;
        }
        String link = string4;
        return MarkdownParser.linksHandler$default(this, linkText, link, null, 4, null);
    }

    private final List<DocTag> inlineLinksHandler(ASTNode node) {
        String string;
        Object object;
        ASTNode linkDestination;
        ASTNode linkText;
        block9: {
            Object object2;
            Object it;
            Object object32;
            block8: {
                Object v0;
                Iterable iterable;
                block7: {
                    iterable = node.getChildren();
                    for (Object object32 : iterable) {
                        it = (ASTNode)object32;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownElementTypes.LINK_TEXT)) continue;
                        v0 = object32;
                        break block7;
                    }
                    v0 = null;
                }
                ASTNode aSTNode = v0;
                if (aSTNode == null) {
                    throw this.detailedException("Wrong AST Tree. Inline link does not contain link text", node);
                }
                linkText = aSTNode;
                iterable = node.getChildren();
                for (Object object32 : iterable) {
                    it = (ASTNode)object32;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownElementTypes.LINK_DESTINATION)) continue;
                    object2 = object32;
                    break block8;
                }
                object2 = null;
            }
            linkDestination = (ASTNode)object2;
            Iterable iterable = node.getChildren();
            object32 = iterable.iterator();
            while (object32.hasNext()) {
                Object it2 = it = object32.next();
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it2.getType(), (Object)MarkdownElementTypes.LINK_TITLE)) continue;
                object = it;
                break block9;
            }
            object = null;
        }
        ASTNode linkTitle = object;
        ASTNode aSTNode = linkDestination;
        if (aSTNode != null) {
            ASTNode it = aSTNode;
            boolean bl = false;
            String string2 = this.text;
            if (string2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"text");
                string2 = null;
            }
            String string3 = string2;
            int n = it.getStartOffset();
            int n2 = it.getEndOffset();
            String string4 = string3.substring(n, n2);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
        } else {
            string = null;
        }
        String link = string;
        return this.linksHandler(linkText, link, linkTitle);
    }

    private final List<DocTag> markdownFileHandler(ASTNode node) {
        return DocTagsFromIElementFactory.getInstance$default(DocTagsFromIElementFactory.INSTANCE, node.getType(), MarkdownParser.evaluateChildren$default(this, this.filterSpacesAndEOL(node.getChildren()), false, 1, null), null, null, null, false, 60, null);
    }

    private final List<DocTag> autoLinksHandler(ASTNode node) {
        String string = this.text;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"text");
            string = null;
        }
        String string2 = string;
        int n = node.getStartOffset() + 1;
        int n2 = node.getEndOffset() - 1;
        String string3 = string2.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        String link = string3;
        return MarkdownParser.linksHandler$default(this, node, link, null, 4, null);
    }

    private final List<DocTag> linksHandler(ASTNode linkText, String link, ASTNode linkTitle) {
        List list;
        Map params;
        Map map;
        String string;
        String linkOrEmpty;
        String string2;
        DRI dri;
        DRI dRI;
        String string3 = link;
        if (string3 != null) {
            String it = string3;
            boolean bl = false;
            dRI = this.resolveDRI(it);
        } else {
            dRI = dri = null;
        }
        if ((string2 = link) == null) {
            string2 = linkOrEmpty = "";
        }
        if (linkTitle == null) {
            string = linkOrEmpty;
        } else {
            String string4 = this.text;
            if (string4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"text");
                string4 = null;
            }
            String bl = string4;
            int n = linkTitle.getStartOffset() + 1;
            int n2 = linkTitle.getEndOffset() - 1;
            String string5 = bl.substring(n, n2);
            string = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
        }
        String linkTextString = string;
        if (linkTitle == null) {
            map = MapsKt.mapOf((Pair)TuplesKt.to((Object)"href", (Object)linkOrEmpty));
        } else {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"href", (Object)linkOrEmpty), TuplesKt.to((Object)"title", (Object)linkTextString)};
            map = params = MapsKt.mapOf((Pair[])pairArray);
        }
        if (link != null && dri == null && !this.isRemoteLink(linkOrEmpty)) {
            DocTagsFromIElementFactory docTagsFromIElementFactory = DocTagsFromIElementFactory.INSTANCE;
            IElementType iElementType = MarkdownTokenTypes.TEXT;
            List list2 = MarkdownParser.evaluateChildren$default(this, CollectionsKt.dropLast((List)CollectionsKt.drop((Iterable)linkText.getChildren(), (int)1), (int)1), false, 1, null);
            String string6 = StringsKt.removeSurrounding((String)linkTextString, (CharSequence)"[", (CharSequence)"]");
            list = DocTagsFromIElementFactory.getInstance$default(docTagsFromIElementFactory, iElementType, list2, params, string6, null, false, 48, null);
        } else {
            DocTagsFromIElementFactory docTagsFromIElementFactory = DocTagsFromIElementFactory.INSTANCE;
            IElementType iElementType = MarkdownElementTypes.INLINE_LINK;
            List list3 = MarkdownParser.evaluateChildren$default(this, CollectionsKt.dropLast((List)CollectionsKt.drop((Iterable)linkText.getChildren(), (int)1), (int)1), false, 1, null);
            list = DocTagsFromIElementFactory.getInstance$default(docTagsFromIElementFactory, iElementType, list3, params, null, dri, false, 40, null);
        }
        return list;
    }

    static /* synthetic */ List linksHandler$default(MarkdownParser markdownParser, ASTNode aSTNode, String string, ASTNode aSTNode2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: linksHandler");
        }
        if ((n & 4) != 0) {
            aSTNode2 = null;
        }
        return markdownParser.linksHandler(aSTNode, string, aSTNode2);
    }

    private final List<DocTag> codeLineHandler(ASTNode node) {
        String string = this.text;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"text");
            string = null;
        }
        String string2 = string;
        int n = node.getStartOffset();
        int n2 = node.getEndOffset();
        String string3 = string2.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        return DocTagsFromIElementFactory.getInstance$default(DocTagsFromIElementFactory.INSTANCE, MarkdownElementTypes.CODE_BLOCK, null, null, string3, null, false, 54, null);
    }

    private final List<DocTag> textHandler(ASTNode node, boolean keepAllFormatting) {
        String string = this.text;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"text");
            string = null;
        }
        String string2 = string;
        int n = node.getStartOffset();
        int n2 = node.getEndOffset();
        String string3 = string2.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        return DocTagsFromIElementFactory.getInstance$default(DocTagsFromIElementFactory.INSTANCE, MarkdownTokenTypes.TEXT, null, null, this.transform(string3), null, keepAllFormatting, 22, null);
    }

    private final List<DocTag> strikeThroughHandler(ASTNode node) {
        return DocTagsFromIElementFactory.getInstance$default(DocTagsFromIElementFactory.INSTANCE, node.getType(), this.evaluateChildrenWithDroppedEnclosingTokens(node.getChildren(), 2), null, null, null, false, 60, null);
    }

    /*
     * WARNING - void declaration
     */
    private final List<DocTag> tableHandler(ASTNode node) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Iterable iterable = node.getChildren();
        MarkdownParser markdownParser = this;
        IElementType iElementType = GFMElementTypes.TABLE;
        DocTagsFromIElementFactory docTagsFromIElementFactory = DocTagsFromIElementFactory.INSTANCE;
        boolean $i$f$filter = false;
        void var4_7 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ASTNode it = (ASTNode)element$iv$iv;
            boolean bl = false;
            if (!(Intrinsics.areEqual((Object)it.getType(), (Object)GFMElementTypes.ROW) || Intrinsics.areEqual((Object)it.getType(), (Object)GFMElementTypes.HEADER))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list = (List)destination$iv$iv;
        return DocTagsFromIElementFactory.getInstance$default(docTagsFromIElementFactory, iElementType, MarkdownParser.evaluateChildren$default(markdownParser, list, false, 1, null), null, null, null, false, 60, null);
    }

    /*
     * WARNING - void declaration
     */
    private final List<DocTag> headerHandler(ASTNode node) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Iterable iterable = node.getChildren();
        MarkdownParser markdownParser = this;
        IElementType iElementType = GFMElementTypes.HEADER;
        DocTagsFromIElementFactory docTagsFromIElementFactory = DocTagsFromIElementFactory.INSTANCE;
        boolean $i$f$filter = false;
        void var4_7 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ASTNode it = (ASTNode)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getType(), (Object)GFMTokenTypes.CELL)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list = (List)destination$iv$iv;
        return DocTagsFromIElementFactory.getInstance$default(docTagsFromIElementFactory, iElementType, MarkdownParser.evaluateChildren$default(markdownParser, list, false, 1, null), null, null, null, false, 60, null);
    }

    /*
     * WARNING - void declaration
     */
    private final List<DocTag> rowHandler(ASTNode node) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Iterable iterable = node.getChildren();
        MarkdownParser markdownParser = this;
        IElementType iElementType = GFMElementTypes.ROW;
        DocTagsFromIElementFactory docTagsFromIElementFactory = DocTagsFromIElementFactory.INSTANCE;
        boolean $i$f$filter = false;
        void var4_7 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ASTNode it = (ASTNode)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getType(), (Object)GFMTokenTypes.CELL)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list = (List)destination$iv$iv;
        return DocTagsFromIElementFactory.getInstance$default(docTagsFromIElementFactory, iElementType, MarkdownParser.evaluateChildren$default(markdownParser, list, false, 1, null), null, null, null, false, 60, null);
    }

    private final List<DocTag> cellHandler(ASTNode node) {
        return DocTagsFromIElementFactory.getInstance$default(DocTagsFromIElementFactory.INSTANCE, GFMTokenTypes.CELL, this.trimSurroundingTokensIfText(MarkdownParser.evaluateChildren$default(this, this.filterTabSeparators(node.getChildren()), false, 1, null)), null, null, null, false, 60, null);
    }

    private final boolean isRemoteLink(String $this$isRemoteLink) {
        boolean bl;
        try {
            new URL($this$isRemoteLink);
            bl = true;
        }
        catch (MalformedURLException e) {
            bl = false;
        }
        return bl;
    }

    private final List<DocTag> imagesHandler(ASTNode node) {
        Object object;
        Object src;
        block15: {
            block14: {
                int n;
                ASTNode description;
                block13: {
                    Object object2;
                    block12: {
                        Object object3;
                        ASTNode destination;
                        Object it;
                        block11: {
                            Object object4;
                            Object object52;
                            List $this$imagesHandler_u24lambda_u2424;
                            block10: {
                                $this$imagesHandler_u24lambda_u2424 = ((ASTNode)CollectionsKt.last((List)node.getChildren())).getChildren();
                                boolean bl = false;
                                Iterable iterable = $this$imagesHandler_u24lambda_u2424;
                                for (Object object52 : iterable) {
                                    it = (ASTNode)object52;
                                    boolean bl2 = false;
                                    if (!Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownElementTypes.LINK_DESTINATION)) continue;
                                    object4 = object52;
                                    break block10;
                                }
                                object4 = null;
                            }
                            destination = (ASTNode)object4;
                            Iterable iterable = $this$imagesHandler_u24lambda_u2424;
                            object52 = iterable.iterator();
                            while (object52.hasNext()) {
                                Object it2 = it = object52.next();
                                boolean bl3 = false;
                                if (!Intrinsics.areEqual((Object)it2.getType(), (Object)MarkdownElementTypes.LINK_TEXT)) continue;
                                object3 = it;
                                break block11;
                            }
                            object3 = null;
                        }
                        description = object3;
                        object2 = destination;
                        if (object2 == null) break block12;
                        it = object2;
                        boolean bl = false;
                        String string = this.text;
                        if (string == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"text");
                            string = null;
                        }
                        String bl3 = string;
                        int n2 = it.getStartOffset();
                        n = it.getEndOffset();
                        String string2 = bl3.substring(n2, n);
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                        Map map = MapsKt.mapOf((Pair)TuplesKt.to((Object)"href", (Object)string2));
                        object2 = map;
                        if (map != null) break block13;
                    }
                    object2 = src = MapsKt.emptyMap();
                }
                if ((object = description) == null) break block14;
                ASTNode it = object;
                boolean bl = false;
                String string = this.text;
                if (string == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"text");
                    string = null;
                }
                String string3 = string;
                n = it.getStartOffset() + 1;
                int n3 = it.getEndOffset() - 1;
                String string4 = string3.substring(n, n3);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                Map map = MapsKt.mapOf((Pair)TuplesKt.to((Object)"alt", (Object)string4));
                object = map;
                if (map != null) break block15;
            }
            object = MapsKt.emptyMap();
        }
        Object alt = object;
        return DocTagsFromIElementFactory.getInstance$default(DocTagsFromIElementFactory.INSTANCE, node.getType(), null, MapsKt.plus((Map)src, (Map)alt), null, null, false, 58, null);
    }

    private final List<DocTag> rawHtmlHandler(ASTNode node) {
        IElementType iElementType = node.getType();
        String string = this.text;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"text");
            string = null;
        }
        String string2 = string;
        int n = node.getStartOffset();
        int n2 = node.getEndOffset();
        String string3 = string2.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        return DocTagsFromIElementFactory.getInstance$default(DocTagsFromIElementFactory.INSTANCE, iElementType, null, null, string3, null, false, 54, null);
    }

    private final List<DocTag> codeSpansHandler(ASTNode node) {
        IElementType iElementType = node.getType();
        String string = this.text;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"text");
            string = null;
        }
        String string2 = string;
        int n = node.getStartOffset() + 1;
        int n2 = node.getEndOffset() - 1;
        String string3 = string2.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        return DocTagsFromIElementFactory.getInstance$default(DocTagsFromIElementFactory.INSTANCE, iElementType, DocTagsFromIElementFactory.getInstance$default(DocTagsFromIElementFactory.INSTANCE, MarkdownTokenTypes.TEXT, null, null, StringsKt.trimIndent((String)StringsKt.replace$default((String)string3, (char)'\n', (char)' ', (boolean)false, (int)4, null)), null, true, 22, null), null, null, null, false, 60, null);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private final List<DocTag> codeFencesHandler(ASTNode node) {
        Object object;
        Object v1;
        Object object2;
        Object destination$iv$iv;
        ASTNode it;
        Object object3;
        DocTagsFromIElementFactory docTagsFromIElementFactory;
        IElementType iElementType;
        Object object4;
        Iterable iterable;
        block11: {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            List list;
            Iterable $this$dropLastWhile$iv;
            List $this$dropWhile$iv;
            iterable = node.getChildren();
            object4 = this;
            iElementType = node.getType();
            docTagsFromIElementFactory = DocTagsFromIElementFactory.INSTANCE;
            boolean $i$f$dropWhile = false;
            boolean yielding$iv = false;
            ArrayList list$iv = new ArrayList();
            for (Object item$iv : $this$dropWhile$iv) {
                if (yielding$iv) {
                    list$iv.add(item$iv);
                    continue;
                }
                ASTNode it2 = (ASTNode)item$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it2.getType(), (Object)MarkdownTokenTypes.CODE_FENCE_CONTENT)) continue;
                list$iv.add(item$iv);
                yielding$iv = true;
            }
            object3 = list$iv;
            $this$dropWhile$iv = object3;
            boolean $i$f$dropLastWhile = false;
            if (!$this$dropLastWhile$iv.isEmpty()) {
                ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                while (iterator$iv.hasPrevious()) {
                    it = (ASTNode)iterator$iv.previous();
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.CODE_FENCE_CONTENT)) continue;
                    list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                    break;
                }
            } else {
                list = CollectionsKt.emptyList();
            }
            object3 = list;
            $this$dropLastWhile$iv = (Iterable)object3;
            boolean $i$f$filter = false;
            void iterator$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                ASTNode it3 = (ASTNode)element$iv$iv;
                boolean bl = false;
                if (!(!Intrinsics.areEqual((Object)it3.getType(), (Object)MarkdownTokenTypes.WHITE_SPACE))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            object3 = (List)destination$iv$iv;
            $this$filter$iv = (Iterable)object3;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                ASTNode it3 = (ASTNode)item$iv$iv;
                object3 = destination$iv$iv;
                boolean bl = false;
                object3.add(Intrinsics.areEqual((Object)it3.getType(), (Object)MarkdownTokenTypes.EOL) ? (ASTNode)new LeafASTNode(MarkdownTokenTypes.HARD_LINE_BREAK, 0, 0) : it3);
            }
            object3 = (List)destination$iv$iv;
            object2 = node.getChildren();
            object4 = ((MarkdownParser)object4).evaluateChildren((List<? extends ASTNode>)object3, true);
            Iterable iterable2 = object2;
            for (Object $i$f$mapTo2 : iterable2) {
                ASTNode it4 = (ASTNode)$i$f$mapTo2;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it4.getType(), (Object)MarkdownTokenTypes.FENCE_LANG)) continue;
                v1 = $i$f$mapTo2;
                break block11;
            }
            v1 = null;
        }
        object3 = v1;
        DocTagsFromIElementFactory docTagsFromIElementFactory2 = docTagsFromIElementFactory;
        IElementType iElementType2 = iElementType;
        Object object5 = object4;
        iterable = (ASTNode)object3;
        if (iterable != null) {
            destination$iv$iv = iterable;
            object4 = object5;
            iElementType = iElementType2;
            docTagsFromIElementFactory = docTagsFromIElementFactory2;
            boolean bl = false;
            String string = this.text;
            if (string == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"text");
                string = null;
            }
            String string2 = string;
            int n = it.getStartOffset();
            int n2 = it.getEndOffset();
            String string3 = string2.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            object3 = MapsKt.mapOf((Pair)TuplesKt.to((Object)"lang", (Object)string3));
            docTagsFromIElementFactory2 = docTagsFromIElementFactory;
            iElementType2 = iElementType;
            object5 = object4;
            object2 = object3;
            if (object2 != null) {
                object = object2;
                return DocTagsFromIElementFactory.getInstance$default(docTagsFromIElementFactory2, iElementType2, (List)object5, (Map)object, null, null, false, 56, null);
            }
        }
        object = MapsKt.emptyMap();
        return DocTagsFromIElementFactory.getInstance$default(docTagsFromIElementFactory2, iElementType2, (List)object5, (Map)object, null, null, false, 56, null);
    }

    /*
     * WARNING - void declaration
     */
    private final List<DocTag> codeBlocksHandler(ASTNode node) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        Iterable iterable = this.mergeLeafASTNodes(node.getChildren());
        IElementType iElementType = node.getType();
        DocTagsFromIElementFactory docTagsFromIElementFactory = DocTagsFromIElementFactory.INSTANCE;
        boolean $i$f$flatMap = false;
        void var4_6 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            ASTNode it = (ASTNode)element$iv$iv;
            boolean bl = false;
            String string = this.text;
            if (string == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"text");
                string = null;
            }
            String string2 = string;
            int n = it.getStartOffset();
            int n2 = it.getEndOffset();
            String string3 = string2.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            Iterable list$iv$iv = DocTagsFromIElementFactory.getInstance$default(DocTagsFromIElementFactory.INSTANCE, MarkdownTokenTypes.TEXT, null, null, ((Object)HtmlGenerator.Companion.trimIndents((CharSequence)string3, 4)).toString(), null, false, 54, null);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List list = (List)destination$iv$iv;
        return DocTagsFromIElementFactory.getInstance$default(docTagsFromIElementFactory, iElementType, list, null, null, null, false, 60, null);
    }

    private final List<DocTag> defaultHandler(ASTNode node) {
        return DocTagsFromIElementFactory.getInstance$default(DocTagsFromIElementFactory.INSTANCE, MarkdownElementTypes.PARAGRAPH, MarkdownParser.evaluateChildren$default(this, node.getChildren(), false, 1, null), null, null, null, false, 60, null);
    }

    private final List<DocTag> visitNode(ASTNode node, boolean keepAllFormatting) {
        IElementType iElementType = node.getType();
        return (((((Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.ATX_1) ? true : Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.ATX_2)) ? true : Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.ATX_3)) ? true : Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.ATX_4)) ? true : Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.ATX_5)) ? true : Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.ATX_6)) ? this.headersHandler(node) : (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.ATX_CONTENT) ? this.headerContentHandler(node) : (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.HORIZONTAL_RULE) ? this.horizontalRulesHandler() : (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.STRONG) ? this.strongHandler(node) : (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.EMPH) ? this.emphasisHandler(node) : ((Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.FULL_REFERENCE_LINK) ? true : Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.SHORT_REFERENCE_LINK)) ? this.referenceLinksHandler(node) : (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.INLINE_LINK) ? this.inlineLinksHandler(node) : (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.AUTOLINK) ? this.autoLinksHandler(node) : (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.BLOCK_QUOTE) ? this.blockquotesHandler(node) : ((Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.UNORDERED_LIST) ? true : Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.ORDERED_LIST)) ? this.listsHandler(node) : (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.CODE_BLOCK) ? this.codeBlocksHandler(node) : (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.CODE_FENCE) ? this.codeFencesHandler(node) : (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.CODE_SPAN) ? this.codeSpansHandler(node) : (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.IMAGE) ? this.imagesHandler(node) : (((Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.HTML_BLOCK) ? true : Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.HTML_TAG)) ? true : Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.HTML_BLOCK_CONTENT)) ? this.rawHtmlHandler(node) : (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.HARD_LINE_BREAK) ? DocTagsFromIElementFactory.getInstance$default(DocTagsFromIElementFactory.INSTANCE, node.getType(), null, null, null, null, false, 62, null) : ((Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.CODE_FENCE_CONTENT) ? true : Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.CODE_LINE)) ? this.codeLineHandler(node) : (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.TEXT) ? this.textHandler(node, keepAllFormatting) : (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.MARKDOWN_FILE) ? this.markdownFileHandler(node) : (Intrinsics.areEqual((Object)iElementType, (Object)GFMElementTypes.STRIKETHROUGH) ? this.strikeThroughHandler(node) : (Intrinsics.areEqual((Object)iElementType, (Object)GFMElementTypes.TABLE) ? this.tableHandler(node) : (Intrinsics.areEqual((Object)iElementType, (Object)GFMElementTypes.HEADER) ? this.headerHandler(node) : (Intrinsics.areEqual((Object)iElementType, (Object)GFMElementTypes.ROW) ? this.rowHandler(node) : (Intrinsics.areEqual((Object)iElementType, (Object)GFMTokenTypes.CELL) ? this.cellHandler(node) : this.defaultHandler(node))))))))))))))))))))))));
    }

    static /* synthetic */ List visitNode$default(MarkdownParser markdownParser, ASTNode aSTNode, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: visitNode");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        return markdownParser.visitNode(aSTNode, bl);
    }

    /*
     * WARNING - void declaration
     */
    private final List<ASTNode> filterTabSeparators(List<? extends ASTNode> $this$filterTabSeparators) {
        void $this$filterNotTo$iv$iv;
        Iterable $this$filterNot$iv = $this$filterTabSeparators;
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            ASTNode it = (ASTNode)element$iv$iv;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)it.getType(), (Object)GFMTokenTypes.TABLE_SEPARATOR)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<ASTNode> filterSpacesAndEOL(List<? extends ASTNode> $this$filterSpacesAndEOL) {
        void $this$filterNotTo$iv$iv;
        Iterable $this$filterNot$iv = $this$filterSpacesAndEOL;
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            ASTNode it = (ASTNode)element$iv$iv;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.WHITE_SPACE) || Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.EOL)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<DocTag> evaluateChildren(List<? extends ASTNode> $this$evaluateChildren, boolean keepAllFormatting) {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = this.mergeLeafASTNodes(this.swapImagesThatShouldBeLinks(this.removeUselessTokens($this$evaluateChildren), keepAllFormatting));
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            ASTNode it = (ASTNode)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = this.visitNode(it, keepAllFormatting);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    static /* synthetic */ List evaluateChildren$default(MarkdownParser markdownParser, List list, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: evaluateChildren");
        }
        if ((n & 1) != 0) {
            bl = false;
        }
        return markdownParser.evaluateChildren(list, bl);
    }

    /*
     * Unable to fully structure code
     */
    private final List<ASTNode> swapImagesThatShouldBeLinks(List<? extends ASTNode> $this$swapImagesThatShouldBeLinks, boolean keepAllFormatting) {
        block6: {
            block5: {
                if (!keepAllFormatting) break block5;
                v0 = $this$swapImagesThatShouldBeLinks;
                break block6;
            }
            $this$flatMap$iv = $this$swapImagesThatShouldBeLinks;
            $i$f$flatMap = false;
            var5_5 = $this$flatMap$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$flatMapTo = false;
            for (T element$iv$iv : $this$flatMapTo$iv$iv) {
                node = (ASTNode)element$iv$iv;
                $i$a$-flatMap-MarkdownParser$swapImagesThatShouldBeLinks$1 = false;
                if (!Intrinsics.areEqual((Object)node.getType(), (Object)MarkdownElementTypes.IMAGE)) ** GOTO lbl-1000
                if ((ASTNode)CollectionsKt.firstOrNull((List)node.getChildren()) != null) {
                    $i$a$-let-MarkdownParser$swapImagesThatShouldBeLinks$1$1 = false;
                    v1 = it instanceof LeafASTNode && Intrinsics.areEqual((Object)it.getType().getName(), (Object)"!");
                } else {
                    v1 = false;
                }
                if (!v1) ** GOTO lbl-1000
                v2 = (ASTNode)CollectionsKt.lastOrNull((List)node.getChildren());
                if (Intrinsics.areEqual((Object)(v2 != null ? v2.getType() : null), (Object)MarkdownElementTypes.SHORT_REFERENCE_LINK)) {
                    v3 = node.getChildren();
                } else lbl-1000:
                // 3 sources

                {
                    v3 = CollectionsKt.listOf((Object)node);
                }
                list$iv$iv = v3;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            v0 = (List)destination$iv$iv;
        }
        return v0;
    }

    /*
     * Unable to fully structure code
     */
    private final List<ASTNode> removeUselessTokens(List<? extends ASTNode> $this$removeUselessTokens) {
        $this$filterIndexed$iv = $this$removeUselessTokens;
        $i$f$filterIndexed = false;
        var4_4 = $this$filterIndexed$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterIndexedTo = false;
        $this$forEachIndexed$iv$iv$iv = $this$filterIndexedTo$iv$iv;
        $i$f$forEachIndexed = false;
        index$iv$iv$iv = 0;
        for (T item$iv$iv$iv : $this$forEachIndexed$iv$iv$iv) {
            if ((var12_12 = index$iv$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            var13_13 = item$iv$iv$iv;
            index$iv$iv = var12_12;
            $i$a$-forEachIndexed-CollectionsKt___CollectionsKt$filterIndexedTo$1$iv$iv = false;
            var16_16 = (ASTNode)element$iv$iv;
            index = index$iv$iv;
            $i$a$-filterIndexed-MarkdownParser$removeUselessTokens$1 = false;
            if (Intrinsics.areEqual((Object)node.getType(), (Object)MarkdownElementTypes.LINK_DEFINITION)) ** GOTO lbl-1000
            if (!Intrinsics.areEqual((Object)node.getType(), (Object)MarkdownTokenTypes.EOL)) ** GOTO lbl-1000
            v0 = (ASTNode)CollectionsKt.getOrNull($this$removeUselessTokens, (int)(index - 1));
            if (!Intrinsics.areEqual((Object)(v0 != null ? v0.getType() : null), (Object)MarkdownTokenTypes.HARD_LINE_BREAK)) lbl-1000:
            // 2 sources

            {
                v1 = true;
            } else lbl-1000:
            // 2 sources

            {
                v1 = false;
            }
            if (!v1) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<DocTag> trimSurroundingTokensIfText(List<? extends DocTag> $this$trimSurroundingTokensIfText) {
        void $this$mapIndexedTo$iv$iv;
        Iterable $this$mapIndexed$iv = $this$trimSurroundingTokensIfText;
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void elem;
            void index;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            DocTag docTag = (DocTag)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void elemTransformed = index == false && elem instanceof Text ? (DocTag)Text.copy$default((Text)((Text)elem), (String)((Object)StringsKt.trimStart((CharSequence)((Text)elem).getBody())).toString(), null, null, (int)6, null) : elem;
            collection.add(index == CollectionsKt.getLastIndex($this$trimSurroundingTokensIfText) && elemTransformed instanceof Text ? (DocTag)Text.copy$default((Text)((Text)elemTransformed), (String)((Object)StringsKt.trimEnd((CharSequence)((Text)elemTransformed).getBody())).toString(), null, null, (int)6, null) : elemTransformed);
        }
        return (List)destination$iv$iv;
    }

    private final boolean isNotLeaf(ASTNode $this$isNotLeaf) {
        return $this$isNotLeaf instanceof CompositeASTNode || this.notLeafNodes.contains($this$isNotLeaf.getType());
    }

    private final boolean isNotLeaf(List<? extends ASTNode> $this$isNotLeaf, int index) {
        return (0 <= index ? index <= CollectionsKt.getLastIndex($this$isNotLeaf) : false) ? this.isNotLeaf($this$isNotLeaf.get(index)) : false;
    }

    private final List<ASTNode> mergeLeafASTNodes(List<? extends ASTNode> $this$mergeLeafASTNodes) {
        List children = new ArrayList();
        for (int index = 0; index <= CollectionsKt.getLastIndex($this$mergeLeafASTNodes); ++index) {
            if (this.isNotLeaf($this$mergeLeafASTNodes, index)) {
                ((Collection)children).add($this$mergeLeafASTNodes.get(index));
                continue;
            }
            int startOffset = $this$mergeLeafASTNodes.get(index).getStartOffset();
            int sIndex = index;
            while (index < CollectionsKt.getLastIndex($this$mergeLeafASTNodes)) {
                if (this.isNotLeaf($this$mergeLeafASTNodes, index + 1) || $this$mergeLeafASTNodes.get(index + 1).getStartOffset() != $this$mergeLeafASTNodes.get(index).getEndOffset()) {
                    ((Collection)children).add(this.mergedLeafNode($this$mergeLeafASTNodes, index, startOffset, sIndex));
                    break;
                }
                ++index;
            }
            if (index != CollectionsKt.getLastIndex($this$mergeLeafASTNodes)) continue;
            ((Collection)children).add(this.mergedLeafNode($this$mergeLeafASTNodes, index, startOffset, sIndex));
        }
        return children;
    }

    /*
     * WARNING - void declaration
     */
    private final LeafASTNode mergedLeafNode(List<? extends ASTNode> nodes, int index, int startOffset, int sIndex) {
        boolean bl;
        int endOffset;
        block3: {
            void $this$any$iv;
            endOffset = nodes.get(index).getEndOffset();
            Iterable iterable = nodes.subList(sIndex, index);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ASTNode it = (ASTNode)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.CODE_LINE)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        IElementType type = bl ? MarkdownTokenTypes.CODE_LINE : MarkdownTokenTypes.TEXT;
        return new LeafASTNode(type, startOffset, endOffset);
    }

    private final String transform(String $this$transform) {
        CharSequence charSequence = $this$transform;
        Regex regex = new Regex("\n\n+");
        String string = "";
        charSequence = regex.replace(charSequence, string);
        regex = new Regex("\n");
        string = " ";
        charSequence = regex.replace(charSequence, string);
        regex = new Regex(" >+ +");
        string = " ";
        return regex.replace(charSequence, string);
    }

    private final IllegalStateException detailedException(String baseMessage, ASTNode node) {
        StringBuilder stringBuilder = new StringBuilder().append(baseMessage).append(" in ");
        String string = this.kdocLocation;
        if (string == null) {
            string = "unspecified location";
        }
        StringBuilder stringBuilder2 = stringBuilder.append(string).append(", element starts from offset ").append(node.getStartOffset()).append(" and ends ").append(node.getEndOffset()).append(": ");
        String string2 = this.text;
        if (string2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"text");
            string2 = null;
        }
        String string3 = string2;
        int n = node.getStartOffset();
        int n2 = node.getEndOffset();
        String string4 = string3.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
        return new IllegalStateException(stringBuilder2.append(string4).toString());
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\f\u0010\u0003\u001a\u0004\u0018\u00010\u0004*\u00020\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/dokka/analysis/markdown/jb/MarkdownParser$Companion;", "", "()V", "fqDeclarationName", "", "Lorg/jetbrains/dokka/links/DRI;", "analysis-markdown-jb"})
    @SourceDebugExtension(value={"SMAP\nMarkdownParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarkdownParser.kt\norg/jetbrains/dokka/analysis/markdown/jb/MarkdownParser$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,555:1\n1#2:556\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final String fqDeclarationName(@NotNull DRI $this$fqDeclarationName) {
            Intrinsics.checkNotNullParameter((Object)$this$fqDeclarationName, (String)"<this>");
            if (!($this$fqDeclarationName.getTarget() instanceof PointingToDeclaration)) {
                return null;
            }
            Object object = new String[3];
            object[0] = $this$fqDeclarationName.getPackageName();
            object[1] = $this$fqDeclarationName.getClassNames();
            Callable callable = $this$fqDeclarationName.getCallable();
            object[2] = callable != null ? callable.getName() : null;
            Object it = object = CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOfNotNull((Object[])object), (CharSequence)".", null, null, (int)0, null, null, (int)62, null);
            boolean bl = false;
            return !StringsKt.isBlank((CharSequence)((CharSequence)it)) ? object : null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

