/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json;

import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import kotlinx.serialization.ExperimentalSerializationApi;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.builtins.BuiltinSerializersKt;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.internal.InlineClassDescriptorKt;
import kotlinx.serialization.json.JsonArray;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonLiteral;
import kotlinx.serialization.json.JsonNull;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonPrimitive;
import kotlinx.serialization.json.internal.JsonEncodingException;
import kotlinx.serialization.json.internal.StringOpsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0010\u0001\n\u0002\u0010\u0004\n\u0002\b\u0007\u001a\u0015\u0010>\u001a\u00020\b2\b\u0010?\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010@\u001a\u0012\u0010>\u001a\u00020-2\b\u0010?\u001a\u0004\u0018\u00010AH\u0007\u001a\u0010\u0010>\u001a\u00020\b2\b\u0010?\u001a\u0004\u0018\u00010B\u001a\u0010\u0010>\u001a\u00020\b2\b\u0010?\u001a\u0004\u0018\u00010\u000f\u001a\u0012\u0010C\u001a\u00020\b2\b\u0010?\u001a\u0004\u0018\u00010\u000fH\u0007\u001a\u0018\u0010D\u001a\u00020A2\u0006\u0010E\u001a\u00020\u000f2\u0006\u0010F\u001a\u00020\u000fH\u0001\u001a\u0014\u0010G\u001a\u00020A*\u00020)2\u0006\u0010H\u001a\u00020\u000fH\u0002\"\u001c\u0010\u0000\u001a\u00020\u00018\u0000X\u0081\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0002\u0010\u0003\u001a\u0004\b\u0004\u0010\u0005\"\u0015\u0010\u0006\u001a\u00020\u0007*\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\"\u0017\u0010\u000b\u001a\u0004\u0018\u00010\u0007*\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\"\u0017\u0010\u000e\u001a\u0004\u0018\u00010\u000f*\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\"\u0015\u0010\u0012\u001a\u00020\u0013*\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\"\u0017\u0010\u0016\u001a\u0004\u0018\u00010\u0013*\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\"\u0015\u0010\u0019\u001a\u00020\u001a*\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\"\u0017\u0010\u001d\u001a\u0004\u0018\u00010\u001a*\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001f\"\u0015\u0010 \u001a\u00020!*\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#\"\u0017\u0010$\u001a\u0004\u0018\u00010!*\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010&\"\u0015\u0010'\u001a\u00020(*\u00020)8F\u00a2\u0006\u0006\u001a\u0004\b*\u0010+\"\u0015\u0010,\u001a\u00020-*\u00020)8F\u00a2\u0006\u0006\u001a\u0004\b.\u0010/\"\u0015\u00100\u001a\u000201*\u00020)8F\u00a2\u0006\u0006\u001a\u0004\b2\u00103\"\u0015\u00104\u001a\u00020\b*\u00020)8F\u00a2\u0006\u0006\u001a\u0004\b5\u00106\"\u0015\u00107\u001a\u000208*\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b9\u0010:\"\u0017\u0010;\u001a\u0004\u0018\u000108*\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b<\u0010=\u00a8\u0006I"}, d2={"jsonUnquotedLiteralDescriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "getJsonUnquotedLiteralDescriptor$annotations", "()V", "getJsonUnquotedLiteralDescriptor", "()Lkotlinx/serialization/descriptors/SerialDescriptor;", "boolean", "", "Lkotlinx/serialization/json/JsonPrimitive;", "getBoolean", "(Lkotlinx/serialization/json/JsonPrimitive;)Z", "booleanOrNull", "getBooleanOrNull", "(Lkotlinx/serialization/json/JsonPrimitive;)Ljava/lang/Boolean;", "contentOrNull", "", "getContentOrNull", "(Lkotlinx/serialization/json/JsonPrimitive;)Ljava/lang/String;", "double", "", "getDouble", "(Lkotlinx/serialization/json/JsonPrimitive;)D", "doubleOrNull", "getDoubleOrNull", "(Lkotlinx/serialization/json/JsonPrimitive;)Ljava/lang/Double;", "float", "", "getFloat", "(Lkotlinx/serialization/json/JsonPrimitive;)F", "floatOrNull", "getFloatOrNull", "(Lkotlinx/serialization/json/JsonPrimitive;)Ljava/lang/Float;", "int", "", "getInt", "(Lkotlinx/serialization/json/JsonPrimitive;)I", "intOrNull", "getIntOrNull", "(Lkotlinx/serialization/json/JsonPrimitive;)Ljava/lang/Integer;", "jsonArray", "Lkotlinx/serialization/json/JsonArray;", "Lkotlinx/serialization/json/JsonElement;", "getJsonArray", "(Lkotlinx/serialization/json/JsonElement;)Lkotlinx/serialization/json/JsonArray;", "jsonNull", "Lkotlinx/serialization/json/JsonNull;", "getJsonNull", "(Lkotlinx/serialization/json/JsonElement;)Lkotlinx/serialization/json/JsonNull;", "jsonObject", "Lkotlinx/serialization/json/JsonObject;", "getJsonObject", "(Lkotlinx/serialization/json/JsonElement;)Lkotlinx/serialization/json/JsonObject;", "jsonPrimitive", "getJsonPrimitive", "(Lkotlinx/serialization/json/JsonElement;)Lkotlinx/serialization/json/JsonPrimitive;", "long", "", "getLong", "(Lkotlinx/serialization/json/JsonPrimitive;)J", "longOrNull", "getLongOrNull", "(Lkotlinx/serialization/json/JsonPrimitive;)Ljava/lang/Long;", "JsonPrimitive", "value", "(Ljava/lang/Boolean;)Lkotlinx/serialization/json/JsonPrimitive;", "", "", "JsonUnquotedLiteral", "unexpectedJson", "key", "expected", "error", "element", "kotlinx-serialization-json"})
public final class JsonElementKt {
    @NotNull
    private static final SerialDescriptor jsonUnquotedLiteralDescriptor = InlineClassDescriptorKt.InlinePrimitiveDescriptor((String)"kotlinx.serialization.json.JsonUnquotedLiteral", (KSerializer)BuiltinSerializersKt.serializer((StringCompanionObject)StringCompanionObject.INSTANCE));

    @NotNull
    public static final JsonPrimitive JsonPrimitive(@Nullable Boolean value) {
        if (value == null) {
            return JsonNull.INSTANCE;
        }
        return new JsonLiteral(value, false, null, 4, null);
    }

    @NotNull
    public static final JsonPrimitive JsonPrimitive(@Nullable Number value) {
        if (value == null) {
            return JsonNull.INSTANCE;
        }
        return new JsonLiteral(value, false, null, 4, null);
    }

    @NotNull
    public static final JsonPrimitive JsonPrimitive(@Nullable String value) {
        if (value == null) {
            return JsonNull.INSTANCE;
        }
        return new JsonLiteral(value, true, null, 4, null);
    }

    @ExperimentalSerializationApi
    @NotNull
    public static final JsonNull JsonPrimitive(@Nullable Void value) {
        return JsonNull.INSTANCE;
    }

    @ExperimentalSerializationApi
    @NotNull
    public static final JsonPrimitive JsonUnquotedLiteral(@Nullable String value) {
        JsonPrimitive jsonPrimitive;
        String string = value;
        if (string == null) {
            jsonPrimitive = JsonNull.INSTANCE;
        } else {
            if (Intrinsics.areEqual((Object)string, (Object)JsonNull.INSTANCE.getContent())) {
                throw new JsonEncodingException("Creating a literal unquoted value of 'null' is forbidden. If you want to create JSON null literal, use JsonNull object, otherwise, use JsonPrimitive");
            }
            jsonPrimitive = new JsonLiteral(value, false, jsonUnquotedLiteralDescriptor);
        }
        return jsonPrimitive;
    }

    @NotNull
    public static final SerialDescriptor getJsonUnquotedLiteralDescriptor() {
        return jsonUnquotedLiteralDescriptor;
    }

    public static /* synthetic */ void getJsonUnquotedLiteralDescriptor$annotations() {
    }

    @NotNull
    public static final JsonPrimitive getJsonPrimitive(@NotNull JsonElement $this$jsonPrimitive) {
        Intrinsics.checkNotNullParameter((Object)$this$jsonPrimitive, (String)"<this>");
        JsonPrimitive jsonPrimitive = $this$jsonPrimitive instanceof JsonPrimitive ? (JsonPrimitive)$this$jsonPrimitive : null;
        if (jsonPrimitive == null) {
            JsonElementKt.error($this$jsonPrimitive, "JsonPrimitive");
            throw new KotlinNothingValueException();
        }
        return jsonPrimitive;
    }

    @NotNull
    public static final JsonObject getJsonObject(@NotNull JsonElement $this$jsonObject) {
        Intrinsics.checkNotNullParameter((Object)$this$jsonObject, (String)"<this>");
        JsonObject jsonObject = $this$jsonObject instanceof JsonObject ? (JsonObject)$this$jsonObject : null;
        if (jsonObject == null) {
            JsonElementKt.error($this$jsonObject, "JsonObject");
            throw new KotlinNothingValueException();
        }
        return jsonObject;
    }

    @NotNull
    public static final JsonArray getJsonArray(@NotNull JsonElement $this$jsonArray) {
        Intrinsics.checkNotNullParameter((Object)$this$jsonArray, (String)"<this>");
        JsonArray jsonArray = $this$jsonArray instanceof JsonArray ? (JsonArray)$this$jsonArray : null;
        if (jsonArray == null) {
            JsonElementKt.error($this$jsonArray, "JsonArray");
            throw new KotlinNothingValueException();
        }
        return jsonArray;
    }

    @NotNull
    public static final JsonNull getJsonNull(@NotNull JsonElement $this$jsonNull) {
        Intrinsics.checkNotNullParameter((Object)$this$jsonNull, (String)"<this>");
        JsonNull jsonNull = $this$jsonNull instanceof JsonNull ? (JsonNull)$this$jsonNull : null;
        if (jsonNull == null) {
            JsonElementKt.error($this$jsonNull, "JsonNull");
            throw new KotlinNothingValueException();
        }
        return jsonNull;
    }

    public static final int getInt(@NotNull JsonPrimitive $this$int) {
        Intrinsics.checkNotNullParameter((Object)$this$int, (String)"<this>");
        return Integer.parseInt($this$int.getContent());
    }

    @Nullable
    public static final Integer getIntOrNull(@NotNull JsonPrimitive $this$intOrNull) {
        Intrinsics.checkNotNullParameter((Object)$this$intOrNull, (String)"<this>");
        return StringsKt.toIntOrNull((String)$this$intOrNull.getContent());
    }

    public static final long getLong(@NotNull JsonPrimitive $this$long) {
        Intrinsics.checkNotNullParameter((Object)$this$long, (String)"<this>");
        return Long.parseLong($this$long.getContent());
    }

    @Nullable
    public static final Long getLongOrNull(@NotNull JsonPrimitive $this$longOrNull) {
        Intrinsics.checkNotNullParameter((Object)$this$longOrNull, (String)"<this>");
        return StringsKt.toLongOrNull((String)$this$longOrNull.getContent());
    }

    public static final double getDouble(@NotNull JsonPrimitive $this$double) {
        Intrinsics.checkNotNullParameter((Object)$this$double, (String)"<this>");
        return Double.parseDouble($this$double.getContent());
    }

    @Nullable
    public static final Double getDoubleOrNull(@NotNull JsonPrimitive $this$doubleOrNull) {
        Intrinsics.checkNotNullParameter((Object)$this$doubleOrNull, (String)"<this>");
        return StringsKt.toDoubleOrNull((String)$this$doubleOrNull.getContent());
    }

    public static final float getFloat(@NotNull JsonPrimitive $this$float) {
        Intrinsics.checkNotNullParameter((Object)$this$float, (String)"<this>");
        return Float.parseFloat($this$float.getContent());
    }

    @Nullable
    public static final Float getFloatOrNull(@NotNull JsonPrimitive $this$floatOrNull) {
        Intrinsics.checkNotNullParameter((Object)$this$floatOrNull, (String)"<this>");
        return StringsKt.toFloatOrNull((String)$this$floatOrNull.getContent());
    }

    public static final boolean getBoolean(@NotNull JsonPrimitive $this$boolean) {
        Intrinsics.checkNotNullParameter((Object)$this$boolean, (String)"<this>");
        Boolean bl = StringOpsKt.toBooleanStrictOrNull($this$boolean.getContent());
        if (bl == null) {
            throw new IllegalStateException($this$boolean + " does not represent a Boolean");
        }
        return bl;
    }

    @Nullable
    public static final Boolean getBooleanOrNull(@NotNull JsonPrimitive $this$booleanOrNull) {
        Intrinsics.checkNotNullParameter((Object)$this$booleanOrNull, (String)"<this>");
        return StringOpsKt.toBooleanStrictOrNull($this$booleanOrNull.getContent());
    }

    @Nullable
    public static final String getContentOrNull(@NotNull JsonPrimitive $this$contentOrNull) {
        Intrinsics.checkNotNullParameter((Object)$this$contentOrNull, (String)"<this>");
        return $this$contentOrNull instanceof JsonNull ? null : $this$contentOrNull.getContent();
    }

    private static final Void error(JsonElement $this$error, String element) {
        throw new IllegalArgumentException("Element " + Reflection.getOrCreateKotlinClass($this$error.getClass()) + " is not a " + element);
    }

    @PublishedApi
    @NotNull
    public static final Void unexpectedJson(@NotNull String key, @NotNull String expected) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        throw new IllegalArgumentException("Element " + key + " is not a " + expected);
    }
}

