/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.client;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.jfrog.build.client.ArtifactSpec;

public class ArtifactSpecs
extends LinkedList<ArtifactSpec> {
    public ArtifactSpecs() {
    }

    public ArtifactSpecs(String specsNotation) {
        if (StringUtils.isNotBlank((String)specsNotation)) {
            String[] notations;
            for (String notation : notations = specsNotation.split("\r{0,1}\n")) {
                if (!StringUtils.isNotBlank((String)notation)) continue;
                ArtifactSpec spec = ArtifactSpec.newSpec(notation);
                this.add(spec);
            }
        }
    }

    public Multimap<String, CharSequence> getProperties(ArtifactSpec spec) {
        ArrayListMultimap props = ArrayListMultimap.create();
        for (ArtifactSpec matcherSpec : this) {
            if (!matcherSpec.matches(spec)) continue;
            Map<String, CharSequence> matcherSpecProperties = matcherSpec.getProperties();
            for (Map.Entry<String, CharSequence> entry : matcherSpecProperties.entrySet()) {
                props.put((Object)entry.getKey(), (Object)entry.getValue());
            }
        }
        return props;
    }
}

