/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import com.google.common.base.Charsets;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import org.jfrog.build.extractor.BuildInfoExtractorUtils;
import org.jfrog.build.extractor.ci.Module;

public class ModuleExtractorUtils {
    private static JsonFactory createJsonFactory() {
        JsonFactory jsonFactory = new JsonFactory();
        ObjectMapper mapper = BuildInfoExtractorUtils.createMapper();
        mapper.setAnnotationIntrospector((AnnotationIntrospector)new JacksonAnnotationIntrospector());
        jsonFactory.setCodec((ObjectCodec)mapper);
        return jsonFactory;
    }

    public static String moduleToJsonString(Module module) throws IOException {
        JsonFactory jsonFactory = ModuleExtractorUtils.createJsonFactory();
        StringWriter writer = new StringWriter();
        JsonGenerator jsonGenerator = jsonFactory.createJsonGenerator((Writer)writer);
        jsonGenerator.useDefaultPrettyPrinter();
        jsonGenerator.writeObject((Object)module);
        return writer.getBuffer().toString();
    }

    public static Module jsonStringToModule(String json) throws IOException {
        JsonFactory jsonFactory = ModuleExtractorUtils.createJsonFactory();
        JsonParser parser = jsonFactory.createParser((Reader)new StringReader(json));
        return (Module)jsonFactory.getCodec().readValue(parser, Module.class);
    }

    public static void saveModuleToFile(Module module, File toFile) throws IOException {
        String moduleInfoJson = ModuleExtractorUtils.moduleToJsonString(module);
        if (!toFile.getParentFile().exists()) {
            toFile.getParentFile().mkdirs();
        }
        if (!toFile.exists()) {
            toFile.createNewFile();
        }
        Files.asCharSink((File)toFile, (Charset)Charsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)moduleInfoJson);
    }

    public static Module readModuleFromFile(File fromFile) throws IOException {
        String moduleInfoJson = Files.asCharSource((File)fromFile, (Charset)Charsets.UTF_8).read();
        return ModuleExtractorUtils.jsonStringToModule(moduleInfoJson);
    }
}

