/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.usageReport;

import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.extractor.usageReport.UsageReporter;

public class ClientIdUsageReporter
extends UsageReporter {
    private final Log logger;
    private final String uniqueClientId;

    public String getUniqueClientId() {
        return this.uniqueClientId;
    }

    public ClientIdUsageReporter(String productId, String[] featureIds, Log logger) {
        super(productId, featureIds);
        this.logger = logger;
        this.uniqueClientId = this.generateUniqueClientId();
    }

    private String generateUniqueClientId() {
        byte[] macAddress = null;
        try {
            macAddress = ClientIdUsageReporter.getMacAddress();
        }
        catch (SocketException e) {
            this.logger.warn("Wasn't able to generate unique client ID: " + ExceptionUtils.getRootCauseMessage((Throwable)e));
        }
        return macAddress != null ? DigestUtils.sha1Hex((byte[])macAddress) : null;
    }

    private static byte[] getMacAddress() throws SocketException {
        Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
        while (networkInterfaces.hasMoreElements()) {
            NetworkInterface networkInterface = networkInterfaces.nextElement();
            byte[] macAddressed = networkInterface.getHardwareAddress();
            if (macAddressed == null) continue;
            return macAddressed;
        }
        return null;
    }
}

