/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor;

import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.util.List;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.jfrog.build.extractor.Proxy;

public class ProxySelector {
    private static final String SYSTEM_PROPERTY_HTTP_PROXY_HOST = "http.proxyHost";
    private static final String SYSTEM_PROPERTY_HTTP_PROXY_PORT = "http.proxyPort";
    private static final String SYSTEM_PROPERTY_HTTP_PROXY_USERNAME = "http.proxyUser";
    private static final String SYSTEM_PROPERTY_HTTP_PROXY_PASSWORD = "http.proxyPassword";
    private static final String SYSTEM_PROPERTY_HTTPS_PROXY_HOST = "https.proxyHost";
    private static final String SYSTEM_PROPERTY_HTTPS_PROXY_PORT = "https.proxyPort";
    private static final String SYSTEM_PROPERTY_HTTPS_PROXY_USERNAME = "https.proxyUser";
    private static final String SYSTEM_PROPERTY_HTTPS_PROXY_PASSWORD = "https.proxyPassword";
    private static final String SYSTEM_PROPERTY_NO_PROXY = "http.nonProxyHosts";
    private final String noProxy;
    private Proxy httpProxy;
    private Proxy httpsProxy;

    public ProxySelector(String httpHost, int httpPort, String httpUsername, String httpPassword, String httpsHost, int httpsPort, String httpsUsername, String httpsPassword, String noProxy) {
        if (StringUtils.isNotBlank((CharSequence)httpHost)) {
            this.httpProxy = new Proxy(httpHost, httpPort, httpUsername, httpPassword, false);
        }
        if (StringUtils.isNotBlank((CharSequence)httpsHost)) {
            this.httpsProxy = new Proxy(httpsHost, httpsPort, httpsUsername, httpsPassword, true);
        }
        this.noProxy = StringUtils.replace((String)noProxy, (String)",", (String)"|");
    }

    public Proxy getProxy(String repositoryUrl) {
        if (!this.isProxyAvailable()) {
            return null;
        }
        if (!this.isValidRepoUrl(repositoryUrl)) {
            return null;
        }
        java.net.Proxy proxy = this.selectProxy(repositoryUrl);
        if (proxy == null) {
            return null;
        }
        InetSocketAddress inetAddr = (InetSocketAddress)proxy.address();
        if (this.httpsProxy != null && StringUtils.equals((CharSequence)inetAddr.getHostName(), (CharSequence)this.httpsProxy.getHost())) {
            return this.httpsProxy;
        }
        if (this.httpProxy != null && StringUtils.equals((CharSequence)inetAddr.getHostName(), (CharSequence)this.httpProxy.getHost())) {
            return this.httpProxy;
        }
        return null;
    }

    private boolean isProxyAvailable() {
        return this.httpProxy != null || this.httpsProxy != null;
    }

    private boolean isValidRepoUrl(String repoUrl) {
        return StringUtils.startsWith((CharSequence)repoUrl.toLowerCase(), (CharSequence)"http");
    }

    private java.net.Proxy selectProxy(String repositoryUrl) {
        Properties propsBackup = this.setupProxySelector();
        List<java.net.Proxy> applicableProxies = java.net.ProxySelector.getDefault().select(URI.create(repositoryUrl));
        propsBackup.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> System.setProperty(key.toString(), value.toString())));
        return applicableProxies.stream().filter(p -> p.type() == Proxy.Type.HTTP).findFirst().orElse(null);
    }

    private Properties setupProxySelector() {
        Properties propsBackup = this.getProxyProperties();
        this.fillSelectorConfig(this.httpProxy, SYSTEM_PROPERTY_HTTP_PROXY_HOST, SYSTEM_PROPERTY_HTTP_PROXY_PORT, SYSTEM_PROPERTY_HTTP_PROXY_USERNAME, SYSTEM_PROPERTY_HTTP_PROXY_PASSWORD);
        this.fillSelectorConfig(this.httpsProxy, SYSTEM_PROPERTY_HTTPS_PROXY_HOST, SYSTEM_PROPERTY_HTTPS_PROXY_PORT, SYSTEM_PROPERTY_HTTPS_PROXY_USERNAME, SYSTEM_PROPERTY_HTTPS_PROXY_PASSWORD);
        if (StringUtils.isNotBlank((CharSequence)this.noProxy)) {
            System.setProperty(SYSTEM_PROPERTY_NO_PROXY, this.noProxy);
        }
        return propsBackup;
    }

    private Properties getProxyProperties() {
        Properties props = new Properties();
        Stream.of(SYSTEM_PROPERTY_HTTP_PROXY_HOST, SYSTEM_PROPERTY_HTTP_PROXY_PORT, SYSTEM_PROPERTY_HTTP_PROXY_USERNAME, SYSTEM_PROPERTY_HTTP_PROXY_PASSWORD, SYSTEM_PROPERTY_HTTPS_PROXY_HOST, SYSTEM_PROPERTY_HTTPS_PROXY_PORT, SYSTEM_PROPERTY_HTTPS_PROXY_USERNAME, SYSTEM_PROPERTY_HTTPS_PROXY_PASSWORD, SYSTEM_PROPERTY_NO_PROXY).forEach(key -> {
            String value = StringUtils.isNotBlank((CharSequence)System.getProperty(key)) ? System.getProperty(key) : "";
            props.setProperty((String)key, value);
        });
        return props;
    }

    private void fillSelectorConfig(Proxy proxy, String hostKey, String portKey, String usernameKey, String passwordKey) {
        if (proxy != null) {
            if (proxy.getPort() <= 0 || StringUtils.isBlank((CharSequence)proxy.getHost())) {
                return;
            }
            System.setProperty(hostKey, proxy.getHost());
            System.setProperty(portKey, Integer.toString(proxy.getPort()));
            if (StringUtils.isNotBlank((CharSequence)proxy.getUsername())) {
                System.setProperty(usernameKey, proxy.getUsername());
            }
            if (StringUtils.isNotBlank((CharSequence)proxy.getPassword())) {
                System.setProperty(passwordKey, proxy.getPassword());
            }
        }
    }
}

