/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.clientConfiguration.client.artifactory.services;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpRequestBase;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.extractor.UrlUtils;
import org.jfrog.build.extractor.clientConfiguration.client.JFrogService;

public abstract class DownloadBase<TResult>
extends JFrogService<TResult> {
    private final String downloadPath;
    private final boolean isHead;
    private final Map<String, String> headers;

    protected DownloadBase(String downloadPath, boolean isHead, Map<String, String> headers, Log log) {
        super(log);
        this.downloadPath = UrlUtils.encodeUrl(downloadPath);
        this.isHead = isHead;
        this.headers = headers;
    }

    @Override
    public HttpRequestBase createRequest() throws IOException {
        HttpHead request = this.isHead ? new HttpHead(this.downloadPath) : new HttpGet(this.downloadPath);
        request.setHeader("Connection", "Keep-Alive");
        if (this.headers != null) {
            for (Map.Entry<String, String> entry : this.headers.entrySet()) {
                request.setHeader(entry.getKey(), entry.getValue());
            }
        }
        return request;
    }

    @Override
    protected void handleUnsuccessfulResponse(HttpEntity entity) throws IOException {
        if (this.statusCode == 404) {
            throw new FileNotFoundException("Unable to find " + this.downloadPath);
        }
        this.log.error("Failed to download from '" + this.downloadPath + "'");
        DownloadBase.throwException(entity, this.getStatusCode());
    }
}

