/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.buildScanTable;

import org.jfrog.build.api.util.CommonUtils;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.client.artifactoryXrayResponse.Alert;
import org.jfrog.build.client.artifactoryXrayResponse.ArtifactoryXrayResponse;
import org.jfrog.build.client.artifactoryXrayResponse.ImpactedArtifact;
import org.jfrog.build.client.artifactoryXrayResponse.InfectedFile;
import org.jfrog.build.client.artifactoryXrayResponse.Issue;
import org.jfrog.build.extractor.buildScanTable.LicenseViolationsTable;
import org.jfrog.build.extractor.buildScanTable.SecurityViolationsTable;

public class BuildScanTableHelper {
    private ArtifactoryXrayResponse scanResult;
    private Log log;
    SecurityViolationsTable securityViolationsTable;
    LicenseViolationsTable licenseViolationsTable;

    public void printTable(ArtifactoryXrayResponse scanResult, Log log) {
        this.scanResult = scanResult;
        this.log = log;
        this.securityViolationsTable = new SecurityViolationsTable(log);
        this.licenseViolationsTable = new LicenseViolationsTable(log);
        this.generateResultTable();
        this.doPrintTables();
    }

    private void doPrintTables() {
        this.securityViolationsTable.printTable();
        this.log.info("");
        this.licenseViolationsTable.printTable();
    }

    private void generateResultTable() {
        for (Alert alert : CommonUtils.emptyIfNull((Iterable)this.scanResult.getAlerts())) {
            for (Issue issue : CommonUtils.emptyIfNull((Iterable)alert.getIssues())) {
                for (ImpactedArtifact impactedArtifact : CommonUtils.emptyIfNull((Iterable)issue.getImpactedArtifacts())) {
                    for (InfectedFile infectedFile : CommonUtils.emptyIfNull((Iterable)impactedArtifact.getInfectedFiles())) {
                        this.addElement(issue, infectedFile);
                    }
                }
            }
        }
    }

    private void addElement(Issue issue, InfectedFile infectedFile) {
        Issue.IssueType issueType = issue.getIssueType();
        if (issueType == Issue.IssueType.SECURITY) {
            this.securityViolationsTable.addElement(issue, infectedFile);
        } else if (issueType == Issue.IssueType.LICENSE) {
            this.licenseViolationsTable.addElement(issue, infectedFile);
        }
    }
}

