/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.gradle.plugin.artifactory;

import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.TaskProvider;
import org.jfrog.gradle.plugin.artifactory.dsl.ArtifactoryPluginConvention;
import org.jfrog.gradle.plugin.artifactory.listener.ArtifactoryDependencyResolutionListener;
import org.jfrog.gradle.plugin.artifactory.listener.ProjectsEvaluatedBuildListener;
import org.jfrog.gradle.plugin.artifactory.task.ArtifactoryTask;
import org.jfrog.gradle.plugin.artifactory.utils.ExtensionsUtils;
import org.jfrog.gradle.plugin.artifactory.utils.PluginUtils;
import org.jfrog.gradle.plugin.artifactory.utils.ProjectUtils;
import org.jfrog.gradle.plugin.artifactory.utils.TaskUtils;

public class ArtifactoryPlugin
implements Plugin<Project> {
    private static final Logger log = Logging.getLogger(ArtifactoryPlugin.class);
    private final ArtifactoryDependencyResolutionListener resolutionListener = new ArtifactoryDependencyResolutionListener();
    private final ProjectsEvaluatedBuildListener projectsEvaluatedBuildListener = new ProjectsEvaluatedBuildListener();

    public void apply(Project project) {
        if (!this.shouldApplyPluginOnProject(project)) {
            return;
        }
        ArtifactoryPluginConvention extension = ExtensionsUtils.getOrCreateArtifactoryExtension(project);
        TaskProvider<ArtifactoryTask> collectDeployDetailsTask = TaskUtils.addCollectDeployDetailsTask(project);
        TaskUtils.addExtractModuleInfoTask(collectDeployDetailsTask, project);
        if (ProjectUtils.isRootProject(project)) {
            TaskUtils.addDeploymentTask(project);
            project.getAllprojects().forEach(subproject -> {
                subproject.getConfigurations().all(config -> config.getIncoming().afterResolve(this.resolutionListener::afterResolve));
                if (!subproject.getState().getExecuted()) {
                    subproject.afterEvaluate(this.projectsEvaluatedBuildListener::afterEvaluate);
                }
            });
            project.getGradle().projectsEvaluated(this.projectsEvaluatedBuildListener::projectsEvaluated);
        } else {
            project.getRootProject().getPluginManager().apply(ArtifactoryPlugin.class);
        }
        String buildStarted = extension.getClientConfig().info.getBuildStarted();
        if (buildStarted == null || buildStarted.isEmpty()) {
            extension.getClientConfig().info.setBuildStarted(System.currentTimeMillis());
        }
        log.debug("Using Artifactory Plugin for " + project.getPath());
    }

    private boolean shouldApplyPluginOnProject(Project project) {
        if ("buildSrc".equals(project.getName())) {
            log.debug("Artifactory Plugin disabled for {}", (Object)project.getPath());
            return false;
        }
        PluginUtils.assertGradleVersionSupported(project.getGradle());
        return true;
    }

    public ArtifactoryDependencyResolutionListener getResolutionListener() {
        return this.resolutionListener;
    }
}

