/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.gradle.plugin.artifactory.extractor.publication;

import java.io.File;
import java.util.Map;
import javax.xml.namespace.QName;
import org.gradle.api.publish.Publication;
import org.gradle.api.publish.tasks.GenerateModuleMetadata;
import org.gradle.plugins.signing.Sign;
import org.jfrog.build.extractor.clientConfiguration.deploy.DeployDetails;
import org.jfrog.gradle.plugin.artifactory.extractor.PublishArtifactInfo;
import org.jfrog.gradle.plugin.artifactory.task.ArtifactoryTask;
import org.jfrog.gradle.plugin.artifactory.utils.PublicationUtils;

public abstract class PublicationExtractor<ActualPublication extends Publication> {
    protected ArtifactoryTask artifactoryTask;
    private final String[] SIGNATURE_EXTENSIONS = new String[]{"asc", "sig"};

    public PublicationExtractor(ArtifactoryTask artifactoryTask) {
        this.artifactoryTask = artifactoryTask;
    }

    public abstract void extractDeployDetails(ActualPublication var1);

    protected abstract void addArtifactToDeployDetails(ActualPublication var1, DeployDetails.Builder var2, PublishArtifactInfo var3);

    protected abstract String getPublicationArtifactId(ActualPublication var1);

    protected abstract boolean isApplicablePublication(Publication var1);

    public void extractModuleInfo() {
        for (GenerateModuleMetadata generateModuleMetadata : this.artifactoryTask.getProject().getTasks().withType(GenerateModuleMetadata.class)) {
            File moduleMetadata;
            Publication publication = (Publication)generateModuleMetadata.getPublication().get();
            if (!this.isApplicablePublication(publication) || !(moduleMetadata = (File)generateModuleMetadata.getOutputFile().getAsFile().get()).exists()) continue;
            Publication actualPublication = publication;
            this.buildAndPublishArtifactWithSignatures(moduleMetadata, actualPublication, this.getPublicationArtifactId(actualPublication), "module", "module", null, null);
        }
    }

    protected void buildAndPublishArtifactWithSignatures(File file, ActualPublication publication, String artifactId, String artifactExtension, String artifactType, String artifactClassifier, Map<QName, String> extraInfo) {
        this.buildAndPublishArtifact(file, publication, artifactId, artifactExtension, artifactType, artifactClassifier, extraInfo);
        if (!this.isSignTaskExists()) {
            return;
        }
        for (String signatureExtension : this.SIGNATURE_EXTENSIONS) {
            File signatureFile = new File(file.getAbsolutePath() + "." + signatureExtension);
            if (!signatureFile.exists()) continue;
            this.buildAndPublishArtifact(signatureFile, publication, artifactId, artifactType + "." + signatureExtension, artifactType + "." + signatureExtension, artifactClassifier, extraInfo);
        }
    }

    private void buildAndPublishArtifact(File file, ActualPublication publication, String artifactId, String artifactExtension, String artifactType, String artifactClassifier, Map<QName, String> extraInfo) {
        DeployDetails.Builder builder = PublicationUtils.createArtifactBuilder(file, publication.getName());
        PublishArtifactInfo artifactInfo = new PublishArtifactInfo(artifactId, artifactExtension, artifactType, artifactClassifier, extraInfo, file);
        this.addArtifactToDeployDetails(publication, builder, artifactInfo);
    }

    private boolean isSignTaskExists() {
        return !this.artifactoryTask.getProject().getTasks().withType(Sign.class).isEmpty();
    }
}

