/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.maven;

import org.apache.commons.lang.StringUtils;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.client.ArtifactoryBuildInfoClient;
import org.jfrog.build.client.ArtifactoryClientConfiguration;
import org.jfrog.build.extractor.maven.Maven3BuildInfoLogger;

@Component(role=BuildInfoClientBuilder.class)
public class BuildInfoClientBuilder {
    @Requirement
    private Logger logger;

    public ArtifactoryBuildInfoClient resolveProperties(ArtifactoryClientConfiguration clientConf) {
        ArtifactoryBuildInfoClient client = this.resolveClientProps(clientConf);
        this.resolveTimeout(clientConf, client);
        this.resolveProxy(clientConf.proxy, client);
        return client;
    }

    private ArtifactoryBuildInfoClient resolveClientProps(ArtifactoryClientConfiguration clientConf) {
        String contextUrl = clientConf.publisher.getContextUrl();
        if (StringUtils.isBlank((String)contextUrl)) {
            throw new IllegalArgumentException("Unable to resolve Artifactory Build Info Client properties: no context URL was found.");
        }
        this.logResolvedProperty(clientConf.publisher.getPrefix() + "." + "contextUrl", contextUrl);
        String username = clientConf.publisher.getUsername();
        String password = clientConf.publisher.getPassword();
        if (StringUtils.isNotBlank((String)username)) {
            this.logResolvedProperty("username", username);
            return new ArtifactoryBuildInfoClient(contextUrl, username, password, (Log)new Maven3BuildInfoLogger(this.logger));
        }
        return new ArtifactoryBuildInfoClient(contextUrl, (Log)new Maven3BuildInfoLogger(this.logger));
    }

    private void resolveTimeout(ArtifactoryClientConfiguration clientConf, ArtifactoryBuildInfoClient client) {
        if (clientConf.getTimeout() == null) {
            return;
        }
        String timeout = clientConf.getTimeout().toString();
        if (StringUtils.isNotBlank((String)timeout)) {
            this.logResolvedProperty("artifactory.timeout", timeout);
            if (!StringUtils.isNumeric((String)timeout)) {
                this.logger.debug("Unable to resolve Artifactory Build Info Client timeout: value is non-numeric.");
                return;
            }
            client.setConnectionTimeout(Integer.valueOf(timeout).intValue());
        }
    }

    private void resolveProxy(ArtifactoryClientConfiguration.ProxyHandler proxyConf, ArtifactoryBuildInfoClient client) {
        String proxyHost = proxyConf.getHost();
        if (StringUtils.isNotBlank((String)proxyHost)) {
            this.logResolvedProperty("host", proxyHost);
            if (proxyConf.getPort() == null) {
                return;
            }
            String proxyUsername = proxyConf.getUsername();
            if (StringUtils.isNotBlank((String)proxyUsername)) {
                this.logResolvedProperty("username", proxyUsername);
                client.setProxyConfiguration(proxyHost, proxyConf.getPort().intValue(), proxyUsername, proxyConf.getPassword());
            } else {
                client.setProxyConfiguration(proxyHost, proxyConf.getPort().intValue());
            }
        }
    }

    private void logResolvedProperty(String key, String value) {
        this.logger.debug("Artifactory Client Property Resolver: " + key + " = " + value);
    }
}

