/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.maven;

import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.Maven;
import org.apache.maven.execution.ExecutionEvent;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.jfrog.build.api.Agent;
import org.jfrog.build.api.BlackDuckProperties;
import org.jfrog.build.api.BuildAgent;
import org.jfrog.build.api.BuildRetention;
import org.jfrog.build.api.BuildType;
import org.jfrog.build.api.Governance;
import org.jfrog.build.api.IssueTracker;
import org.jfrog.build.api.Issues;
import org.jfrog.build.api.LicenseControl;
import org.jfrog.build.api.builder.BuildInfoMavenBuilder;
import org.jfrog.build.api.builder.PromotionStatusBuilder;
import org.jfrog.build.client.ArtifactoryClientConfiguration;
import org.jfrog.build.extractor.maven.BuildInfoRecorder;

@Component(role=BuildInfoModelPropertyResolver.class)
public class BuildInfoModelPropertyResolver {
    @Requirement
    private Logger logger;

    public BuildInfoMavenBuilder resolveProperties(ExecutionEvent event, ArtifactoryClientConfiguration clientConf) {
        String[] notToDelete;
        int minimumDays;
        String buildRetentionMinimumDays;
        String agentVersion;
        String vcsRevision;
        BuildInfoMavenBuilder builder = this.resolveCoreProperties(event, clientConf).artifactoryPrincipal(clientConf.publisher.getName()).principal(clientConf.info.getPrincipal()).type(BuildType.MAVEN).parentName(clientConf.info.getParentBuildName()).parentNumber(clientConf.info.getParentBuildNumber());
        String buildUrl = clientConf.info.getBuildUrl();
        if (StringUtils.isNotBlank((String)buildUrl)) {
            builder.url(buildUrl);
        }
        if (StringUtils.isNotBlank((String)(vcsRevision = clientConf.info.getVcsRevision()))) {
            builder.vcsRevision(vcsRevision);
        }
        BuildAgent buildAgent = new BuildAgent("Maven", this.getMavenVersion());
        builder.buildAgent(buildAgent);
        String agentName = clientConf.info.getAgentName();
        if (StringUtils.isBlank((String)agentName)) {
            agentName = buildAgent.getName();
        }
        if (StringUtils.isBlank((String)(agentVersion = clientConf.info.getAgentVersion()))) {
            agentVersion = buildAgent.getVersion();
        }
        builder.agent(new Agent(agentName, agentVersion));
        LicenseControl licenseControl = new LicenseControl(clientConf.info.licenseControl.isRunChecks().booleanValue());
        String notificationRecipients = clientConf.info.licenseControl.getViolationRecipients();
        if (StringUtils.isNotBlank((String)notificationRecipients)) {
            licenseControl.setLicenseViolationsRecipientsList(notificationRecipients);
        }
        licenseControl.setIncludePublishedArtifacts(clientConf.info.licenseControl.isIncludePublishedArtifacts().booleanValue());
        licenseControl.setScopesList(clientConf.info.licenseControl.getScopes());
        licenseControl.setAutoDiscover(clientConf.info.licenseControl.isAutoDiscover().booleanValue());
        builder.licenseControl(licenseControl);
        BlackDuckProperties blackDuckProperties = clientConf.info.blackDuckProperties.isRunChecks() ? clientConf.info.blackDuckProperties.copyBlackDuckProperties() : new BlackDuckProperties();
        Governance governance = new Governance();
        governance.setBlackDuckProperties(blackDuckProperties);
        builder.governance(governance);
        BuildRetention buildRetention = new BuildRetention(clientConf.info.isDeleteBuildArtifacts().booleanValue());
        if (clientConf.info.getBuildRetentionCount() != null) {
            buildRetention.setCount(clientConf.info.getBuildRetentionCount().intValue());
        }
        if (StringUtils.isNotBlank((String)(buildRetentionMinimumDays = clientConf.info.getBuildRetentionMinimumDate())) && (minimumDays = Integer.parseInt(buildRetentionMinimumDays)) > -1) {
            Calendar calendar = Calendar.getInstance();
            calendar.add(6, -minimumDays);
            buildRetention.setMinimumBuildDate(calendar.getTime());
        }
        for (String notToDel : notToDelete = clientConf.info.getBuildNumbersNotToDelete()) {
            buildRetention.addBuildNotToBeDiscarded(notToDel);
        }
        this.attachStagingIfNeeded(clientConf, builder);
        builder.buildRetention(buildRetention);
        builder.artifactoryPrincipal(clientConf.publisher.getName());
        String issueTrackerName = clientConf.info.issues.getIssueTrackerName();
        if (StringUtils.isNotBlank((String)issueTrackerName)) {
            Issues issues = new Issues();
            issues.setAggregateBuildIssues(clientConf.info.issues.getAggregateBuildIssues());
            issues.setAggregationBuildStatus(clientConf.info.issues.getAggregationBuildStatus());
            issues.setTracker(new IssueTracker(issueTrackerName, clientConf.info.issues.getIssueTrackerVersion()));
            Set affectedIssuesSet = clientConf.info.issues.getAffectedIssuesSet();
            if (!affectedIssuesSet.isEmpty()) {
                issues.setAffectedIssues(affectedIssuesSet);
            }
            builder.issues(issues);
        }
        return builder;
    }

    private void attachStagingIfNeeded(ArtifactoryClientConfiguration clientConf, BuildInfoMavenBuilder builder) {
        if (clientConf.info.isReleaseEnabled().booleanValue()) {
            Date buildStartDate;
            String stagingRepository = clientConf.publisher.getRepoKey();
            String comment = clientConf.info.getReleaseComment();
            if (comment == null) {
                comment = "";
            }
            String buildStartedIso = clientConf.info.getBuildStarted();
            try {
                buildStartDate = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").parse(buildStartedIso);
            }
            catch (ParseException e) {
                throw new IllegalArgumentException("Build start date format error: " + buildStartedIso, e);
            }
            builder.addStatus(new PromotionStatusBuilder("Staged").timestampDate(buildStartDate).comment(comment).repository(stagingRepository).ciUser(clientConf.info.getPrincipal()).user(clientConf.publisher.getUsername()).build());
        }
    }

    private BuildInfoMavenBuilder resolveCoreProperties(ExecutionEvent event, ArtifactoryClientConfiguration clientConf) {
        String buildTimestamp;
        String buildNumber;
        String buildName = clientConf.info.getBuildName();
        if (StringUtils.isBlank((String)buildName)) {
            buildName = event.getSession().getTopLevelProject().getName();
        }
        if (StringUtils.isBlank((String)(buildNumber = clientConf.info.getBuildNumber()))) {
            buildNumber = Long.toString(System.currentTimeMillis());
        }
        Date buildStartedDate = event.getSession().getRequest().getStartTime();
        String buildStarted = clientConf.info.getBuildStarted();
        if (StringUtils.isBlank((String)buildStarted)) {
            buildStarted = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").format(buildStartedDate);
        }
        if (StringUtils.isBlank((String)(buildTimestamp = clientConf.info.getBuildTimestamp()))) {
            buildTimestamp = Long.toString(buildStartedDate.getTime());
        }
        this.logResolvedProperty("build.name", buildName);
        this.logResolvedProperty("build.number", buildNumber);
        this.logResolvedProperty("build.started", buildStarted);
        this.logResolvedProperty("build.timestamp", buildTimestamp);
        return new BuildInfoMavenBuilder(buildName).number(buildNumber).started(buildStarted);
    }

    private String getMavenVersion() {
        Properties mavenVersionProperties = new Properties();
        InputStream inputStream = BuildInfoRecorder.class.getClassLoader().getResourceAsStream("org/apache/maven/messages/build.properties");
        if (inputStream == null) {
            inputStream = Maven.class.getClassLoader().getResourceAsStream("META-INF/maven/org.apache.maven/maven-core/pom.properties");
        }
        if (inputStream == null) {
            throw new RuntimeException("Could not extract Maven version: unable to find resources 'org/apache/maven/messages/build.properties' or 'META-INF/maven/org.apache.maven/maven-core/pom.properties'");
        }
        try {
            mavenVersionProperties.load(inputStream);
        }
        catch (IOException e) {
            throw new RuntimeException("Error while extracting Maven version properties from: org/apache/maven/messages/build.properties", e);
        }
        finally {
            Closeables.closeQuietly((Closeable)inputStream);
        }
        String version = mavenVersionProperties.getProperty("version");
        if (StringUtils.isBlank((String)version)) {
            throw new RuntimeException("Could not extract Maven version: no version property found in the resource 'org/apache/maven/messages/build.properties'");
        }
        return version;
    }

    private void logResolvedProperty(String key, String value) {
        this.logger.debug("Artifactory Build Info Model Property Resolver: " + key + " = " + value);
    }
}

