/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.maven;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.execution.AbstractExecutionListener;
import org.apache.maven.execution.ExecutionEvent;
import org.apache.maven.execution.ExecutionListener;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.artifact.ProjectArtifactMetadata;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.jfrog.build.api.Build;
import org.jfrog.build.api.builder.ArtifactBuilder;
import org.jfrog.build.api.builder.BuildInfoMavenBuilder;
import org.jfrog.build.api.builder.DependencyBuilder;
import org.jfrog.build.api.builder.ModuleBuilder;
import org.jfrog.build.api.util.FileChecksumCalculator;
import org.jfrog.build.client.ArtifactoryClientConfiguration;
import org.jfrog.build.client.DeployDetails;
import org.jfrog.build.client.IncludeExcludePatterns;
import org.jfrog.build.client.PatternMatcher;
import org.jfrog.build.extractor.BuildInfoExtractor;
import org.jfrog.build.extractor.BuildInfoExtractorUtils;
import org.jfrog.build.extractor.maven.BuildDeploymentHelper;
import org.jfrog.build.extractor.maven.BuildInfoModelPropertyResolver;
import org.xml.sax.InputSource;

@Component(role=BuildInfoRecorder.class)
public class BuildInfoRecorder
extends AbstractExecutionListener
implements BuildInfoExtractor<ExecutionEvent, Build> {
    @Requirement
    private Logger logger;
    @Requirement
    private BuildInfoModelPropertyResolver buildInfoModelPropertyResolver;
    @Requirement
    private BuildDeploymentHelper buildDeploymentHelper;
    private ExecutionListener wrappedListener;
    private BuildInfoMavenBuilder buildInfoBuilder;
    private ThreadLocal<ModuleBuilder> currentModule = new ThreadLocal();
    private ThreadLocal<Set<Artifact>> currentModuleArtifacts = new ThreadLocal();
    private ThreadLocal<Set<Artifact>> currentModuleDependencies = new ThreadLocal();
    private volatile boolean projectHasTestFailures;
    private Map<String, DeployDetails> deployableArtifactBuilderMap;
    private ArtifactoryClientConfiguration conf;
    private Map<String, String> matrixParams;

    public void setListenerToWrap(ExecutionListener executionListener) {
        this.wrappedListener = executionListener;
    }

    public void setConfiguration(ArtifactoryClientConfiguration conf) {
        this.conf = conf;
    }

    public void projectDiscoveryStarted(ExecutionEvent event) {
        if (this.wrappedListener != null) {
            this.wrappedListener.projectDiscoveryStarted(event);
        }
    }

    public void sessionStarted(ExecutionEvent event) {
        try {
            this.logger.info("Initializing Artifactory Build-Info Recording");
            this.buildInfoBuilder = this.buildInfoModelPropertyResolver.resolveProperties(event, this.conf);
            this.deployableArtifactBuilderMap = Maps.newHashMap();
            this.matrixParams = Maps.newHashMap();
            ImmutableMap matrixParamProps = this.conf.publisher.getMatrixParams();
            for (Map.Entry matrixParamProp : matrixParamProps.entrySet()) {
                String key = (String)matrixParamProp.getKey();
                key = StringUtils.removeStartIgnoreCase((String)key, (String)"artifactory.deploy.");
                this.matrixParams.put(key, (String)matrixParamProp.getValue());
            }
            if (this.wrappedListener != null) {
                this.wrappedListener.sessionStarted(event);
            }
        }
        catch (Throwable t) {
            String message = ((Object)((Object)this)).getClass().getName() + ".sessionStarted() listener has failed: ";
            this.logger.error(message, t);
            throw new RuntimeException(message, t);
        }
    }

    public void sessionEnded(ExecutionEvent event) {
        try {
            Build build = this.extract(event);
            if (build != null) {
                File basedir = event.getSession().getTopLevelProject().getBasedir();
                this.conf.persistToPropertiesFile();
                this.buildDeploymentHelper.deploy(build, this.conf, this.deployableArtifactBuilderMap, this.projectHasTestFailures, basedir);
            }
            this.deployableArtifactBuilderMap.clear();
            if (this.wrappedListener != null) {
                this.wrappedListener.sessionEnded(event);
            }
        }
        catch (Throwable t) {
            String message = ((Object)((Object)this)).getClass().getName() + ".sessionEnded() listener has failed: ";
            this.logger.error(message, t);
            throw new RuntimeException(message, t);
        }
        finally {
            File file;
            String propertyFilePath = System.getenv("buildInfoConfig.propertiesFile");
            if (StringUtils.isNotBlank((String)propertyFilePath) && (file = new File(propertyFilePath)).exists()) {
                file.delete();
            }
        }
    }

    public void projectSkipped(ExecutionEvent event) {
        if (this.wrappedListener != null) {
            this.wrappedListener.projectSkipped(event);
        }
    }

    public void projectStarted(ExecutionEvent event) {
        MavenProject project = event.getProject();
        this.initModule(project);
        if (this.wrappedListener != null) {
            this.wrappedListener.projectStarted(event);
        }
    }

    public void projectSucceeded(ExecutionEvent event) {
        this.finalizeModule(event.getProject());
        if (this.wrappedListener != null) {
            this.wrappedListener.projectSucceeded(event);
        }
    }

    public void projectFailed(ExecutionEvent event) {
        if (this.wrappedListener != null) {
            this.wrappedListener.projectFailed(event);
        }
    }

    public void forkStarted(ExecutionEvent event) {
        if (this.wrappedListener != null) {
            this.wrappedListener.forkStarted(event);
        }
    }

    public void forkSucceeded(ExecutionEvent event) {
        if (this.wrappedListener != null) {
            this.wrappedListener.forkSucceeded(event);
        }
    }

    public void forkFailed(ExecutionEvent event) {
        if (this.wrappedListener != null) {
            this.wrappedListener.forkFailed(event);
        }
    }

    public void forkedProjectStarted(ExecutionEvent event) {
        if (this.wrappedListener != null) {
            this.wrappedListener.forkedProjectStarted(event);
        }
    }

    public void forkedProjectSucceeded(ExecutionEvent event) {
        if (this.wrappedListener != null) {
            this.wrappedListener.forkedProjectSucceeded(event);
        }
    }

    public void forkedProjectFailed(ExecutionEvent event) {
        if (this.wrappedListener != null) {
            this.wrappedListener.forkedProjectFailed(event);
        }
    }

    public void mojoSkipped(ExecutionEvent event) {
        if (this.wrappedListener != null) {
            this.wrappedListener.mojoSkipped(event);
        }
    }

    public void mojoStarted(ExecutionEvent event) {
        if (this.wrappedListener != null) {
            this.wrappedListener.mojoStarted(event);
        }
    }

    public void mojoSucceeded(ExecutionEvent event) {
        List<File> resultsFile;
        MavenProject project = event.getProject();
        if (project == null) {
            this.logger.warn("Skipping Artifactory Build-Info dependency extraction: Null project.");
            return;
        }
        if ("maven-surefire-plugin".equals(event.getMojoExecution().getPlugin().getArtifactId()) && this.isTestsFailed(resultsFile = this.getSurefireResultsFile(project))) {
            this.projectHasTestFailures = true;
        }
        this.extractModuleDependencies(project);
        if (this.wrappedListener != null) {
            this.wrappedListener.mojoSucceeded(event);
        }
    }

    private List<File> getSurefireResultsFile(MavenProject project) {
        String[] xmls;
        ArrayList surefireReports = Lists.newArrayList();
        File surefireDirectory = new File(new File(project.getFile().getParentFile(), "target"), "surefire-reports");
        try {
            xmls = surefireDirectory.list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith("xml");
                }
            });
        }
        catch (Exception e) {
            this.logger.error("Error occurred: " + e.getMessage() + " while retrieving surefire descriptors at: " + surefireDirectory.getAbsolutePath(), (Throwable)e);
            return Lists.newArrayList();
        }
        if (xmls != null) {
            for (String xml : xmls) {
                surefireReports.add(new File(surefireDirectory, xml));
            }
        }
        return surefireReports;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean isTestsFailed(List<File> surefireReports) {
        XPathFactory factory = XPathFactory.newInstance();
        XPath path = factory.newXPath();
        for (File report : surefireReports) {
            FileInputStream stream;
            block7: {
                boolean bl;
                stream = null;
                try {
                    stream = new FileInputStream(report);
                    Object evaluate = path.evaluate("/testsuite/@failures", new InputSource(stream), XPathConstants.STRING);
                    if (evaluate == null || !StringUtils.isNotBlank((String)evaluate.toString()) || !StringUtils.isNumeric((String)evaluate.toString())) break block7;
                    int testsFailed = Integer.parseInt(evaluate.toString());
                    bl = testsFailed != 0;
                }
                catch (FileNotFoundException e) {
                    this.logger.error("File '" + report.getAbsolutePath() + "' does not exist.");
                    Closeables.closeQuietly((Closeable)stream);
                    continue;
                }
                catch (XPathExpressionException e2) {
                    this.logger.error("Expression /testsuite/@failures is invalid.");
                    {
                        catch (Throwable throwable) {
                            Closeables.closeQuietly(stream);
                            throw throwable;
                        }
                    }
                    Closeables.closeQuietly((Closeable)stream);
                    continue;
                }
                Closeables.closeQuietly((Closeable)stream);
                return bl;
            }
            Closeables.closeQuietly((Closeable)stream);
        }
        return false;
    }

    public void mojoFailed(ExecutionEvent event) {
        MavenProject project = event.getProject();
        if (project == null) {
            this.logger.warn("Skipping Artifactory Build-Info dependency extraction: Null project.");
            return;
        }
        this.extractModuleDependencies(project);
        if (this.wrappedListener != null) {
            this.wrappedListener.mojoFailed(event);
        }
    }

    private void initModule(MavenProject project) {
        if (project == null) {
            this.logger.warn("Skipping Artifactory Build-Info module initialization: Null project.");
            return;
        }
        ModuleBuilder module = new ModuleBuilder();
        module.id(BuildInfoExtractorUtils.getModuleIdString((String)project.getGroupId(), (String)project.getArtifactId(), (String)project.getVersion()));
        module.properties(project.getProperties());
        this.currentModule.set(module);
        this.currentModuleArtifacts.set(Sets.newHashSet());
        this.currentModuleDependencies.set(Sets.newHashSet());
    }

    private void extractArtifactsAndDependencies(MavenProject project) {
        if (project == null) {
            this.logger.warn("Skipping Artifactory Build-Info artifact and dependency extraction: Null project.");
            return;
        }
        Set<Artifact> artifacts = this.currentModuleArtifacts.get();
        if (artifacts == null) {
            this.logger.warn("Skipping Artifactory Build-Info project artifact extraction: Null current module artifacts.");
        } else {
            this.extractModuleArtifact(project, artifacts);
            this.extractModuleAttachedArtifacts(project, artifacts);
        }
        this.extractModuleDependencies(project);
    }

    private void finalizeModule(MavenProject project) {
        this.extractArtifactsAndDependencies(project);
        this.finalizeAndAddModule(project);
    }

    private void extractModuleArtifact(MavenProject project, Set<Artifact> artifacts) {
        Artifact artifact = project.getArtifact();
        if (artifact == null) {
            this.logger.warn("Skipping Artifactory Build-Info project artifact extraction: Null artifact.");
            return;
        }
        artifacts.add(artifact);
    }

    private void extractModuleAttachedArtifacts(MavenProject project, Set<Artifact> artifacts) {
        List attachedArtifacts = project.getAttachedArtifacts();
        if (attachedArtifacts != null) {
            for (Artifact attachedArtifact : attachedArtifacts) {
                artifacts.add(attachedArtifact);
            }
        }
    }

    private void extractModuleDependencies(MavenProject project) {
        Set<Artifact> moduleDependencies = this.currentModuleDependencies.get();
        if (moduleDependencies == null) {
            this.logger.warn("Skipping Artifactory Build-Info project dependency extraction: Null current module dependencies.");
            return;
        }
        Set projectDependencies = project.getArtifacts();
        if (projectDependencies != null) {
            for (Artifact projectDependency : projectDependencies) {
                moduleDependencies.add(projectDependency);
            }
        }
    }

    private void finalizeAndAddModule(MavenProject project) {
        this.addFilesToCurrentModule(project);
        this.currentModule.remove();
        this.currentModuleArtifacts.remove();
        this.currentModuleDependencies.remove();
    }

    private void addFilesToCurrentModule(MavenProject project) {
        ModuleBuilder module = this.currentModule.get();
        if (module == null) {
            this.logger.warn("Skipping Artifactory Build-Info module finalization: Null current module.");
            return;
        }
        this.addArtifactsToCurrentModule(project, module);
        this.addDependenciesToCurrentModule(module);
        this.buildInfoBuilder.addModule(module.build());
    }

    private void addArtifactsToCurrentModule(MavenProject project, ModuleBuilder module) {
        Set<Artifact> moduleArtifacts = this.currentModuleArtifacts.get();
        if (moduleArtifacts == null) {
            this.logger.warn("Skipping Artifactory Build-Info module artifact addition: Null current module artifact list.");
            return;
        }
        ArtifactoryClientConfiguration.PublisherHandler publisher = this.conf.publisher;
        IncludeExcludePatterns patterns = new IncludeExcludePatterns(publisher.getIncludePatterns(), publisher.getExcludePatterns());
        boolean excludeArtifactsFromBuild = publisher.isFilterExcludedArtifactsFromBuild();
        block0: for (Artifact moduleArtifact : moduleArtifacts) {
            String artifactId = moduleArtifact.getArtifactId();
            String artifactVersion = moduleArtifact.getVersion();
            String artifactClassifier = moduleArtifact.getClassifier();
            String artifactExtension = moduleArtifact.getArtifactHandler().getExtension();
            String type = BuildInfoExtractorUtils.getTypeString((String)moduleArtifact.getType(), (String)artifactClassifier, (String)artifactExtension);
            String artifactName = this.getArtifactName(artifactId, artifactVersion, artifactClassifier, artifactExtension);
            ArtifactBuilder artifactBuilder = new ArtifactBuilder(artifactName).type(type);
            File artifactFile = moduleArtifact.getFile();
            if (artifactFile == null && this.isPomProject(moduleArtifact) && moduleArtifact.equals(project.getArtifact())) {
                artifactFile = project.getFile();
            }
            org.jfrog.build.api.Artifact artifact = artifactBuilder.build();
            String groupId = moduleArtifact.getGroupId();
            String deploymentPath = this.getDeploymentPath(groupId, artifactId, artifactVersion, artifactClassifier, artifactExtension);
            if (excludeArtifactsFromBuild && PatternMatcher.pathConflicts((String)deploymentPath, (IncludeExcludePatterns)patterns)) {
                module.addExcludedArtifact(artifact);
            } else {
                module.addArtifact(artifact);
            }
            if (this.isPublishArtifacts(artifactFile)) {
                this.addDeployableArtifact(artifact, artifactFile, moduleArtifact.getGroupId(), artifactId, artifactVersion, artifactClassifier, artifactExtension);
            }
            if (this.isPomProject(moduleArtifact)) continue;
            for (ArtifactMetadata metadata : moduleArtifact.getMetadataList()) {
                if (!(metadata instanceof ProjectArtifactMetadata)) continue;
                File pomFile = ((ProjectArtifactMetadata)metadata).getFile();
                artifactBuilder.type("pom");
                String pomFileName = StringUtils.removeEnd((String)artifactName, (String)artifactExtension) + "pom";
                artifactBuilder.name(pomFileName);
                org.jfrog.build.api.Artifact pomArtifact = artifactBuilder.build();
                deploymentPath = this.getDeploymentPath(groupId, artifactId, artifactVersion, artifactClassifier, "pom");
                if (excludeArtifactsFromBuild && PatternMatcher.pathConflicts((String)deploymentPath, (IncludeExcludePatterns)patterns)) {
                    module.addExcludedArtifact(pomArtifact);
                } else {
                    module.addArtifact(pomArtifact);
                }
                if (!this.isPublishArtifacts(pomFile)) continue block0;
                this.addDeployableArtifact(pomArtifact, pomFile, moduleArtifact.getGroupId(), artifactId, artifactVersion, artifactClassifier, "pom");
                continue block0;
            }
        }
    }

    private boolean isPublishArtifacts(File fileToDeploy) {
        if (fileToDeploy == null || !fileToDeploy.isFile()) {
            return false;
        }
        if (!this.conf.publisher.isPublishArtifacts().booleanValue()) {
            return false;
        }
        return this.conf.publisher.isEvenUnstable() != false || !this.projectHasTestFailures;
    }

    private String getArtifactName(String artifactId, String version, String classifier, String fileExtension) {
        StringBuilder nameBuilder = new StringBuilder(artifactId).append("-").append(version);
        if (StringUtils.isNotBlank((String)classifier)) {
            nameBuilder.append("-").append(classifier);
        }
        return nameBuilder.append(".").append(fileExtension).toString();
    }

    private void addDeployableArtifact(org.jfrog.build.api.Artifact artifact, File artifactFile, String groupId, String artifactId, String version, String classifier, String fileExtension) {
        String deploymentPath = this.getDeploymentPath(groupId, artifactId, version, classifier, fileExtension);
        String targetRepository = this.getTargetRepository(deploymentPath);
        DeployDetails deployable = new DeployDetails.Builder().artifactPath(deploymentPath).file(artifactFile).targetRepository(targetRepository).addProperties((Map)this.conf.publisher.getMatrixParams()).build();
        String myArtifactId = BuildInfoExtractorUtils.getArtifactId((String)this.currentModule.get().build().getId(), (String)artifact.getName());
        this.deployableArtifactBuilderMap.put(myArtifactId, deployable);
    }

    public String getTargetRepository(String deployPath) {
        String snapshotsRepository = this.conf.publisher.getSnapshotRepoKey();
        if (snapshotsRepository != null && deployPath.contains("-SNAPSHOT")) {
            return snapshotsRepository;
        }
        return this.conf.publisher.getRepoKey();
    }

    private String getDeploymentPath(String groupId, String artifactId, String version, String classifier, String fileExtension) {
        return groupId.replace(".", "/") + "/" + artifactId + "/" + version + "/" + this.getArtifactName(artifactId, version, classifier, fileExtension);
    }

    private void addDependenciesToCurrentModule(ModuleBuilder module) {
        Set<Artifact> moduleDependencies = this.currentModuleDependencies.get();
        if (moduleDependencies == null) {
            this.logger.warn("Skipping Artifactory Build-Info module dependency addition: Null current module dependency list.");
            return;
        }
        for (Artifact dependency : moduleDependencies) {
            File depFile = dependency.getFile();
            DependencyBuilder dependencyBuilder = new DependencyBuilder().id(BuildInfoExtractorUtils.getModuleIdString((String)dependency.getGroupId(), (String)dependency.getArtifactId(), (String)dependency.getVersion())).type(BuildInfoExtractorUtils.getTypeString((String)dependency.getType(), (String)dependency.getClassifier(), (String)this.getExtension(depFile)));
            String scopes = dependency.getScope();
            if (StringUtils.isNotBlank((String)scopes)) {
                dependencyBuilder.scopes((List)Lists.newArrayList((Object[])new String[]{scopes}));
            }
            this.setDependencyChecksums(depFile, dependencyBuilder);
            module.addDependency(dependencyBuilder.build());
        }
    }

    private String getExtension(File depFile) {
        int lastDot;
        String extension = "";
        String fileName = depFile.getName();
        if (depFile != null && fileName != null && (lastDot = fileName.lastIndexOf(46)) > 0 && lastDot + 1 < fileName.length()) {
            extension = fileName.substring(lastDot + 1);
        }
        return extension;
    }

    private boolean isPomProject(Artifact moduleArtifact) {
        return "pom".equals(moduleArtifact.getType());
    }

    private void setDependencyChecksums(File dependencyFile, DependencyBuilder dependencyBuilder) {
        if (dependencyFile != null && dependencyFile.isFile()) {
            try {
                Map checksumsMap = FileChecksumCalculator.calculateChecksums((File)dependencyFile, (String[])new String[]{"md5", "sha1"});
                dependencyBuilder.md5((String)checksumsMap.get("md5"));
                dependencyBuilder.sha1((String)checksumsMap.get("sha1"));
            }
            catch (Exception e) {
                this.logger.error("Could not set checksum values on '" + dependencyBuilder.build().getId() + "': " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public Build extract(ExecutionEvent event) {
        MavenSession session = event.getSession();
        if (!session.getResult().hasExceptions()) {
            if (this.conf.isIncludeEnvVars().booleanValue()) {
                Properties envProperties = new Properties();
                envProperties.putAll((Map<?, ?>)this.conf.getAllProperties());
                envProperties = BuildInfoExtractorUtils.getEnvProperties((Properties)envProperties);
                for (Map.Entry<Object, Object> envProp : envProperties.entrySet()) {
                    this.buildInfoBuilder.addProperty(envProp.getKey(), envProp.getValue());
                }
            }
            Date finish = new Date();
            long time = finish.getTime() - session.getRequest().getStartTime().getTime();
            return this.buildInfoBuilder.durationMillis(time).build();
        }
        return null;
    }
}

