/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.maven;

import java.util.Map;
import java.util.Properties;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.execution.ExecutionListener;
import org.apache.maven.execution.MavenSession;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.jfrog.aether.AetherUtils;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.client.ArtifactoryClientConfiguration;
import org.jfrog.build.extractor.BuildInfoExtractorUtils;
import org.jfrog.build.extractor.maven.BuildInfoRecorder;
import org.jfrog.build.extractor.maven.Maven3BuildInfoLogger;

@Component(role=AbstractMavenLifecycleParticipant.class)
public class BuildInfoRecorderLifecycleParticipant
extends AbstractMavenLifecycleParticipant {
    @Requirement
    private Logger logger;
    @Requirement(role=BuildInfoRecorder.class, hint="default", optional=false)
    BuildInfoRecorder recorder;
    private ArtifactoryClientConfiguration internalConfiguration = null;

    public void afterSessionStart(MavenSession session) throws MavenExecutionException {
        super.afterSessionStart(session);
        ArtifactoryClientConfiguration config = this.getConfiguration(session);
        AetherUtils.addRepositoryListener((MavenSession)session, (String)"DefaultRepositorySystemSession", (String)config.resolver.getUrlWithMatrixParams(), (String)config.resolver.getUsername(), (String)config.resolver.getPassword(), (String)config.proxy.getHost(), (Integer)config.proxy.getPort(), (String)config.proxy.getUsername(), (String)config.proxy.getPassword(), (Logger)this.logger);
    }

    public void afterProjectsRead(MavenSession session) throws MavenExecutionException {
        ArtifactoryClientConfiguration configuration = this.getConfiguration(session);
        Boolean activateRecorderObject = configuration.isActivateRecorder();
        if (activateRecorderObject == null) {
            this.logger.debug("Disabling Artifactory Maven3 Build-Info Recorder: activation property (org.jfrog.build.extractor.maven.recorder.activate) not found.");
            return;
        }
        if (!Boolean.valueOf(((Object)activateRecorderObject).toString()).booleanValue()) {
            this.logger.debug("Disabling Artifactory Maven3 Build-Info Recorder: activation property (org.jfrog.build.extractor.maven.recorder.activate) value is either false or invalid.");
            return;
        }
        this.logger.debug("Activating Artifactory Maven3 Build-Info Recorder: activation property (org.jfrog.build.extractor.maven.recorder.activate) value is true.");
        configuration.info.setBuildStarted(System.currentTimeMillis());
        ExecutionListener existingExecutionListener = session.getRequest().getExecutionListener();
        this.recorder.setListenerToWrap(existingExecutionListener);
        this.recorder.setConfiguration(configuration);
        session.getRequest().setExecutionListener((ExecutionListener)this.recorder);
    }

    private ArtifactoryClientConfiguration getConfiguration(MavenSession session) {
        if (this.internalConfiguration != null) {
            return this.internalConfiguration;
        }
        Properties allMavenProps = new Properties();
        allMavenProps.putAll((Map<?, ?>)session.getSystemProperties());
        allMavenProps.putAll((Map<?, ?>)session.getUserProperties());
        Properties allProps = BuildInfoExtractorUtils.mergePropertiesWithSystemAndPropertyFile((Properties)allMavenProps);
        this.internalConfiguration = new ArtifactoryClientConfiguration((Log)new Maven3BuildInfoLogger(this.logger));
        this.internalConfiguration.fillFromProperties(allProps);
        return this.internalConfiguration;
    }
}

