/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.artemis.couchbase.document;

import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashSet;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import org.jnosql.artemis.couchbase.document.CouchbaseRepository;
import org.jnosql.artemis.couchbase.document.CouchbaseRepositoryAsync;
import org.jnosql.artemis.couchbase.document.CouchbaseRepositoryAsyncBean;
import org.jnosql.artemis.couchbase.document.CouchbaseRepositoryBean;

public class CouchbaseExtension
implements Extension {
    private static final Logger LOGGER = Logger.getLogger(CouchbaseExtension.class.getName());
    private final Collection<Class<?>> crudTypes = new HashSet();
    private final Collection<Class<?>> crudAsyncTypes = new HashSet();

    <T extends CouchbaseRepository> void onProcessAnnotatedType(@Observes ProcessAnnotatedType<T> repo) {
        Class javaClass = repo.getAnnotatedType().getJavaClass();
        if (CouchbaseRepository.class.equals((Object)javaClass)) {
            return;
        }
        if (Stream.of(javaClass.getInterfaces()).anyMatch(CouchbaseRepository.class::equals) && Modifier.isInterface(javaClass.getModifiers())) {
            this.crudTypes.add(javaClass);
        }
    }

    <T extends CouchbaseRepositoryAsync> void onProcessAnnotatedTypeAsync(@Observes ProcessAnnotatedType<T> repo) {
        Class javaClass = repo.getAnnotatedType().getJavaClass();
        if (CouchbaseRepositoryAsync.class.equals((Object)javaClass)) {
            return;
        }
        if (Stream.of(javaClass.getInterfaces()).anyMatch(CouchbaseRepositoryAsync.class::equals) && Modifier.isInterface(javaClass.getModifiers())) {
            this.crudAsyncTypes.add(javaClass);
        }
    }

    void onAfterBeanDiscovery(@Observes AfterBeanDiscovery afterBeanDiscovery, BeanManager beanManager) {
        LOGGER.info("Starting the onAfterBeanDiscovery with elements number: " + this.crudTypes.size());
        this.crudTypes.forEach(type -> afterBeanDiscovery.addBean((Bean)new CouchbaseRepositoryBean((Class)type, beanManager)));
        this.crudAsyncTypes.forEach(type -> afterBeanDiscovery.addBean((Bean)new CouchbaseRepositoryAsyncBean((Class)type, beanManager)));
        LOGGER.info("Finished the onAfterBeanDiscovery");
    }
}

