/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.artemis.couchbase.document;

import com.couchbase.client.java.document.json.JsonObject;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.util.Objects;
import java.util.function.Consumer;
import org.jnosql.artemis.Converters;
import org.jnosql.artemis.RepositoryAsync;
import org.jnosql.artemis.couchbase.document.CouchbaseTemplateAsync;
import org.jnosql.artemis.couchbase.document.JsonObjectUtil;
import org.jnosql.artemis.couchbase.document.N1QL;
import org.jnosql.artemis.document.DocumentTemplateAsync;
import org.jnosql.artemis.document.query.AbstractDocumentRepositoryAsync;
import org.jnosql.artemis.document.query.AbstractDocumentRepositoryAsyncProxy;
import org.jnosql.artemis.document.query.DocumentQueryDeleteParser;
import org.jnosql.artemis.document.query.DocumentQueryParser;
import org.jnosql.artemis.reflection.ClassRepresentation;
import org.jnosql.artemis.reflection.ClassRepresentations;
import org.jnosql.artemis.reflection.Reflections;

class CouchbaseRepositoryAsyncProxy<T>
extends AbstractDocumentRepositoryAsyncProxy<T> {
    private static final Consumer NOOP = t -> {};
    private final Class<T> typeClass;
    private final CouchbaseTemplateAsync template;
    private final DocumentCrudRepositoryAsync repository;
    private final ClassRepresentation classRepresentation;
    private final DocumentQueryParser queryParser;
    private final DocumentQueryDeleteParser deleteParser;
    private final Converters converters;

    CouchbaseRepositoryAsyncProxy(CouchbaseTemplateAsync template, ClassRepresentations classRepresentations, Class<?> repositoryType, Reflections reflections, Converters converters) {
        this.template = template;
        this.typeClass = (Class)Class.class.cast(((ParameterizedType)ParameterizedType.class.cast(repositoryType.getGenericInterfaces()[0])).getActualTypeArguments()[0]);
        this.classRepresentation = classRepresentations.get(this.typeClass);
        this.queryParser = new DocumentQueryParser();
        this.repository = new DocumentCrudRepositoryAsync(template, this.classRepresentation, reflections);
        this.deleteParser = new DocumentQueryDeleteParser();
        this.converters = converters;
    }

    protected RepositoryAsync getRepository() {
        return this.repository;
    }

    protected DocumentQueryParser getQueryParser() {
        return this.queryParser;
    }

    protected DocumentTemplateAsync getTemplate() {
        return this.template;
    }

    protected DocumentQueryDeleteParser getDeleteParser() {
        return this.deleteParser;
    }

    protected ClassRepresentation getClassRepresentation() {
        return this.classRepresentation;
    }

    protected Converters getConverters() {
        return this.converters;
    }

    public Object invoke(Object instance, Method method, Object[] args) throws Throwable {
        N1QL n1QL = method.getAnnotation(N1QL.class);
        if (Objects.nonNull(n1QL)) {
            JsonObject params;
            Consumer callBack = NOOP;
            if (Consumer.class.isInstance(args[args.length - 1])) {
                callBack = (Consumer)Consumer.class.cast(args[args.length - 1]);
            }
            if ((params = JsonObjectUtil.getParams(args, method)).isEmpty()) {
                this.template.n1qlQuery(n1QL.value(), callBack);
                return Void.class;
            }
            this.template.n1qlQuery(n1QL.value(), params, callBack);
            return Void.class;
        }
        return super.invoke(instance, method, args);
    }

    class DocumentCrudRepositoryAsync
    extends AbstractDocumentRepositoryAsync
    implements RepositoryAsync {
        private final DocumentTemplateAsync template;
        private final ClassRepresentation classRepresentation;
        private final Reflections reflections;

        DocumentCrudRepositoryAsync(DocumentTemplateAsync template, ClassRepresentation classRepresentation, Reflections reflections) {
            this.template = template;
            this.classRepresentation = classRepresentation;
            this.reflections = reflections;
        }

        protected DocumentTemplateAsync getTemplate() {
            return this.template;
        }

        protected Reflections getReflections() {
            return this.reflections;
        }

        protected ClassRepresentation getClassRepresentation() {
            return this.classRepresentation;
        }
    }
}

