/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.artemis.couchbase.document;

import java.lang.annotation.Annotation;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.PassivationCapable;
import javax.enterprise.util.AnnotationLiteral;
import org.jnosql.artemis.Converters;
import org.jnosql.artemis.couchbase.document.CouchbaseRepository;
import org.jnosql.artemis.couchbase.document.CouchbaseTemplate;
import org.jnosql.artemis.couchbase.document.CouchbaseocumentRepositoryProxy;
import org.jnosql.artemis.reflection.ClassRepresentations;
import org.jnosql.artemis.reflection.Reflections;

class CouchbaseRepositoryBean
implements Bean<CouchbaseRepository>,
PassivationCapable {
    private final Class type;
    private final BeanManager beanManager;
    private final Set<Type> types;
    private final Set<Annotation> qualifiers = Collections.singleton(new AnnotationLiteral<Default>(){});

    CouchbaseRepositoryBean(Class type, BeanManager beanManager) {
        this.type = type;
        this.beanManager = beanManager;
        this.types = Collections.singleton(type);
    }

    public Class<?> getBeanClass() {
        return this.type;
    }

    public Set<InjectionPoint> getInjectionPoints() {
        return Collections.emptySet();
    }

    public boolean isNullable() {
        return false;
    }

    public CouchbaseRepository create(CreationalContext<CouchbaseRepository> creationalContext) {
        ClassRepresentations classRepresentations = this.getInstance(ClassRepresentations.class);
        CouchbaseTemplate repository = this.getInstance(CouchbaseTemplate.class);
        Reflections reflections = this.getInstance(Reflections.class);
        Converters converters = this.getInstance(Converters.class);
        CouchbaseocumentRepositoryProxy handler = new CouchbaseocumentRepositoryProxy(repository, classRepresentations, this.type, reflections, converters);
        return (CouchbaseRepository)Proxy.newProxyInstance(this.type.getClassLoader(), new Class[]{this.type}, handler);
    }

    private <T> T getInstance(Class<T> clazz) {
        Bean bean = (Bean)this.beanManager.getBeans(clazz, new Annotation[0]).iterator().next();
        CreationalContext ctx = this.beanManager.createCreationalContext((Contextual)bean);
        return (T)this.beanManager.getReference(bean, clazz, ctx);
    }

    public void destroy(CouchbaseRepository instance, CreationalContext<CouchbaseRepository> creationalContext) {
    }

    public Set<Type> getTypes() {
        return this.types;
    }

    public Set<Annotation> getQualifiers() {
        return this.qualifiers;
    }

    public Class<? extends Annotation> getScope() {
        return ApplicationScoped.class;
    }

    public String getName() {
        return null;
    }

    public Set<Class<? extends Annotation>> getStereotypes() {
        return Collections.emptySet();
    }

    public boolean isAlternative() {
        return false;
    }

    public String getId() {
        return this.type.getName() + "@couchbase";
    }
}

