/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.artemis.couchbase.document;

import com.couchbase.client.java.document.json.JsonObject;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.util.List;
import java.util.Objects;
import org.jnosql.artemis.Converters;
import org.jnosql.artemis.Repository;
import org.jnosql.artemis.couchbase.document.CouchbaseTemplate;
import org.jnosql.artemis.couchbase.document.JsonObjectUtil;
import org.jnosql.artemis.couchbase.document.N1QL;
import org.jnosql.artemis.couchbase.document.ReturnTypeConverterUtil;
import org.jnosql.artemis.document.DocumentTemplate;
import org.jnosql.artemis.document.query.AbstractDocumentRepository;
import org.jnosql.artemis.document.query.AbstractDocumentRepositoryProxy;
import org.jnosql.artemis.document.query.DocumentQueryDeleteParser;
import org.jnosql.artemis.document.query.DocumentQueryParser;
import org.jnosql.artemis.reflection.ClassRepresentation;
import org.jnosql.artemis.reflection.ClassRepresentations;
import org.jnosql.artemis.reflection.Reflections;

class CouchbaseocumentRepositoryProxy<T>
extends AbstractDocumentRepositoryProxy<T> {
    private final Class<T> typeClass;
    private final CouchbaseTemplate template;
    private final DocumentCrudRepository repository;
    private final ClassRepresentation classRepresentation;
    private final DocumentQueryParser queryParser;
    private final DocumentQueryDeleteParser deleteParser;
    private final Converters converters;

    CouchbaseocumentRepositoryProxy(CouchbaseTemplate template, ClassRepresentations classRepresentations, Class<?> repositoryType, Reflections reflections, Converters converters) {
        this.template = template;
        this.typeClass = (Class)Class.class.cast(((ParameterizedType)ParameterizedType.class.cast(repositoryType.getGenericInterfaces()[0])).getActualTypeArguments()[0]);
        this.classRepresentation = classRepresentations.get(this.typeClass);
        this.repository = new DocumentCrudRepository(template, this.classRepresentation, reflections);
        this.queryParser = new DocumentQueryParser();
        this.deleteParser = new DocumentQueryDeleteParser();
        this.converters = converters;
    }

    protected Repository getRepository() {
        return this.repository;
    }

    protected DocumentQueryParser getQueryParser() {
        return this.queryParser;
    }

    protected DocumentTemplate getTemplate() {
        return this.template;
    }

    protected DocumentQueryDeleteParser getDeleteParser() {
        return this.deleteParser;
    }

    protected ClassRepresentation getClassRepresentation() {
        return this.classRepresentation;
    }

    protected Converters getConverters() {
        return this.converters;
    }

    public Object invoke(Object o, Method method, Object[] args) throws Throwable {
        N1QL n1QL = method.getAnnotation(N1QL.class);
        if (Objects.nonNull(n1QL)) {
            JsonObject params = JsonObjectUtil.getParams(args, method);
            List result = params.isEmpty() ? this.template.n1qlQuery(n1QL.value()) : this.template.n1qlQuery(n1QL.value(), params);
            return ReturnTypeConverterUtil.returnObject(result, this.typeClass, method);
        }
        return super.invoke(o, method, args);
    }

    class DocumentCrudRepository
    extends AbstractDocumentRepository
    implements Repository {
        private final DocumentTemplate template;
        private final ClassRepresentation classRepresentation;
        private final Reflections reflections;

        DocumentCrudRepository(DocumentTemplate template, ClassRepresentation classRepresentation, Reflections reflections) {
            this.template = template;
            this.classRepresentation = classRepresentation;
            this.reflections = reflections;
        }

        protected DocumentTemplate getTemplate() {
            return this.template;
        }

        protected ClassRepresentation getClassRepresentation() {
            return this.classRepresentation;
        }

        protected Reflections getReflections() {
            return this.reflections;
        }
    }
}

