/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.artemis.couchbase.document;

import com.couchbase.client.java.document.json.JsonObject;
import com.couchbase.client.java.query.Statement;
import com.couchbase.client.java.search.SearchQuery;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Typed;
import javax.inject.Inject;
import org.jnosql.artemis.Converters;
import org.jnosql.artemis.couchbase.document.CouchbaseTemplate;
import org.jnosql.artemis.document.AbstractDocumentTemplate;
import org.jnosql.artemis.document.DocumentEntityConverter;
import org.jnosql.artemis.document.DocumentEventPersistManager;
import org.jnosql.artemis.document.DocumentWorkflow;
import org.jnosql.artemis.reflection.ClassRepresentations;
import org.jnosql.diana.api.document.DocumentCollectionManager;
import org.jnosql.diana.couchbase.document.CouchbaseDocumentCollectionManager;

@Typed(value={CouchbaseTemplate.class})
class DefaultCouchbaseTemplate
extends AbstractDocumentTemplate
implements CouchbaseTemplate {
    private Instance<CouchbaseDocumentCollectionManager> manager;
    private DocumentEntityConverter converter;
    private DocumentWorkflow flow;
    private DocumentEventPersistManager persistManager;
    private ClassRepresentations classRepresentations;
    private Converters converters;

    @Inject
    DefaultCouchbaseTemplate(Instance<CouchbaseDocumentCollectionManager> manager, DocumentEntityConverter converter, DocumentWorkflow flow, DocumentEventPersistManager persistManager, ClassRepresentations classRepresentations, Converters converters) {
        this.manager = manager;
        this.converter = converter;
        this.flow = flow;
        this.persistManager = persistManager;
        this.classRepresentations = classRepresentations;
        this.converters = converters;
    }

    DefaultCouchbaseTemplate() {
    }

    protected DocumentEntityConverter getConverter() {
        return this.converter;
    }

    protected DocumentCollectionManager getManager() {
        return (DocumentCollectionManager)this.manager.get();
    }

    protected DocumentWorkflow getWorkflow() {
        return this.flow;
    }

    protected DocumentEventPersistManager getPersistManager() {
        return this.persistManager;
    }

    protected ClassRepresentations getClassRepresentations() {
        return this.classRepresentations;
    }

    protected Converters getConverters() {
        return this.converters;
    }

    @Override
    public <T> List<T> n1qlQuery(String n1qlQuery, JsonObject params) {
        Objects.requireNonNull(n1qlQuery, "n1qlQuery is required");
        Objects.requireNonNull(params, "params is required");
        return ((CouchbaseDocumentCollectionManager)this.manager.get()).n1qlQuery(n1qlQuery, params).stream().map(arg_0 -> ((DocumentEntityConverter)this.converter).toEntity(arg_0)).map(d -> d).collect(Collectors.toList());
    }

    @Override
    public <T> List<T> n1qlQuery(Statement n1qlQuery, JsonObject params) {
        Objects.requireNonNull(n1qlQuery, "n1qlQuery is required");
        Objects.requireNonNull(params, "params is required");
        return ((CouchbaseDocumentCollectionManager)this.manager.get()).n1qlQuery(n1qlQuery, params).stream().map(arg_0 -> ((DocumentEntityConverter)this.converter).toEntity(arg_0)).map(d -> d).collect(Collectors.toList());
    }

    @Override
    public <T> List<T> n1qlQuery(String n1qlQuery) {
        Objects.requireNonNull(n1qlQuery, "n1qlQuery is required");
        return ((CouchbaseDocumentCollectionManager)this.manager.get()).n1qlQuery(n1qlQuery).stream().map(arg_0 -> ((DocumentEntityConverter)this.converter).toEntity(arg_0)).map(d -> d).collect(Collectors.toList());
    }

    @Override
    public <T> List<T> search(SearchQuery query) {
        Objects.requireNonNull(query, "query is required");
        return ((CouchbaseDocumentCollectionManager)this.manager.get()).search(query).stream().map(arg_0 -> ((DocumentEntityConverter)this.converter).toEntity(arg_0)).map(d -> d).collect(Collectors.toList());
    }

    @Override
    public <T> List<T> n1qlQuery(Statement n1qlQuery) {
        Objects.requireNonNull(n1qlQuery, "n1qlQuery is required");
        return ((CouchbaseDocumentCollectionManager)this.manager.get()).n1qlQuery(n1qlQuery).stream().map(arg_0 -> ((DocumentEntityConverter)this.converter).toEntity(arg_0)).map(d -> d).collect(Collectors.toList());
    }
}

