/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.artemis.couchbase.document;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jnosql.artemis.document.DocumentTemplate;
import org.jnosql.diana.api.document.DocumentQuery;

final class ReturnTypeConverterUtil {
    private ReturnTypeConverterUtil() {
    }

    static Object returnObject(DocumentQuery query, DocumentTemplate repository, Class typeClass, Method method) {
        Class<?> returnType = method.getReturnType();
        if (typeClass.equals(returnType)) {
            Optional optional = repository.singleResult(query);
            return optional.orElse(null);
        }
        if (Optional.class.equals(returnType)) {
            return repository.singleResult(query);
        }
        if (List.class.equals(returnType) || Iterable.class.equals(returnType) || Collection.class.equals(returnType)) {
            return repository.select(query);
        }
        if (Set.class.equals(returnType)) {
            return repository.select(query).stream().collect(Collectors.toSet());
        }
        if (Queue.class.equals(returnType)) {
            return repository.select(query).stream().collect(Collectors.toCollection(PriorityQueue::new));
        }
        if (Stream.class.equals(returnType)) {
            return repository.select(query).stream();
        }
        return repository.select(query);
    }

    static Object returnObject(List result, Class typeClass, Method method) {
        Class<?> returnType = method.getReturnType();
        if (typeClass.equals(returnType)) {
            if (!result.isEmpty()) {
                return result.get(0);
            }
            return null;
        }
        if (Optional.class.equals(returnType)) {
            return result.stream().findFirst();
        }
        if (List.class.equals(returnType) || Iterable.class.equals(returnType) || Collection.class.equals(returnType)) {
            return result;
        }
        if (Set.class.equals(returnType)) {
            return result.stream().collect(Collectors.toSet());
        }
        if (Queue.class.equals(returnType)) {
            return result.stream().collect(Collectors.toCollection(PriorityQueue::new));
        }
        if (Stream.class.equals(returnType)) {
            return result.stream();
        }
        return result;
    }
}

