/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.local.process;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jodconverter.local.process.AbstractProcessManager;

public class UnixProcessManager
extends AbstractProcessManager {
    private static final Pattern PS_OUTPUT_LINE = Pattern.compile("^\\s*(?<Pid>\\d+)\\s+(?<CommandLine>.*)$");
    private String[] runAsArgs;

    public static @NonNull UnixProcessManager getDefault() {
        return DefaultHolder.INSTANCE;
    }

    @Override
    protected @NonNull List<@NonNull String> execute(String ... cmdarray) throws IOException {
        if (this.runAsArgs == null) {
            return super.execute(cmdarray);
        }
        String[] newarray = new String[this.runAsArgs.length + cmdarray.length];
        System.arraycopy(this.runAsArgs, 0, newarray, 0, this.runAsArgs.length);
        System.arraycopy(cmdarray, 0, newarray, this.runAsArgs.length, cmdarray.length);
        return super.execute(newarray);
    }

    @Override
    protected @NonNull String[] getRunningProcessesCommand(@NonNull String process) {
        return new String[]{"/bin/sh", "-c", "/bin/ps -e -o pid,args | /bin/grep " + process + " | /bin/grep -v grep"};
    }

    @Override
    protected @NonNull Pattern getRunningProcessLinePattern() {
        return PS_OUTPUT_LINE;
    }

    @Override
    public void kill(@Nullable Process process, long pid) throws IOException {
        if (pid > -1L) {
            this.execute("/bin/kill", "-KILL", String.valueOf(pid));
        } else {
            super.kill(process, pid);
        }
    }

    public void setRunAsArgs(String ... runAsArgs) {
        this.runAsArgs = Arrays.copyOf(runAsArgs, runAsArgs.length);
    }

    private static class DefaultHolder {
        static final UnixProcessManager INSTANCE = new UnixProcessManager();

        private DefaultHolder() {
        }
    }
}

