/*
 * Decompiled with CFR 0.152.
 */
package org.joinfaces.autoconfigure.aot;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.joinfaces.ClasspathScanUtil;
import org.joinfaces.servlet.ServletContainerInitializerRegistrationBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aot.generate.GenerationContext;
import org.springframework.beans.factory.aot.BeanFactoryInitializationAotContribution;
import org.springframework.beans.factory.aot.BeanFactoryInitializationAotProcessor;
import org.springframework.beans.factory.aot.BeanFactoryInitializationCode;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.util.CollectionUtils;

public class ServletContainerInitializerRegistrationBeanAotProcessor
implements BeanFactoryInitializationAotProcessor {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ServletContainerInitializerRegistrationBeanAotProcessor.class);

    public BeanFactoryInitializationAotContribution processAheadOfTime(ConfigurableListableBeanFactory beanFactory) {
        Map servletContainerInitializerRegistrationBeans = beanFactory.getBeansOfType(ServletContainerInitializerRegistrationBean.class);
        if (CollectionUtils.isEmpty((Map)servletContainerInitializerRegistrationBeans)) {
            return null;
        }
        return new Contrib(servletContainerInitializerRegistrationBeans.values());
    }

    public static class Contrib
    implements BeanFactoryInitializationAotContribution {
        private final Collection<ServletContainerInitializerRegistrationBean> beans;

        public void applyTo(GenerationContext generationContext, BeanFactoryInitializationCode beanFactoryInitializationCode) {
            for (ServletContainerInitializerRegistrationBean bean : this.beans) {
                Set classes = bean.performClasspathScan();
                if (CollectionUtils.isEmpty((Collection)classes)) continue;
                ClasspathScanUtil.writeClassSet((GenerationContext)generationContext, (String)bean.getPreparedScanResultPath(), (Collection)classes);
            }
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Contrib(Collection<ServletContainerInitializerRegistrationBean> beans) {
            this.beans = beans;
        }
    }
}

