/*
 * Decompiled with CFR 0.152.
 */
package org.joinfaces.integration;

import javax.faces.bean.ApplicationScoped;
import javax.faces.bean.NoneScoped;
import javax.faces.bean.RequestScoped;
import javax.faces.bean.SessionScoped;
import javax.faces.view.ViewScoped;
import org.joinfaces.integration.CustomScopeAnnotationConfigurer;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
@ConditionalOnClass(value={RequestScoped.class})
public class JsfScopeAnnotationsAutoConfiguration {
    @Bean
    @ConditionalOnProperty(value={"jsf.scope-configurer.jsf.enabled"}, havingValue="true", matchIfMissing=true)
    public static BeanFactoryPostProcessor jsfScopeAnnotationsConfigurer(Environment environment) {
        CustomScopeAnnotationConfigurer scopeAnnotationConfigurer = new CustomScopeAnnotationConfigurer();
        scopeAnnotationConfigurer.setOrder((Integer)environment.getProperty("jsf.scope-configurer.jsf.order", Integer.class, (Object)Integer.MAX_VALUE));
        scopeAnnotationConfigurer.addMapping(NoneScoped.class, "prototype");
        scopeAnnotationConfigurer.addMapping(RequestScoped.class, "request");
        scopeAnnotationConfigurer.addMapping(javax.faces.bean.ViewScoped.class, "view");
        scopeAnnotationConfigurer.addMapping(ViewScoped.class, "view");
        scopeAnnotationConfigurer.addMapping(SessionScoped.class, "session");
        scopeAnnotationConfigurer.addMapping(ApplicationScoped.class, "application");
        return scopeAnnotationConfigurer;
    }
}

