/*
 * Decompiled with CFR 0.152.
 */
package org.joinfaces.jetty;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import lombok.Generated;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceCollection;
import org.eclipse.jetty.webapp.WebAppContext;
import org.joinfaces.jetty.JettyProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.embedded.jetty.JettyServerCustomizer;
import org.springframework.core.io.ClassPathResource;

public class JsfJettyServerCustomizer
implements JettyServerCustomizer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JsfJettyServerCustomizer.class);
    private final JettyProperties jettyProperties;

    public JsfJettyServerCustomizer(JettyProperties jettyProperties) {
        this.jettyProperties = jettyProperties;
    }

    public void customize(Server server) {
        Handler[] childHandlersByClass = server.getChildHandlersByClass(WebAppContext.class);
        final WebAppContext webAppContext = (WebAppContext)childHandlersByClass[0];
        try {
            ClassPathResource classPathResource = new ClassPathResource(this.jettyProperties.getClassPathResource());
            webAppContext.setBaseResource((Resource)new ResourceCollection(classPathResource.getURI().toString()));
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    webAppContext.setClassLoader((ClassLoader)new URLClassLoader(new URL[0], this.getClass().getClassLoader()));
                    return null;
                }
            });
            log.info("Setting Jetty classLoader to {} directory", (Object)this.jettyProperties.getClassPathResource());
        }
        catch (IOException exception) {
            log.error("Unable to configure Jetty classLoader to {} directory {}", (Object)this.jettyProperties.getClassPathResource(), (Object)exception.getMessage());
            throw new RuntimeException(exception);
        }
    }
}

