/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.docker.maven;

import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.shared.filtering.MavenFileFilter;
import org.apache.maven.shared.filtering.MavenReaderFilter;
import org.jolokia.docker.maven.AbstractDockerMojo;
import org.jolokia.docker.maven.access.DockerAccess;
import org.jolokia.docker.maven.access.DockerAccessException;
import org.jolokia.docker.maven.config.AssemblyConfiguration;
import org.jolokia.docker.maven.config.BuildImageConfiguration;
import org.jolokia.docker.maven.config.ImageConfiguration;
import org.jolokia.docker.maven.util.ImageName;
import org.jolokia.docker.maven.util.MojoParameters;

public abstract class AbstractBuildSupportMojo
extends AbstractDockerMojo {
    private MavenArchiveConfiguration archive;
    protected MavenSession session;
    private MavenFileFilter mavenFileFilter;
    private MavenReaderFilter mavenFilterReader;
    private String sourceDirectory;
    private String outputDirectory;

    protected MojoParameters createMojoParameters() {
        return new MojoParameters(this.session, this.project, this.archive, this.mavenFileFilter, this.mavenFilterReader, this.sourceDirectory, this.outputDirectory);
    }

    protected void buildImage(DockerAccess dockerAccess, ImageConfiguration imageConfig) throws DockerAccessException, MojoExecutionException {
        this.autoPullBaseImage(dockerAccess, imageConfig);
        MojoParameters params = this.createMojoParameters();
        this.serviceHub.getBuildService().buildImage(imageConfig, params);
    }

    private void autoPullBaseImage(DockerAccess dockerAccess, ImageConfiguration imageConfig) throws DockerAccessException, MojoExecutionException {
        AssemblyConfiguration assemblyConfig;
        BuildImageConfiguration buildConfig = imageConfig.getBuildConfiguration();
        String fromImage = buildConfig.getFrom();
        if (fromImage == null && ((assemblyConfig = buildConfig.getAssemblyConfiguration()) == null || assemblyConfig.getDockerFileDir() == null)) {
            fromImage = "busybox:latest";
        }
        if (fromImage != null) {
            this.checkImageWithAutoPull(dockerAccess, fromImage, new ImageName(fromImage).getRegistry(), true);
        }
    }
}

