/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.docker.maven;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.jolokia.docker.maven.access.AuthConfig;
import org.jolokia.docker.maven.access.DockerAccess;
import org.jolokia.docker.maven.access.DockerAccessException;
import org.jolokia.docker.maven.access.hc.DockerAccessWithHcClient;
import org.jolokia.docker.maven.config.ImageConfiguration;
import org.jolokia.docker.maven.config.handler.ImageConfigResolver;
import org.jolokia.docker.maven.log.LogDispatcher;
import org.jolokia.docker.maven.log.LogOutputSpecFactory;
import org.jolokia.docker.maven.service.QueryService;
import org.jolokia.docker.maven.service.ServiceHub;
import org.jolokia.docker.maven.util.AnsiLogger;
import org.jolokia.docker.maven.util.AuthConfigFactory;
import org.jolokia.docker.maven.util.EnvUtil;
import org.jolokia.docker.maven.util.ImageName;
import org.jolokia.docker.maven.util.Logger;

public abstract class AbstractDockerMojo
extends AbstractMojo
implements Contextualizable {
    public static final String CONTEXT_KEY_START_CALLED = "CONTEXT_KEY_DOCKER_START_CALLED";
    public static final Object CONTEXT_KEY_LOG_DISPATCHER = "CONTEXT_KEY_DOCKER_LOG_DISPATCHER";
    public static final String DOCKER_HTTPS_PORT = "2376";
    public static final String API_VERSION = "v1.17";
    protected MavenProject project;
    protected Settings settings;
    protected ImageConfigResolver imageConfigResolver;
    protected ServiceHub serviceHub;
    protected String autoPull;
    protected boolean keepContainer;
    protected boolean removeVolumes;
    private String apiVersion;
    private String dockerHost;
    private String certPath;
    protected boolean useColor;
    protected boolean verbose;
    private String logDate;
    private boolean logStdout;
    private boolean skip;
    private String image;
    private String registry;
    private int maxConnections;
    protected String portPropertyFile;
    Map authConfig;
    private List<ImageConfiguration> images;
    private AuthConfigFactory authConfigFactory;
    protected Logger log;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.skip) {
            this.log = new AnsiLogger(this.getLog(), this.useColor, this.verbose);
            this.validateConfiguration(this.log);
            String dockerUrl = EnvUtil.extractUrl(this.dockerHost);
            DockerAccess access = this.createDockerAccess(dockerUrl);
            this.setDockerHostAddressProperty(dockerUrl);
            this.serviceHub.init(access, this.log, new LogOutputSpecFactory(this.useColor, this.logStdout, this.logDate));
            try {
                this.executeInternal(access);
            }
            catch (DockerAccessException exp) {
                throw new MojoExecutionException(this.log.errorMessage(exp.getMessage()), (Exception)exp);
            }
            finally {
                access.shutdown();
            }
        }
    }

    private void validateConfiguration(Logger log) {
        if (this.images != null) {
            for (ImageConfiguration imageConfiguration : this.images) {
                imageConfiguration.validate(log);
            }
        }
    }

    protected abstract void executeInternal(DockerAccess var1) throws DockerAccessException, MojoExecutionException;

    protected List<ImageConfiguration> getImages() {
        List<ImageConfiguration> resolvedImages = this.resolveImages();
        ArrayList<ImageConfiguration> ret = new ArrayList<ImageConfiguration>();
        for (ImageConfiguration imageConfig : resolvedImages) {
            if (!this.matchesConfiguredImages(this.image, imageConfig)) continue;
            ret.add(imageConfig);
        }
        return ret;
    }

    private List<ImageConfiguration> resolveImages() {
        ArrayList<ImageConfiguration> ret = new ArrayList<ImageConfiguration>();
        if (this.images != null) {
            for (ImageConfiguration image : this.images) {
                ret.addAll(this.imageConfigResolver.resolve(image, this.project.getProperties()));
            }
            this.verifyImageNames(ret);
        }
        return ret;
    }

    private void verifyImageNames(List<ImageConfiguration> ret) {
        for (ImageConfiguration config : ret) {
            if (config.getName() != null) continue;
            throw new IllegalArgumentException("Configuration error: <image> must have a non-null <name>");
        }
    }

    protected boolean matchesConfiguredImages(String imageList, ImageConfiguration imageConfig) {
        if (imageList == null) {
            return true;
        }
        HashSet<String> imagesAllowed = new HashSet<String>(Arrays.asList(imageList.split("\\s*,\\s*")));
        return imagesAllowed.contains(imageConfig.getName()) || imagesAllowed.contains(imageConfig.getAlias());
    }

    private DockerAccess createDockerAccess(String baseUrl) throws MojoExecutionException {
        try {
            String version = this.apiVersion == null ? API_VERSION : this.apiVersion;
            DockerAccessWithHcClient client = new DockerAccessWithHcClient(version, baseUrl, EnvUtil.getCertPath(this.certPath), this.maxConnections, this.log);
            client.start();
            return client;
        }
        catch (IOException e) {
            throw new MojoExecutionException("Cannot create docker access object ", (Exception)e);
        }
    }

    private void setDockerHostAddressProperty(String dockerUrl) throws MojoFailureException {
        Properties props = this.project.getProperties();
        if (props.getProperty("docker.host.address") == null) {
            String host;
            try {
                URI uri = new URI(dockerUrl);
                host = uri.getHost() == null && uri.getScheme().equals("unix") ? "localhost" : uri.getHost();
            }
            catch (URISyntaxException e) {
                throw new MojoFailureException("Cannot parse " + dockerUrl + " as URI: " + e.getMessage(), (Throwable)e);
            }
            props.setProperty("docker.host.address", host == null ? "" : host);
        }
    }

    public void contextualize(Context context) throws ContextException {
        this.authConfigFactory = new AuthConfigFactory((PlexusContainer)context.get((Object)"plexus"));
    }

    protected AuthConfig prepareAuthConfig(String image, String configuredRegistry) throws MojoExecutionException {
        ImageName name = new ImageName(image);
        String user = name.getUser();
        String registry = name.getRegistry() != null ? name.getRegistry() : configuredRegistry;
        return this.authConfigFactory.createAuthConfig(this.authConfig, this.settings, user, registry);
    }

    protected LogDispatcher getLogDispatcher(DockerAccess docker) {
        LogDispatcher dispatcher = (LogDispatcher)this.getPluginContext().get(CONTEXT_KEY_LOG_DISPATCHER);
        if (dispatcher == null) {
            dispatcher = new LogDispatcher(docker);
            this.getPluginContext().put(CONTEXT_KEY_LOG_DISPATCHER, dispatcher);
        }
        return dispatcher;
    }

    protected String getConfiguredRegistry(ImageConfiguration imageConfig) {
        return EnvUtil.findRegistry(imageConfig.getRegistry(), this.registry);
    }

    protected void checkImageWithAutoPull(DockerAccess docker, String image, String registry, boolean autoPullAlwaysAllowed) throws DockerAccessException, MojoExecutionException {
        QueryService queryService = this.serviceHub.getQueryService();
        if (!queryService.imageRequiresAutoPull(this.autoPull, image, autoPullAlwaysAllowed)) {
            return;
        }
        docker.pullImage(this.withLatestIfNoTag(image), this.prepareAuthConfig(image, registry), registry);
        ImageName imageName = new ImageName(image);
        if (registry != null && !imageName.hasRegistry()) {
            docker.tag(imageName.getFullName(registry), image, false);
        }
    }

    private String withLatestIfNoTag(String name) {
        ImageName imageName = new ImageName(name);
        return imageName.getTag() == null ? imageName.getNameWithoutTag() + ":latest" : name;
    }
}

