/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.docker.maven;

import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.jolokia.docker.maven.AbstractBuildSupportMojo;
import org.jolokia.docker.maven.access.DockerAccess;
import org.jolokia.docker.maven.access.DockerAccessException;
import org.jolokia.docker.maven.config.BuildImageConfiguration;
import org.jolokia.docker.maven.config.ImageConfiguration;
import org.jolokia.docker.maven.util.EnvUtil;
import org.jolokia.docker.maven.util.ImageName;

public class BuildMojo
extends AbstractBuildSupportMojo {
    private boolean skipTags;

    @Override
    protected void executeInternal(DockerAccess dockerAccess) throws DockerAccessException, MojoExecutionException {
        for (ImageConfiguration imageConfig : this.getImages()) {
            BuildImageConfiguration buildConfig = imageConfig.getBuildConfiguration();
            if (buildConfig == null) continue;
            if (buildConfig.skip()) {
                this.log.info(imageConfig.getDescription() + ": Skipped building");
                continue;
            }
            this.buildAndTag(dockerAccess, imageConfig);
        }
    }

    private void buildAndTag(DockerAccess dockerAccess, ImageConfiguration imageConfig) throws MojoExecutionException, DockerAccessException {
        this.buildImage(dockerAccess, imageConfig);
        if (!this.skipTags) {
            this.tagImage(imageConfig.getName(), imageConfig, dockerAccess);
        }
    }

    private void tagImage(String imageName, ImageConfiguration imageConfig, DockerAccess dockerAccess) throws DockerAccessException, MojoExecutionException {
        List<String> tags = imageConfig.getBuildConfiguration().getTags();
        if (tags.size() > 0) {
            this.log.info(imageConfig.getDescription() + ": Tag with " + EnvUtil.stringJoin(tags, ","));
            for (String tag : tags) {
                if (tag == null) continue;
                dockerAccess.tag(imageName, new ImageName(imageName, tag).getFullName(), true);
            }
            this.log.debug("Tagging image successful!");
        }
    }
}

