/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.docker.maven;

import java.io.FileNotFoundException;
import org.apache.maven.plugin.MojoExecutionException;
import org.jolokia.docker.maven.AbstractDockerMojo;
import org.jolokia.docker.maven.access.DockerAccess;
import org.jolokia.docker.maven.access.DockerAccessException;
import org.jolokia.docker.maven.config.ImageConfiguration;
import org.jolokia.docker.maven.log.LogDispatcher;
import org.jolokia.docker.maven.log.LogOutputSpec;
import org.jolokia.docker.maven.model.Container;
import org.jolokia.docker.maven.service.QueryService;

public class LogsMojo
extends AbstractDockerMojo {
    private boolean follow;
    private boolean logAll;

    @Override
    protected void executeInternal(DockerAccess access) throws MojoExecutionException, DockerAccessException {
        QueryService queryService = this.serviceHub.getQueryService();
        LogDispatcher logDispatcher = this.getLogDispatcher(access);
        for (ImageConfiguration image : this.getImages()) {
            String imageName = image.getName();
            if (this.logAll) {
                for (Container container : queryService.getContainersForImage(imageName)) {
                    this.doLogging(logDispatcher, image, container.getId());
                }
                continue;
            }
            Container container = queryService.getLatestContainerForImage(imageName);
            this.doLogging(logDispatcher, image, container.getId());
        }
        if (this.follow) {
            this.waitForEver();
        }
    }

    private void doLogging(LogDispatcher logDispatcher, ImageConfiguration imageConfig, String container) throws MojoExecutionException {
        LogOutputSpec spec = this.serviceHub.getLogOutputSpecFactory().createSpec(container, imageConfig);
        try {
            if (this.follow) {
                logDispatcher.trackContainerLog(container, spec);
            } else {
                logDispatcher.fetchContainerLog(container, spec);
            }
        }
        catch (FileNotFoundException e) {
            throw new MojoExecutionException("Can not log to file " + spec.getFile());
        }
    }

    private synchronized void waitForEver() {
        while (true) {
            try {
                while (true) {
                    ((Object)((Object)this)).wait();
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }
}

