/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.docker.maven;

import org.apache.maven.plugin.MojoExecutionException;
import org.jolokia.docker.maven.AbstractDockerMojo;
import org.jolokia.docker.maven.access.AuthConfig;
import org.jolokia.docker.maven.access.DockerAccess;
import org.jolokia.docker.maven.access.DockerAccessException;
import org.jolokia.docker.maven.config.BuildImageConfiguration;
import org.jolokia.docker.maven.config.ImageConfiguration;
import org.jolokia.docker.maven.util.ImageName;

public class PushMojo
extends AbstractDockerMojo {
    @Override
    public void executeInternal(DockerAccess docker) throws DockerAccessException, MojoExecutionException {
        for (ImageConfiguration imageConfig : this.getImages()) {
            BuildImageConfiguration buildConfig = imageConfig.getBuildConfiguration();
            String name = imageConfig.getName();
            if (buildConfig == null) continue;
            String configuredRegistry = this.getConfiguredRegistry(imageConfig);
            AuthConfig authConfig = this.prepareAuthConfig(name, configuredRegistry);
            docker.pushImage(name, authConfig, configuredRegistry);
            for (String tag : imageConfig.getBuildConfiguration().getTags()) {
                if (tag == null) continue;
                docker.pushImage(new ImageName(name, tag).getFullName(), authConfig, configuredRegistry);
            }
        }
    }
}

