/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.docker.maven;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.commons.lang3.text.StrSubstitutor;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.util.StringUtils;
import org.jolokia.docker.maven.AbstractDockerMojo;
import org.jolokia.docker.maven.access.DockerAccess;
import org.jolokia.docker.maven.access.DockerAccessException;
import org.jolokia.docker.maven.access.PortMapping;
import org.jolokia.docker.maven.access.log.LogCallback;
import org.jolokia.docker.maven.access.log.LogGetHandle;
import org.jolokia.docker.maven.config.ImageConfiguration;
import org.jolokia.docker.maven.config.LogConfiguration;
import org.jolokia.docker.maven.config.RunImageConfiguration;
import org.jolokia.docker.maven.config.WaitConfiguration;
import org.jolokia.docker.maven.log.LogDispatcher;
import org.jolokia.docker.maven.service.QueryService;
import org.jolokia.docker.maven.service.RunService;
import org.jolokia.docker.maven.util.StartOrderResolver;
import org.jolokia.docker.maven.util.Timestamp;
import org.jolokia.docker.maven.util.WaitUtil;

public class StartMojo
extends AbstractDockerMojo {
    private String showLogs;
    protected boolean follow;

    @Override
    public synchronized void executeInternal(DockerAccess dockerAccess) throws DockerAccessException, MojoExecutionException {
        this.getPluginContext().put("CONTEXT_KEY_DOCKER_START_CALLED", true);
        Properties projProperties = this.project.getProperties();
        QueryService queryService = this.serviceHub.getQueryService();
        RunService runService = this.serviceHub.getRunService();
        LogDispatcher dispatcher = this.getLogDispatcher(dockerAccess);
        PortMapping.PropertyWriteHelper portMappingPropertyWriteHelper = new PortMapping.PropertyWriteHelper(this.portPropertyFile);
        boolean success = false;
        try {
            for (StartOrderResolver.Resolvable resolvable : runService.getImagesConfigsInOrder(queryService, this.getImages())) {
                ImageConfiguration imageConfig = (ImageConfiguration)resolvable;
                String imageName = imageConfig.getName();
                this.checkImageWithAutoPull(dockerAccess, imageName, this.getConfiguredRegistry(imageConfig), imageConfig.getBuildConfiguration() == null);
                RunImageConfiguration runConfig = imageConfig.getRunConfiguration();
                PortMapping portMapping = runService.getPortMapping(runConfig, projProperties);
                String containerId = runService.createAndStartContainer(imageConfig, portMapping, projProperties);
                if (this.showLogs(imageConfig)) {
                    dispatcher.trackContainerLog(containerId, this.serviceHub.getLogOutputSpecFactory().createSpec(containerId, imageConfig));
                }
                portMappingPropertyWriteHelper.add(portMapping, runConfig.getPortPropertyFile());
                this.waitIfRequested(dockerAccess, imageConfig, projProperties, containerId);
                WaitConfiguration waitConfig = runConfig.getWaitConfiguration();
                if (waitConfig == null || waitConfig.getExec() == null || waitConfig.getExec().getPostStart() == null) continue;
                runService.execInContainer(containerId, waitConfig.getExec().getPostStart(), imageConfig);
            }
            if (this.follow) {
                runService.addShutdownHookForStoppingContainers(this.keepContainer, this.removeVolumes);
                ((Object)((Object)this)).wait();
            }
            portMappingPropertyWriteHelper.write();
            success = true;
        }
        catch (InterruptedException e) {
            this.log.warn("Interrupted");
            Thread.currentThread().interrupt();
            throw new MojoExecutionException("interrupted", (Exception)e);
        }
        catch (IOException e) {
            throw new MojoExecutionException("I/O Error", (Exception)e);
        }
        finally {
            if (!success) {
                this.log.error("Error occurred during container startup, shutting down...");
                runService.stopStartedContainers(this.keepContainer, this.removeVolumes);
            }
        }
    }

    private void waitIfRequested(DockerAccess docker, ImageConfiguration imageConfig, Properties projectProperties, String containerId) throws MojoExecutionException {
        RunImageConfiguration runConfig = imageConfig.getRunConfiguration();
        WaitConfiguration wait = runConfig.getWaitConfiguration();
        if (wait == null) {
            return;
        }
        ArrayList<WaitUtil.WaitChecker> checkers = new ArrayList<WaitUtil.WaitChecker>();
        ArrayList<String> logOut = new ArrayList<String>();
        if (wait.getUrl() != null) {
            String waitUrl = StrSubstitutor.replace((Object)wait.getUrl(), (Properties)projectProperties);
            WaitConfiguration.HttpConfiguration httpConfig = wait.getHttp();
            if (httpConfig != null) {
                checkers.add(new WaitUtil.HttpPingChecker(waitUrl, httpConfig.getMethod(), httpConfig.getStatus()));
            } else {
                checkers.add(new WaitUtil.HttpPingChecker(waitUrl));
            }
            logOut.add("on url " + waitUrl);
        }
        if (wait.getLog() != null) {
            checkers.add(this.getLogWaitChecker(wait.getLog(), docker, containerId));
            logOut.add("on log out '" + wait.getLog() + "'");
        }
        if (checkers.isEmpty()) {
            if (wait.getTime() > 0) {
                this.log.info(imageConfig.getDescription() + ": Pausing for " + wait.getTime() + " ms");
                WaitUtil.sleep(wait.getTime());
            }
            return;
        }
        try {
            long waited = WaitUtil.wait(wait.getTime(), checkers);
            this.log.info(imageConfig.getDescription() + ": Waited " + StringUtils.join((Object[])logOut.toArray(), (String)" and ") + " " + waited + " ms");
        }
        catch (WaitUtil.WaitTimeoutException exp) {
            String desc = imageConfig.getDescription() + ": Timeout after " + exp.getWaited() + " ms while waiting " + StringUtils.join((Object[])logOut.toArray(), (String)" and ");
            this.log.error(desc);
            throw new MojoExecutionException(desc);
        }
    }

    private WaitUtil.WaitChecker getLogWaitChecker(final String logPattern, final DockerAccess docker, final String containerId) {
        return new WaitUtil.WaitChecker(){
            boolean first = true;
            LogGetHandle logHandle;
            boolean detected = false;

            @Override
            public boolean check() {
                if (this.first) {
                    final Pattern pattern = Pattern.compile(logPattern);
                    this.logHandle = docker.getLogAsync(containerId, new LogCallback(){

                        @Override
                        public void log(int type, Timestamp timestamp, String txt) throws LogCallback.DoneException {
                            if (pattern.matcher(txt).find()) {
                                detected = true;
                                throw new LogCallback.DoneException();
                            }
                        }

                        @Override
                        public void error(String error) {
                            StartMojo.this.log.error(error);
                        }
                    });
                    this.first = false;
                }
                return this.detected;
            }

            @Override
            public void cleanUp() {
                if (this.logHandle != null) {
                    this.logHandle.finish();
                }
            }
        };
    }

    protected boolean showLogs(ImageConfiguration imageConfig) {
        if (this.showLogs != null) {
            if (this.showLogs.equalsIgnoreCase("true")) {
                return true;
            }
            if (this.showLogs.equalsIgnoreCase("false")) {
                return false;
            }
            return this.matchesConfiguredImages(this.showLogs, imageConfig);
        }
        RunImageConfiguration runConfig = imageConfig.getRunConfiguration();
        if (runConfig != null) {
            LogConfiguration logConfig = runConfig.getLog();
            if (logConfig != null) {
                return logConfig.isEnabled();
            }
            return this.follow;
        }
        return false;
    }
}

