/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.docker.maven;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.util.StringUtils;
import org.jolokia.docker.maven.AbstractBuildSupportMojo;
import org.jolokia.docker.maven.access.DockerAccess;
import org.jolokia.docker.maven.access.DockerAccessException;
import org.jolokia.docker.maven.access.PortMapping;
import org.jolokia.docker.maven.assembly.AssemblyFiles;
import org.jolokia.docker.maven.config.ImageConfiguration;
import org.jolokia.docker.maven.config.WatchImageConfiguration;
import org.jolokia.docker.maven.config.WatchMode;
import org.jolokia.docker.maven.service.BuildService;
import org.jolokia.docker.maven.service.QueryService;
import org.jolokia.docker.maven.service.RunService;
import org.jolokia.docker.maven.util.MojoParameters;
import org.jolokia.docker.maven.util.StartOrderResolver;

public class WatchMojo
extends AbstractBuildSupportMojo {
    private WatchMode watchMode;
    private int watchInterval;
    private boolean keepRunning;
    private String watchPostGoal;
    private String watchPostExec;
    private ScheduledExecutorService executor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized void executeInternal(DockerAccess dockerAccess) throws DockerAccessException, MojoExecutionException {
        this.executor = Executors.newSingleThreadScheduledExecutor();
        QueryService queryService = this.serviceHub.getQueryService();
        RunService runService = this.serviceHub.getRunService();
        MojoParameters mojoParameters = this.createMojoParameters();
        try {
            for (StartOrderResolver.Resolvable resolvable : runService.getImagesConfigsInOrder(queryService, this.getImages())) {
                ImageConfiguration imageConfig = (ImageConfiguration)resolvable;
                String imageId = queryService.getImageId(imageConfig.getName());
                String containerId = runService.lookupContainer(imageConfig.getName());
                ImageWatcher watcher = new ImageWatcher(imageConfig, imageId, containerId);
                long interval = watcher.getInterval();
                ArrayList<String> tasks = new ArrayList<String>();
                if (imageConfig.getBuildConfiguration() != null && imageConfig.getBuildConfiguration().getAssemblyConfiguration() != null) {
                    if (watcher.isCopy()) {
                        String containerBaseDir = imageConfig.getBuildConfiguration().getAssemblyConfiguration().getBasedir();
                        this.schedule(this.createCopyWatchTask(dockerAccess, watcher, mojoParameters, containerBaseDir), interval);
                        tasks.add("copying artifacts");
                    }
                    if (watcher.isBuild()) {
                        this.schedule(this.createBuildWatchTask(dockerAccess, watcher, mojoParameters, this.watchMode == WatchMode.both), interval);
                        tasks.add("rebuilding");
                    }
                }
                if (watcher.isRun() && watcher.getContainerId() != null) {
                    this.schedule(this.createRestartWatchTask(dockerAccess, watcher), interval);
                    tasks.add("restarting");
                }
                if (tasks.size() <= 0) continue;
                this.log.info(imageConfig.getDescription() + ": Watch for " + StringUtils.join((Object[])tasks.toArray(), (String)" and "));
            }
            this.log.info("Waiting ...");
            if (!this.keepRunning) {
                runService.addShutdownHookForStoppingContainers(this.keepContainer, this.removeVolumes);
            }
            ((Object)((Object)this)).wait();
        }
        catch (InterruptedException e) {
            this.log.warn("Interrupted");
        }
        finally {
            this.executor.shutdownNow();
        }
    }

    private void schedule(Runnable runnable, long interval) {
        this.executor.scheduleAtFixedRate(runnable, 0L, interval, TimeUnit.MILLISECONDS);
    }

    private Runnable createCopyWatchTask(final DockerAccess docker, final ImageWatcher watcher, final MojoParameters mojoParameters, final String containerBaseDir) throws MojoExecutionException {
        final ImageConfiguration imageConfig = watcher.getImageConfiguration();
        final BuildService buildService = this.serviceHub.getBuildService();
        final AssemblyFiles files = buildService.getAssemblyFiles(imageConfig, mojoParameters);
        return new Runnable(){

            @Override
            public void run() {
                List<AssemblyFiles.Entry> entries = files.getUpdatedEntriesAndRefresh();
                if (entries != null && entries.size() > 0) {
                    try {
                        WatchMojo.this.log.info(imageConfig.getDescription() + ": Assembly changed. Copying changed files to container ...");
                        File changedFilesArchive = buildService.createChangedFilesArchive(entries, files.getAssemblyDirectory(), imageConfig.getName(), mojoParameters);
                        docker.copyArchive(watcher.getContainerId(), changedFilesArchive, containerBaseDir);
                        WatchMojo.this.callPostExec(WatchMojo.this.serviceHub.getRunService(), watcher);
                    }
                    catch (IOException | MojoExecutionException e) {
                        WatchMojo.this.log.error(imageConfig.getDescription() + ": Error when copying files to container " + watcher.getContainerId() + ": " + e);
                    }
                }
            }
        };
    }

    private void callPostExec(RunService runService, ImageWatcher watcher) throws DockerAccessException {
        if (watcher.getPostExec() != null) {
            String containerId = watcher.getContainerId();
            runService.execInContainer(containerId, watcher.getPostExec(), watcher.getImageConfiguration());
        }
    }

    private Runnable createBuildWatchTask(final DockerAccess docker, final ImageWatcher watcher, MojoParameters mojoParameters, final boolean doRestart) throws MojoExecutionException {
        final ImageConfiguration imageConfig = watcher.getImageConfiguration();
        final AssemblyFiles files = this.serviceHub.getBuildService().getAssemblyFiles(imageConfig, mojoParameters);
        return new Runnable(){

            @Override
            public void run() {
                List<AssemblyFiles.Entry> entries = files.getUpdatedEntriesAndRefresh();
                if (entries != null && entries.size() > 0) {
                    try {
                        WatchMojo.this.log.info(imageConfig.getDescription() + ": Assembly changed. Rebuild ...");
                        WatchMojo.this.buildImage(docker, imageConfig);
                        String name = imageConfig.getName();
                        watcher.setImageId(WatchMojo.this.serviceHub.getQueryService().getImageId(name));
                        if (doRestart) {
                            WatchMojo.this.restartContainer(watcher);
                        }
                        WatchMojo.this.callPostGoal(watcher);
                    }
                    catch (IOException | MojoExecutionException | MojoFailureException e) {
                        WatchMojo.this.log.error(imageConfig.getDescription() + ": Error when rebuilding " + e);
                    }
                }
            }
        };
    }

    private Runnable createRestartWatchTask(DockerAccess docker, final ImageWatcher watcher) throws DockerAccessException {
        final String imageName = watcher.getImageName();
        return new Runnable(){

            @Override
            public void run() {
                try {
                    String currentImageId = WatchMojo.this.serviceHub.getQueryService().getImageId(imageName);
                    String oldValue = watcher.getAndSetImageId(currentImageId);
                    if (!currentImageId.equals(oldValue)) {
                        WatchMojo.this.restartContainer(watcher);
                        WatchMojo.this.callPostGoal(watcher);
                    }
                }
                catch (MojoExecutionException | MojoFailureException | DockerAccessException e) {
                    WatchMojo.this.log.warn(watcher.getImageConfiguration().getDescription() + ": Error when restarting image " + e);
                }
            }
        };
    }

    private void restartContainer(ImageWatcher watcher) throws DockerAccessException {
        RunService runService = this.serviceHub.getRunService();
        ImageConfiguration imageConfig = watcher.getImageConfiguration();
        PortMapping mappedPorts = runService.getPortMapping(imageConfig.getRunConfiguration(), this.project.getProperties());
        String id = watcher.getContainerId();
        String optionalPreStop = this.getPreStopCommand(imageConfig);
        if (optionalPreStop != null) {
            runService.execInContainer(id, optionalPreStop, watcher.getImageConfiguration());
        }
        runService.stopContainer(id, false, false);
        watcher.setContainerId(runService.createAndStartContainer(imageConfig, mappedPorts, this.project.getProperties()));
    }

    private String getPreStopCommand(ImageConfiguration imageConfig) {
        if (imageConfig.getRunConfiguration() != null && imageConfig.getRunConfiguration().getWaitConfiguration() != null && imageConfig.getRunConfiguration().getWaitConfiguration().getExec() != null) {
            return imageConfig.getRunConfiguration().getWaitConfiguration().getExec().getPreStop();
        }
        return null;
    }

    private void callPostGoal(ImageWatcher watcher) throws MojoFailureException, MojoExecutionException {
        String postGoal = watcher.getPostGoal();
        if (postGoal != null) {
            this.serviceHub.getMojoExecutionService().callPluginGoal(postGoal);
        }
    }

    private class ImageWatcher {
        private final WatchMode mode;
        private final AtomicReference<String> imageIdRef;
        private final AtomicReference<String> containerIdRef;
        private final long interval;
        private final ImageConfiguration imageConfig;
        private final String postGoal;
        private String postExec;

        public ImageWatcher(ImageConfiguration imageConfig, String imageId, String containerIdRef) {
            this.imageConfig = imageConfig;
            this.imageIdRef = new AtomicReference<String>(imageId);
            this.containerIdRef = new AtomicReference<String>(containerIdRef);
            this.interval = this.getWatchInterval(imageConfig);
            this.mode = this.getWatchMode(imageConfig);
            this.postGoal = this.getPostGoal(imageConfig);
            this.postExec = this.getPostExec(imageConfig);
        }

        public String getContainerId() {
            return this.containerIdRef.get();
        }

        public long getInterval() {
            return this.interval;
        }

        public String getPostGoal() {
            return this.postGoal;
        }

        public boolean isCopy() {
            return this.mode.isCopy();
        }

        public boolean isBuild() {
            return this.mode.isBuild();
        }

        public boolean isRun() {
            return this.mode.isRun();
        }

        public ImageConfiguration getImageConfiguration() {
            return this.imageConfig;
        }

        public void setImageId(String imageId) {
            this.imageIdRef.set(imageId);
        }

        public void setContainerId(String containerId) {
            this.containerIdRef.set(containerId);
        }

        public String getImageName() {
            return this.imageConfig.getName();
        }

        public String getAndSetImageId(String currentImageId) {
            return this.imageIdRef.getAndSet(currentImageId);
        }

        public String getPostExec() {
            return this.postExec;
        }

        private int getWatchInterval(ImageConfiguration imageConfig) {
            WatchImageConfiguration watchConfig = imageConfig.getWatchConfiguration();
            int interval = watchConfig != null ? watchConfig.getInterval() : WatchMojo.this.watchInterval;
            return interval < 100 ? 100 : interval;
        }

        private String getPostExec(ImageConfiguration imageConfig) {
            WatchImageConfiguration watchConfig = imageConfig.getWatchConfiguration();
            return watchConfig != null && watchConfig.getPostExec() != null ? watchConfig.getPostExec() : WatchMojo.this.watchPostExec;
        }

        private String getPostGoal(ImageConfiguration imageConfig) {
            WatchImageConfiguration watchConfig = imageConfig.getWatchConfiguration();
            return watchConfig != null && watchConfig.getPostGoal() != null ? watchConfig.getPostGoal() : WatchMojo.this.watchPostGoal;
        }

        private WatchMode getWatchMode(ImageConfiguration imageConfig) {
            WatchImageConfiguration watchConfig = imageConfig.getWatchConfiguration();
            WatchMode mode = watchConfig != null ? watchConfig.getMode() : null;
            return mode != null ? mode : WatchMojo.this.watchMode;
        }
    }
}

