/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.docker.maven.access;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jolokia.docker.maven.access.PortMapping;
import org.json.JSONArray;
import org.json.JSONObject;

public class ContainerHostConfig {
    final JSONObject startConfig = new JSONObject();

    public ContainerHostConfig binds(List<String> bind) {
        if (bind != null && !bind.isEmpty()) {
            JSONArray binds = new JSONArray();
            for (String volume : bind) {
                if (!volume.contains(":")) continue;
                volume = volume.replace("\\", "/").replaceAll("^(?i:C:)", "/c");
                binds.put((Object)volume);
            }
            this.startConfig.put("Binds", (Object)binds);
        }
        return this;
    }

    public ContainerHostConfig capAdd(List<String> capAdd) {
        return this.addAsArray("CapAdd", capAdd);
    }

    public ContainerHostConfig capDrop(List<String> capDrop) {
        return this.addAsArray("CapDrop", capDrop);
    }

    public ContainerHostConfig dns(List<String> dns) {
        return this.addAsArray("Dns", dns);
    }

    public ContainerHostConfig dnsSearch(List<String> dnsSearch) {
        return this.addAsArray("DnsSearch", dnsSearch);
    }

    public ContainerHostConfig extraHosts(List<String> extraHosts) throws IllegalArgumentException {
        if (extraHosts != null) {
            ArrayList<String> mapped = new ArrayList<String>();
            for (int i = 0; i < extraHosts.size(); ++i) {
                String[] parts = extraHosts.get(i).split(":");
                if (parts.length == 1) {
                    throw new IllegalArgumentException("extraHosts must be in the form <host:host|ip>");
                }
                try {
                    mapped.add(i, parts[0] + ":" + InetAddress.getByName(parts[1]).getHostAddress());
                    continue;
                }
                catch (UnknownHostException e) {
                    throw new IllegalArgumentException("unable to resolve ip address for " + parts[1], e);
                }
            }
            return this.addAsArray("ExtraHosts", mapped);
        }
        return this;
    }

    public ContainerHostConfig volumesFrom(List<String> volumesFrom) {
        return this.addAsArray("VolumesFrom", volumesFrom);
    }

    public ContainerHostConfig links(List<String> links) {
        return this.addAsArray("Links", links);
    }

    public ContainerHostConfig portBindings(PortMapping portMapping) {
        Map<String, Integer> portMap = portMapping.getContainerPortToHostPortMap();
        if (!portMap.isEmpty()) {
            JSONObject portBindings = new JSONObject();
            Map<String, String> bindToMap = portMapping.getBindToHostMap();
            for (Map.Entry<String, Integer> entry : portMap.entrySet()) {
                String containerPortSpec = entry.getKey();
                Integer hostPort = entry.getValue();
                JSONObject o = new JSONObject();
                o.put("HostPort", (Object)(hostPort != null ? hostPort.toString() : ""));
                if (bindToMap.containsKey(containerPortSpec)) {
                    o.put("HostIp", (Object)bindToMap.get(containerPortSpec));
                }
                JSONArray array = new JSONArray();
                array.put((Object)o);
                portBindings.put(containerPortSpec, (Object)array);
            }
            this.startConfig.put("PortBindings", (Object)portBindings);
        }
        return this;
    }

    public ContainerHostConfig privileged(Boolean privileged) {
        return this.add("Privileged", privileged);
    }

    public ContainerHostConfig restartPolicy(String name, int retry) {
        if (name != null) {
            JSONObject policy = new JSONObject();
            policy.put("Name", (Object)name);
            policy.put("MaximumRetryCount", retry);
            this.startConfig.put("RestartPolicy", (Object)policy);
        }
        return this;
    }

    public String toJson() {
        return this.startConfig.toString();
    }

    public Object toJsonObject() {
        return this.startConfig;
    }

    ContainerHostConfig addAsArray(String propKey, List<String> props) {
        if (props != null) {
            this.startConfig.put(propKey, (Object)new JSONArray(props));
        }
        return this;
    }

    private ContainerHostConfig add(String name, Object value) {
        if (value != null) {
            this.startConfig.put(name, value);
        }
        return this;
    }
}

