/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.docker.maven.access.hc.unix;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.DnsResolver;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.jolokia.docker.maven.access.hc.unix.UnixConnectionSocketFactory;

public class UnixSocketClientBuilder {
    public CloseableHttpClient build(String unixSocketPath, int maxConnections) {
        HttpClientBuilder httpBuilder = HttpClients.custom();
        Registry<ConnectionSocketFactory> registry = this.buildRegistry(unixSocketPath);
        DnsResolver dnsResolver = this.nullDnsResolver();
        PoolingHttpClientConnectionManager manager = new PoolingHttpClientConnectionManager(registry, dnsResolver);
        manager.setDefaultMaxPerRoute(maxConnections);
        httpBuilder.setConnectionManager((HttpClientConnectionManager)manager);
        return httpBuilder.build();
    }

    private Registry<ConnectionSocketFactory> buildRegistry(String path) {
        RegistryBuilder registryBuilder = RegistryBuilder.create();
        registryBuilder.register("unix", (Object)new UnixConnectionSocketFactory(path));
        return registryBuilder.build();
    }

    private DnsResolver nullDnsResolver() {
        return new DnsResolver(){

            public InetAddress[] resolve(String host) throws UnknownHostException {
                return new InetAddress[]{null};
            }
        };
    }
}

