/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.docker.maven.assembly;

import java.io.File;
import org.jolokia.docker.maven.util.EnvUtil;
import org.jolokia.docker.maven.util.MojoParameters;

class BuildDirs {
    private final String buildTopDir;
    private final MojoParameters params;

    BuildDirs(String imageName, MojoParameters params) {
        this.params = params;
        this.buildTopDir = imageName != null ? imageName.replace(':', '/') : null;
    }

    File getOutputDirectory() {
        return this.getDir("build");
    }

    File getWorkingDirectory() {
        return this.getDir("work");
    }

    File getTemporaryRootDirectory() {
        return this.getDir("tmp");
    }

    void createDirs() {
        for (String workDir : new String[]{"build", "work", "tmp"}) {
            File dir = this.getDir(workDir);
            if (dir.exists() || dir.mkdirs()) continue;
            throw new IllegalArgumentException("Cannot create directory " + dir.getAbsolutePath());
        }
    }

    private File getDir(String dir) {
        return EnvUtil.prepareAbsoluteOutputDirPath(this.params, this.buildTopDir, dir);
    }
}

