/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.docker.maven.assembly;

import java.io.File;
import java.util.Collections;
import java.util.List;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.assembly.AssemblerConfigurationSource;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.filtering.MavenFileFilter;
import org.apache.maven.shared.filtering.MavenReaderFilter;
import org.jolokia.docker.maven.assembly.BuildDirs;
import org.jolokia.docker.maven.config.AssemblyConfiguration;
import org.jolokia.docker.maven.util.EnvUtil;
import org.jolokia.docker.maven.util.MojoParameters;

public class DockerAssemblyConfigurationSource
implements AssemblerConfigurationSource {
    private final AssemblyConfiguration assemblyConfig;
    private final MojoParameters params;
    private final BuildDirs buildDirs;

    public DockerAssemblyConfigurationSource(MojoParameters params, BuildDirs buildDirs, AssemblyConfiguration assemblyConfig) {
        this.params = params;
        this.assemblyConfig = assemblyConfig;
        this.buildDirs = buildDirs;
    }

    public String[] getDescriptors() {
        String descriptor;
        if (this.assemblyConfig != null && (descriptor = this.assemblyConfig.getDescriptor()) != null) {
            return new String[]{EnvUtil.prepareAbsoluteSourceDirPath(this.params, descriptor).getAbsolutePath()};
        }
        return new String[0];
    }

    public String[] getDescriptorReferences() {
        String descriptorRef;
        if (this.assemblyConfig != null && (descriptorRef = this.assemblyConfig.getDescriptorRef()) != null) {
            return new String[]{descriptorRef};
        }
        return null;
    }

    public File getOutputDirectory() {
        return this.buildDirs.getOutputDirectory();
    }

    public File getWorkingDirectory() {
        return this.buildDirs.getWorkingDirectory();
    }

    public File getTemporaryRootDirectory() {
        return this.buildDirs.getTemporaryRootDirectory();
    }

    public String getFinalName() {
        return ".";
    }

    public ArtifactRepository getLocalRepository() {
        return this.params.getSession().getLocalRepository();
    }

    public MavenFileFilter getMavenFileFilter() {
        return this.params.getMavenFileFilter();
    }

    public List<MavenProject> getReactorProjects() {
        return this.params.getProject().getCollectedProjects();
    }

    public List<ArtifactRepository> getRemoteRepositories() {
        return this.params.getProject().getRemoteArtifactRepositories();
    }

    public MavenSession getMavenSession() {
        return this.params.getSession();
    }

    public MavenArchiveConfiguration getJarArchiveConfiguration() {
        return this.params.getArchiveConfiguration();
    }

    public String getEncoding() {
        return this.params.getProject().getProperties().getProperty("project.build.sourceEncoding");
    }

    public String getEscapeString() {
        return null;
    }

    public List<String> getDelimiters() {
        return null;
    }

    public MavenProject getProject() {
        return this.params.getProject();
    }

    public File getBasedir() {
        return this.params.getProject().getBasedir();
    }

    public boolean isIgnoreDirFormatExtensions() {
        return true;
    }

    public boolean isDryRun() {
        return false;
    }

    public String getClassifier() {
        return null;
    }

    public List<String> getFilters() {
        return Collections.emptyList();
    }

    public boolean isIncludeProjectBuildFilters() {
        return true;
    }

    public File getDescriptorSourceDirectory() {
        return null;
    }

    public File getArchiveBaseDirectory() {
        return null;
    }

    public String getDescriptorId() {
        return null;
    }

    public String getDescriptor() {
        return null;
    }

    public String getTarLongFileMode() {
        return "warn";
    }

    public File getSiteDirectory() {
        return null;
    }

    public boolean isSiteIncluded() {
        return false;
    }

    public boolean isAssemblyIdAppended() {
        return false;
    }

    public boolean isIgnoreMissingDescriptor() {
        return false;
    }

    public String getArchiverConfig() {
        return null;
    }

    public MavenReaderFilter getMavenReaderFilter() {
        return this.params.getMavenFilterReader();
    }

    public boolean isUpdateOnly() {
        return false;
    }

    public boolean isUseJvmChmod() {
        return false;
    }

    public boolean isIgnorePermissions() {
        return this.assemblyConfig != null ? this.assemblyConfig.isIgnorePermissions() : false;
    }
}

