/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.docker.maven.assembly;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.assembly.AssemblerConfigurationSource;
import org.apache.maven.plugin.assembly.InvalidAssemblerConfigurationException;
import org.apache.maven.plugin.assembly.archive.ArchiveCreationException;
import org.apache.maven.plugin.assembly.archive.AssemblyArchiver;
import org.apache.maven.plugin.assembly.format.AssemblyFormattingException;
import org.apache.maven.plugin.assembly.io.AssemblyReadException;
import org.apache.maven.plugin.assembly.io.AssemblyReader;
import org.apache.maven.plugin.assembly.model.Assembly;
import org.apache.maven.shared.utils.PathTool;
import org.apache.maven.shared.utils.io.FileUtils;
import org.codehaus.plexus.archiver.ArchivedFileSet;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.FileSet;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;
import org.codehaus.plexus.archiver.tar.TarArchiver;
import org.codehaus.plexus.archiver.tar.TarLongFileMode;
import org.codehaus.plexus.archiver.util.DefaultArchivedFileSet;
import org.codehaus.plexus.archiver.util.DefaultFileSet;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.jolokia.docker.maven.assembly.AssemblyFiles;
import org.jolokia.docker.maven.assembly.BuildDirs;
import org.jolokia.docker.maven.assembly.DockerAssemblyConfigurationSource;
import org.jolokia.docker.maven.assembly.DockerFileBuilder;
import org.jolokia.docker.maven.assembly.MappingTrackArchiver;
import org.jolokia.docker.maven.config.Arguments;
import org.jolokia.docker.maven.config.AssemblyConfiguration;
import org.jolokia.docker.maven.config.AssemblyMode;
import org.jolokia.docker.maven.config.BuildImageConfiguration;
import org.jolokia.docker.maven.util.EnvUtil;
import org.jolokia.docker.maven.util.Logger;
import org.jolokia.docker.maven.util.MojoParameters;

@Component(role=DockerAssemblyManager.class)
public class DockerAssemblyManager {
    public static final String DEFAULT_DATA_BASE_IMAGE = "busybox:latest";
    public static final String ASSEMBLY_NAME = "maven";
    @Requirement
    private AssemblyArchiver assemblyArchiver;
    @Requirement
    private AssemblyReader assemblyReader;
    @Requirement
    private ArchiverManager archiverManager;
    @Requirement(hint="track")
    private Archiver trackArchiver;

    public File createDockerTarArchive(String imageName, MojoParameters params, BuildImageConfiguration buildConfig) throws MojoExecutionException {
        AssemblyMode assemblyMode;
        BuildDirs buildDirs = this.createBuildDirs(imageName, params);
        AssemblyConfiguration assemblyConfig = buildConfig.getAssemblyConfiguration();
        AssemblyMode assemblyMode2 = assemblyMode = assemblyConfig == null ? AssemblyMode.dir : assemblyConfig.getMode();
        if (this.hasAssemblyConfiguration(assemblyConfig)) {
            this.createAssemblyArchive(assemblyConfig, params, buildDirs);
        }
        try {
            String dockerFileDir;
            File extraDir = null;
            String string = dockerFileDir = assemblyConfig != null ? assemblyConfig.getDockerFileDir() : null;
            if (dockerFileDir != null) {
                extraDir = this.validateDockerDir(params, dockerFileDir);
            } else {
                DockerFileBuilder builder = this.createDockerFileBuilder(buildConfig, assemblyConfig);
                builder.write(buildDirs.getOutputDirectory());
            }
            return this.createBuildTarBall(buildDirs, extraDir, assemblyMode);
        }
        catch (IOException e) {
            throw new MojoExecutionException(String.format("Cannot create Dockerfile in %s", buildDirs.getOutputDirectory()), (Exception)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AssemblyFiles getAssemblyFiles(String name, BuildImageConfiguration buildConfig, MojoParameters mojoParams, Logger log) throws InvalidAssemblerConfigurationException, ArchiveCreationException, AssemblyFormattingException, MojoExecutionException {
        BuildDirs buildDirs = this.createBuildDirs(name, mojoParams);
        AssemblyConfiguration assemblyConfig = buildConfig.getAssemblyConfiguration();
        DockerAssemblyConfigurationSource source = new DockerAssemblyConfigurationSource(mojoParams, buildDirs, assemblyConfig);
        Assembly assembly = this.getAssemblyConfig(assemblyConfig, source);
        Archiver archiver = this.trackArchiver;
        synchronized (archiver) {
            MappingTrackArchiver ta = (MappingTrackArchiver)this.trackArchiver;
            ta.init(log);
            assembly.setId("tracker");
            this.assemblyArchiver.createArchive(assembly, ASSEMBLY_NAME, "track", (AssemblerConfigurationSource)source, false);
            return ta.getAssemblyFiles();
        }
    }

    private BuildDirs createBuildDirs(String imageName, MojoParameters params) {
        BuildDirs buildDirs = new BuildDirs(imageName, params);
        buildDirs.createDirs();
        return buildDirs;
    }

    private boolean hasAssemblyConfiguration(AssemblyConfiguration assemblyConfig) {
        return assemblyConfig != null && !assemblyConfig.skip && (assemblyConfig.getInline() != null || assemblyConfig.getDescriptor() != null || assemblyConfig.getDescriptorRef() != null);
    }

    private File validateDockerDir(MojoParameters params, String dockerFileDir) throws MojoExecutionException {
        File dockerDir = EnvUtil.prepareAbsoluteSourceDirPath(params, dockerFileDir);
        if (!new File(dockerDir, "Dockerfile").exists()) {
            throw new MojoExecutionException("Specified dockerFileDir \"" + dockerFileDir + "\" (resolved to \"" + dockerDir + "\") " + " doesn't contain a 'Dockerfile'");
        }
        return dockerDir;
    }

    public File createChangedFilesArchive(List<AssemblyFiles.Entry> entries, File assemblyDirectory, String imageName, MojoParameters mojoParameters) throws MojoExecutionException {
        BuildDirs dirs = this.createBuildDirs(imageName, mojoParameters);
        try {
            File archive = new File(dirs.getTemporaryRootDirectory(), "changed-files.tar");
            File archiveDir = this.createArchiveDir(dirs);
            for (AssemblyFiles.Entry entry : entries) {
                File dest = this.prepareChangedFilesArchivePath(archiveDir, entry.getDestFile(), assemblyDirectory);
                FileUtils.copyFile((File)entry.getSrcFile(), (File)dest);
            }
            return this.createChangedFilesTarBall(archive, archiveDir);
        }
        catch (IOException exp) {
            throw new MojoExecutionException("Error while creating " + dirs.getTemporaryRootDirectory() + "/changed-files.tar: " + exp);
        }
    }

    private File prepareChangedFilesArchivePath(File archiveDir, File destFile, File assemblyDir) throws IOException {
        String relativePath = PathTool.getRelativeFilePath((String)assemblyDir.getCanonicalPath(), (String)destFile.getCanonicalPath());
        return new File(archiveDir, relativePath);
    }

    private File createBuildTarBall(BuildDirs buildDirs, File extraDir, AssemblyMode buildMode) throws MojoExecutionException {
        File archive = new File(buildDirs.getTemporaryRootDirectory(), "docker-build.tar");
        try {
            TarArchiver archiver = this.createBuildArchiver(buildDirs.getOutputDirectory(), archive, buildMode);
            if (extraDir != null) {
                archiver.addFileSet((FileSet)DefaultFileSet.fileSet((File)extraDir));
            } else {
                archiver.addFile(new File(buildDirs.getOutputDirectory(), "Dockerfile"), "Dockerfile");
            }
            archiver.createArchive();
            return archive;
        }
        catch (NoSuchArchiverException e) {
            throw new MojoExecutionException("No archiver for type 'tar' found", (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Cannot create archive " + archive, (Exception)e);
        }
    }

    private File createChangedFilesTarBall(File archive, File archiveDir) throws MojoExecutionException {
        try {
            TarArchiver archiver = (TarArchiver)this.archiverManager.getArchiver("tar");
            archiver.setLongfile(TarLongFileMode.posix);
            archiver.addFileSet((FileSet)DefaultFileSet.fileSet((File)archiveDir));
            archiver.setDestFile(archive);
            archiver.createArchive();
            return archive;
        }
        catch (NoSuchArchiverException e) {
            throw new MojoExecutionException("No archiver for type 'tar' found", (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Cannot create archive " + archive, (Exception)e);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            throw e;
        }
    }

    private File createArchiveDir(BuildDirs dirs) throws IOException, MojoExecutionException {
        File archiveDir = new File(dirs.getTemporaryRootDirectory(), "changed-files");
        if (archiveDir.exists()) {
            FileUtils.cleanDirectory((File)archiveDir);
        } else if (!archiveDir.mkdir()) {
            throw new MojoExecutionException("Cannot create " + archiveDir);
        }
        return archiveDir;
    }

    private TarArchiver createBuildArchiver(File outputDir, File archive, AssemblyMode buildMode) throws NoSuchArchiverException {
        TarArchiver archiver = (TarArchiver)this.archiverManager.getArchiver("tar");
        archiver.setLongfile(TarLongFileMode.posix);
        if (buildMode.isArchive()) {
            DefaultArchivedFileSet archiveSet = DefaultArchivedFileSet.archivedFileSet((File)new File(outputDir, "maven." + buildMode.getExtension()));
            archiveSet.setPrefix("maven/");
            archiveSet.setIncludingEmptyDirectories(true);
            archiver.addArchivedFileSet((ArchivedFileSet)archiveSet);
        } else {
            archiver.addFileSet((FileSet)DefaultFileSet.fileSet((File)outputDir));
        }
        archiver.setDestFile(archive);
        return archiver;
    }

    DockerFileBuilder createDockerFileBuilder(BuildImageConfiguration buildConfig, AssemblyConfiguration assemblyConfig) {
        DockerFileBuilder builder = new DockerFileBuilder().env(buildConfig.getEnv()).labels(buildConfig.getLabels()).expose(buildConfig.getPorts()).run(buildConfig.getRunCmds()).volumes(buildConfig.getVolumes());
        if (buildConfig.getMaintainer() != null) {
            builder.maintainer(buildConfig.getMaintainer());
        }
        if (buildConfig.getWorkdir() != null) {
            builder.workdir(buildConfig.getWorkdir());
        }
        if (assemblyConfig != null) {
            builder.add(ASSEMBLY_NAME, "").basedir(assemblyConfig.getBasedir()).user(assemblyConfig.getUser()).exportBasedir(assemblyConfig.exportBasedir());
        } else {
            builder.exportBasedir(false);
        }
        builder.baseImage(buildConfig.getFrom());
        if (buildConfig.getCmd() != null) {
            builder.cmd(buildConfig.getCmd());
        } else if (buildConfig.getCommand() != null) {
            Arguments args = Arguments.Builder.get().withShell(buildConfig.getCommand()).build();
            builder.cmd(args);
        }
        if (buildConfig.getEntryPoint() != null) {
            builder.entryPoint(buildConfig.getEntryPoint());
        }
        if (buildConfig.optimise()) {
            builder.optimise();
        }
        return builder;
    }

    private void createAssemblyArchive(AssemblyConfiguration assemblyConfig, MojoParameters params, BuildDirs buildDirs) throws MojoExecutionException {
        DockerAssemblyConfigurationSource source = new DockerAssemblyConfigurationSource(params, buildDirs, assemblyConfig);
        Assembly assembly = this.getAssemblyConfig(assemblyConfig, source);
        AssemblyMode buildMode = assemblyConfig.getMode();
        try {
            assembly.setId("docker");
            this.assemblyArchiver.createArchive(assembly, ASSEMBLY_NAME, buildMode.getExtension(), (AssemblerConfigurationSource)source, false);
        }
        catch (ArchiveCreationException | AssemblyFormattingException e) {
            throw new MojoExecutionException("Failed to create assembly for docker image: " + e.getMessage() + " with mode " + (Object)((Object)buildMode), (Exception)e);
        }
        catch (InvalidAssemblerConfigurationException e) {
            throw new MojoExecutionException((Object)assembly, "Assembly is incorrectly configured: " + assembly.getId(), "Assembly: " + assembly.getId() + " is not configured correctly: " + e.getMessage());
        }
    }

    private Assembly getAssemblyConfig(AssemblyConfiguration assemblyConfig, DockerAssemblyConfigurationSource source) throws MojoExecutionException {
        Assembly assembly = assemblyConfig.getInline();
        if (assembly == null) {
            assembly = this.extractAssembly(source);
        }
        return assembly;
    }

    private Assembly extractAssembly(AssemblerConfigurationSource config) throws MojoExecutionException {
        try {
            List assemblies = this.assemblyReader.readAssemblies(config);
            if (assemblies.size() != 1) {
                throw new MojoExecutionException("Only one assembly can be used for creating a Docker base image (and not " + assemblies.size() + ")");
            }
            return (Assembly)assemblies.get(0);
        }
        catch (AssemblyReadException e) {
            throw new MojoExecutionException("Error reading assembly: " + e.getMessage(), (Exception)((Object)e));
        }
        catch (InvalidAssemblerConfigurationException e) {
            throw new MojoExecutionException((Object)this.assemblyReader, e.getMessage(), "Docker assembly configuration is invalid: " + e.getMessage());
        }
    }
}

