/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.docker.maven.config;

import org.apache.maven.plugin.assembly.model.Assembly;
import org.jolokia.docker.maven.config.AssemblyMode;

public class AssemblyConfiguration {
    private static final String DEFAULT_BASE_DIR = "/maven";
    private String basedir;
    private String descriptor;
    private Assembly inline;
    private String descriptorRef;
    private String dockerFileDir;
    private Boolean exportBasedir;
    private Boolean ignorePermissions;
    private AssemblyMode mode;
    private String user;
    public boolean skip;

    public Boolean exportBasedir() {
        return this.exportBasedir;
    }

    public String getBasedir() {
        return this.basedir != null ? this.basedir : DEFAULT_BASE_DIR;
    }

    public Assembly getInline() {
        return this.inline;
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    public String getDescriptorRef() {
        return this.descriptorRef;
    }

    public String getDockerFileDir() {
        return this.dockerFileDir;
    }

    public String getUser() {
        return this.user;
    }

    public AssemblyMode getMode() {
        return this.mode != null ? this.mode : AssemblyMode.dir;
    }

    public Boolean isIgnorePermissions() {
        return this.ignorePermissions != null ? this.ignorePermissions : Boolean.FALSE;
    }

    public static class Builder {
        private final AssemblyConfiguration config = new AssemblyConfiguration();
        private boolean isEmpty = true;

        public AssemblyConfiguration build() {
            return this.isEmpty ? null : this.config;
        }

        public Builder basedir(String baseDir) {
            this.config.basedir = this.set(baseDir);
            return this;
        }

        public Builder assemblyDef(Assembly descriptor) {
            this.config.inline = this.set(descriptor);
            return this;
        }

        public Builder descriptor(String descriptorFile) {
            this.config.descriptor = this.set(descriptorFile);
            return this;
        }

        public Builder descriptorRef(String descriptorRef) {
            this.config.descriptorRef = this.set(descriptorRef);
            return this;
        }

        public Builder dockerFileDir(String dockerFileDir) {
            this.config.dockerFileDir = this.set(dockerFileDir);
            return this;
        }

        public Builder exportBasedir(Boolean export) {
            this.config.exportBasedir = this.set(export);
            return this;
        }

        public Builder ignorePermissions(Boolean ignorePermissions) {
            this.config.ignorePermissions = this.set(ignorePermissions);
            return this;
        }

        public Builder user(String user) {
            this.config.user = this.set(user);
            return this;
        }

        public Builder mode(String mode) {
            if (mode != null) {
                this.config.mode = AssemblyMode.valueOf(mode.toLowerCase());
                this.isEmpty = false;
            }
            return this;
        }

        private <T> T set(T prop) {
            if (prop != null) {
                this.isEmpty = false;
            }
            return prop;
        }
    }
}

