/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.docker.maven.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jolokia.docker.maven.config.BuildImageConfiguration;
import org.jolokia.docker.maven.config.RunImageConfiguration;
import org.jolokia.docker.maven.config.VolumeConfiguration;
import org.jolokia.docker.maven.config.WatchImageConfiguration;
import org.jolokia.docker.maven.util.EnvUtil;
import org.jolokia.docker.maven.util.Logger;
import org.jolokia.docker.maven.util.StartOrderResolver;

public class ImageConfiguration
implements StartOrderResolver.Resolvable {
    private String name;
    private String alias;
    private RunImageConfiguration run;
    private BuildImageConfiguration build;
    private WatchImageConfiguration watch;
    private Map<String, String> external;
    private String registry;

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    public RunImageConfiguration getRunConfiguration() {
        return this.run == null ? RunImageConfiguration.DEFAULT : this.run;
    }

    public BuildImageConfiguration getBuildConfiguration() {
        return this.build;
    }

    public WatchImageConfiguration getWatchConfiguration() {
        return this.watch;
    }

    public Map<String, String> getExternalConfig() {
        return this.external;
    }

    @Override
    public List<String> getDependencies() {
        RunImageConfiguration runConfig = this.getRunConfiguration();
        ArrayList<String> ret = new ArrayList<String>();
        if (runConfig != null) {
            this.addVolumes(runConfig, ret);
            this.addLinks(runConfig, ret);
        }
        return ret;
    }

    private void addVolumes(RunImageConfiguration runConfig, List<String> ret) {
        List<String> volumeImages;
        VolumeConfiguration volConfig = runConfig.getVolumeConfiguration();
        if (volConfig != null && (volumeImages = volConfig.getFrom()) != null) {
            ret.addAll(volumeImages);
        }
    }

    private void addLinks(RunImageConfiguration runConfig, List<String> ret) {
        if (runConfig.getLinks() != null) {
            for (String[] link : EnvUtil.splitOnLastColon(runConfig.getLinks())) {
                ret.add(link[0]);
            }
        }
    }

    public boolean isDataImage() {
        return this.getRunConfiguration() == null;
    }

    public String getDescription() {
        return String.format("[%s] %s", this.name, this.alias != null ? "\"" + this.alias + "\"" : "");
    }

    public String getRegistry() {
        return this.registry;
    }

    public String toString() {
        return String.format("ImageConfiguration {name='%s', alias='%s'}", this.name, this.alias);
    }

    public void validate(Logger log) {
        if (null != this.build) {
            this.build.validate(log);
        }
        if (null != this.run) {
            this.run.validate();
        }
    }

    public static class Builder {
        private ImageConfiguration config = new ImageConfiguration();

        public Builder name(String name) {
            this.config.name = name;
            return this;
        }

        public Builder alias(String alias) {
            this.config.alias = alias;
            return this;
        }

        public Builder runConfig(RunImageConfiguration runConfig) {
            this.config.run = runConfig;
            return this;
        }

        public Builder buildConfig(BuildImageConfiguration buildConfig) {
            this.config.build = buildConfig;
            return this;
        }

        public Builder externalConfig(Map<String, String> externalConfig) {
            this.config.external = externalConfig;
            return this;
        }

        public ImageConfiguration build() {
            return this.config;
        }

        public Builder watchConfig(WatchImageConfiguration watchConfig) {
            this.config.watch = watchConfig;
            return this;
        }
    }
}

